/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Image;
import java.io.File;
import java.security.AllPermission;
import java.security.Policy;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.jnlp.ServiceManager;
import javax.swing.ImageIcon;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.cache.DefaultDownloadIndicator;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPPolicy;
import net.sourceforge.jnlp.runtime.JNLPSecurityManager;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.PropertiesFile;
import sun.misc.Launcher;

public class JNLPRuntime {
    private static ResourceBundle resources;
    private static JNLPSecurityManager security;
    private static JNLPPolicy policy;
    private static File baseDir;
    private static LaunchHandler handler;
    private static DownloadIndicator indicator;
    private static UpdatePolicy updatePolicy;
    private static Image windowIcon;
    private static boolean initialized;
    private static boolean headless;
    private static boolean verify;
    private static boolean securityEnabled;
    private static boolean debug;
    public static Object initMutex;
    private static boolean isWebstartApplication;
    private static boolean forksAllowed;
    private static List<String> initialArguments;
    private static final String USER;
    private static final String HOME_DIR;
    private static final String NETXRC_FILE;
    private static final String NETX_DIR;
    private static final String SECURITY_DIR;
    private static final String CERTIFICATES_FILE;
    private static final String TMP_DIR;
    private static final String LOCKS_DIR;
    private static final String JAVA_HOME_DIR;
    private static final String NETX_ABOUT_FILE;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize(boolean isApplication) throws IllegalStateException {
        JNLPRuntime.checkInitialized();
        isWebstartApplication = isApplication;
        System.setProperty("javawebstart.version", "javaws-" + System.getProperty("java.version"));
        if (!headless) {
            JNLPRuntime.checkHeadless();
        }
        if (!headless && windowIcon == null) {
            JNLPRuntime.loadWindowIcon();
        }
        if (!headless && indicator == null) {
            indicator = new DefaultDownloadIndicator();
        }
        if (handler == null) {
            handler = new DefaultLaunchHandler();
        }
        if (baseDir == null) {
            baseDir = JNLPRuntime.getDefaultBaseDir();
        }
        if (baseDir == null) {
            throw new IllegalStateException(JNLPRuntime.getMessage("BNoBase"));
        }
        ServiceManager.setServiceManagerStub(new XServiceManagerStub());
        policy = new JNLPPolicy();
        security = new JNLPSecurityManager();
        if (securityEnabled) {
            Policy.setPolicy(policy);
            System.setSecurityManager(security);
        }
        initialized = true;
    }

    public static boolean isWebstartApplication() {
        return isWebstartApplication;
    }

    public static Image getWindowIcon() {
        return windowIcon;
    }

    public static void setWindowIcon(Image image) {
        JNLPRuntime.checkExitClass();
        windowIcon = image;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static boolean isVerifying() {
        return verify;
    }

    public static void setHeadless(boolean enabled) {
        JNLPRuntime.checkInitialized();
        headless = enabled;
    }

    public static void setVerify(boolean enabled) {
        JNLPRuntime.checkInitialized();
        verify = enabled;
    }

    public static File getBaseDir() {
        return baseDir;
    }

    public static void setBaseDir(File baseDirectory) {
        JNLPRuntime.checkInitialized();
        baseDir = baseDirectory;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        JNLPRuntime.checkInitialized();
        securityEnabled = enabled;
    }

    public static File getDefaultBaseDir() {
        PropertiesFile props = JNLPRuntime.getProperties();
        String baseStr = props.getProperty("basedir");
        if (baseStr != null) {
            return new File(baseStr);
        }
        String homeDir = HOME_DIR;
        File baseDir = new File(NETX_DIR);
        if (homeDir == null || !baseDir.isDirectory() && !baseDir.mkdir()) {
            return null;
        }
        props.setProperty("basedir", baseDir.toString());
        props.store();
        return baseDir;
    }

    public static void setExitClass(Class exitClass) {
        JNLPRuntime.checkExitClass();
        security.setExitClass(exitClass);
    }

    public static void disableExit() {
        security.disableExit();
    }

    public static ApplicationInstance getApplication() {
        return security.getApplication();
    }

    public static PropertiesFile getProperties() {
        File netxrc = new File(NETXRC_FILE);
        return new PropertiesFile(netxrc);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean enabled) {
        JNLPRuntime.checkExitClass();
        debug = enabled;
    }

    public static void setDefaultUpdatePolicy(UpdatePolicy policy) {
        JNLPRuntime.checkExitClass();
        updatePolicy = policy;
    }

    public static UpdatePolicy getDefaultUpdatePolicy() {
        return updatePolicy;
    }

    public static void setDefaultLaunchHandler(LaunchHandler handler) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.handler = handler;
    }

    public static LaunchHandler getDefaultLaunchHandler() {
        return handler;
    }

    public static void setDefaultDownloadIndicator(DownloadIndicator indicator) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.indicator = indicator;
    }

    public static DownloadIndicator getDefaultDownloadIndicator() {
        return indicator;
    }

    public static String getMessage(String key) {
        try {
            String result = resources.getString(key);
            if (result.length() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            if (!key.equals("RNoResource")) {
                return JNLPRuntime.getMessage("RNoResource", new Object[]{key});
            }
            return "Missing resource: " + key;
        }
    }

    public static String getMessage(String key, Object[] args) {
        return MessageFormat.format(JNLPRuntime.getMessage(key), args);
    }

    public static boolean getForksAllowed() {
        return forksAllowed;
    }

    public static void setForksAllowed(boolean value) {
        JNLPRuntime.checkInitialized();
        forksAllowed = value;
    }

    private static void checkInitialized() {
        if (initialized) {
            throw new IllegalStateException("JNLPRuntime already initialized.");
        }
    }

    private static void checkExitClass() {
        if (securityEnabled && initialized && !security.isExitClass()) {
            throw new IllegalStateException("Caller is not the exit class");
        }
    }

    private static void checkHeadless() {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("java.awt.headless"))) {
                headless = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("net.sourceforge.jnlp.resources.Messages");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Missing resource bundle in netx.jar:net/sourceforge/jnlp/resource/Messages.properties");
        }
    }

    private static void loadWindowIcon() {
        block3: {
            if (windowIcon != null) {
                return;
            }
            try {
                windowIcon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/netx-icon.png")).getImage();
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void setInitialArgments(List<String> args) {
        JNLPRuntime.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        initialArguments = args;
    }

    public static List<String> getInitialArguments() {
        return initialArguments;
    }

    public static String getCertificatesFile() {
        System.getProperty("user.home");
        return CERTIFICATES_FILE;
    }

    public static String getHomeDir() {
        System.getProperty("user.home");
        return HOME_DIR;
    }

    public static String getAboutFile() {
        System.getProperty("java.home");
        return NETX_ABOUT_FILE;
    }

    public static String getLocksDir() {
        System.getProperty("user.home");
        System.getProperty("java.io.tmpdir");
        return LOCKS_DIR;
    }

    public static String getTempDir() {
        System.getProperty("java.io.tmpdir");
        return TMP_DIR;
    }

    static {
        JNLPRuntime.loadResources();
        handler = null;
        indicator = null;
        updatePolicy = UpdatePolicy.ALWAYS;
        windowIcon = null;
        initialized = false;
        headless = false;
        verify = true;
        securityEnabled = true;
        debug = false;
        initMutex = new Object();
        forksAllowed = true;
        USER = System.getProperty("user.name");
        HOME_DIR = System.getProperty("user.home");
        NETXRC_FILE = HOME_DIR + File.separator + ".netxrc";
        NETX_DIR = HOME_DIR + File.separator + ".netx";
        SECURITY_DIR = NETX_DIR + File.separator + "security";
        CERTIFICATES_FILE = SECURITY_DIR + File.separator + "trusted.certs";
        TMP_DIR = System.getProperty("java.io.tmpdir");
        LOCKS_DIR = TMP_DIR + File.separator + USER + File.separator + "netx" + File.separator + "locks";
        JAVA_HOME_DIR = System.getProperty("java.home");
        NETX_ABOUT_FILE = JAVA_HOME_DIR + File.separator + "lib" + File.separator + "about.jnlp";
    }
}

