/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import javax.swing.event.EventListenerList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.event.ApplicationEvent;
import net.sourceforge.jnlp.event.ApplicationListener;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.XDesktopEntry;

public class ApplicationInstance {
    private JNLPFile file;
    private ThreadGroup group;
    private ClassLoader loader;
    private boolean stopped = false;
    private WeakList weakWindows = new WeakList();
    private EventListenerList listeners = new EventListenerList();
    private boolean isSigned = false;

    public ApplicationInstance(JNLPFile file, ThreadGroup group, ClassLoader loader) {
        this.file = file;
        this.group = group;
        this.loader = loader;
        this.isSigned = ((JNLPClassLoader)loader).getSigning();
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.listeners.add(ApplicationListener.class, listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(ApplicationListener.class, listener);
    }

    protected void fireDestroyed() {
        Object[] list = this.listeners.getListenerList();
        ApplicationEvent event = null;
        for (int i = list.length - 1; i > 0; i -= 2) {
            if (event == null) {
                event = new ApplicationEvent(this);
            }
            ((ApplicationListener)list[i]).applicationDestroyed(event);
        }
    }

    public void initialize() {
        this.installEnvironment();
        this.addMenuAndDesktopEntries();
    }

    private void addMenuAndDesktopEntries() {
        XDesktopEntry entry = new XDesktopEntry(this.file);
        ShortcutDesc sd = this.file.getInformation().getShortcut();
        if (sd != null && sd.onDesktop() && ServiceUtil.checkAccess(this, SecurityWarningDialog.AccessType.CREATE_DESTKOP_SHORTCUT, new Object[0])) {
            entry.createDesktopShortcut();
        }
        if (sd != null && sd.getMenu() != null && JNLPRuntime.isDebug()) {
            System.err.println("ApplicationInstance.addMenuAndDesktopEntries(): Adding menu entries NOT IMPLEMENTED");
        }
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] props = this.file.getResources().getProperties();
        CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
        JNLPClassLoader loader = (JNLPClassLoader)this.loader;
        SecurityDesc s = loader.getSecurity();
        ProtectionDomain pd = new ProtectionDomain(cs, s.getPermissions(), null, null);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        PrivilegedAction installProps = new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < props.length; ++i) {
                    System.setProperty(props[i].getKey(), props[i].getValue());
                }
                return null;
            }
        };
        AccessController.doPrivileged(installProps, acc);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int i;
            for (int i2 = 0; i2 < this.weakWindows.size(); ++i2) {
                Window w = (Window)this.weakWindows.get(i2);
                if (w == null) continue;
                w.dispose();
            }
            this.weakWindows.clear();
            Thread[] threads = new Thread[this.group.activeCount() * 2];
            int nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Interrupt thread: " + threads[i]);
                }
                threads[i].interrupt();
            }
            Thread.currentThread();
            Thread.yield();
            nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Stop thread: " + threads[i]);
                }
                threads[i].stop();
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    public boolean isSigned() {
        return this.isSigned;
    }
}

