/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    private MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    private MetalBumps focusBumps = new MetalBumps(10, 10, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), UIManager.getColor("SplitPane.dividerFocusColor"));
    private int inset = 2;
    private Color controlColor = MetalLookAndFeel.getControl();
    private Color primaryControlColor = UIManager.getColor("SplitPane.dividerFocusColor");

    public MetalSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
    }

    public void paint(Graphics g) {
        MetalBumps usedBumps;
        if (this.splitPane.hasFocus()) {
            usedBumps = this.focusBumps;
            g.setColor(this.primaryControlColor);
        } else {
            usedBumps = this.bumps;
            g.setColor(this.controlColor);
        }
        Rectangle clip = g.getClipBounds();
        Insets insets = this.getInsets();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension size = this.getSize();
        size.width -= this.inset * 2;
        size.height -= this.inset * 2;
        int drawX = this.inset;
        int drawY = this.inset;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            drawX += insets.left;
            drawY += insets.top;
        }
        usedBumps.setBumpArea(size);
        usedBumps.paintIcon(this, g, drawX, drawY);
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};

            public void setBorder(Border b) {
            }

            public void paint(Graphics g) {
                block8: {
                    JSplitPane splitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block8;
                    int oneTouchSize = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = MetalSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(MetalSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    if (this.isOpaque()) {
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        this.maybeMakeButtonOpaque(b);
        return b;
    }

    private void maybeMakeButtonOpaque(JComponent c) {
        Object opaque = UIManager.get("SplitPane.oneTouchButtonsOpaque");
        if (opaque != null) {
            c.setOpaque((Boolean)opaque);
        }
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};

            public void setBorder(Border border) {
            }

            public void paint(Graphics g) {
                block8: {
                    JSplitPane splitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block8;
                    int oneTouchSize = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = MetalSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(MetalSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    if (this.isOpaque()) {
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        this.maybeMakeButtonOpaque(b);
        return b;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public class MetalDividerLayout
    implements LayoutManager {
        public void layoutContainer(Container c) {
            JButton leftButton = MetalSplitPaneDivider.this.getLeftButtonFromSuper();
            JButton rightButton = MetalSplitPaneDivider.this.getRightButtonFromSuper();
            JSplitPane splitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
            int orientation = MetalSplitPaneDivider.this.getOrientationFromSuper();
            int oneTouchSize = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
            int oneTouchOffset = MetalSplitPaneDivider.this.getOneTouchOffsetFromSuper();
            Insets insets = MetalSplitPaneDivider.this.getInsets();
            if (leftButton != null && rightButton != null && c == MetalSplitPaneDivider.this) {
                if (splitPane.isOneTouchExpandable()) {
                    if (orientation == 0) {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = MetalSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(oneTouchOffset, extraY, blockSize * 2, blockSize);
                        rightButton.setBounds(oneTouchOffset + oneTouchSize * 2, extraY, blockSize * 2, blockSize);
                    } else {
                        int extraX;
                        int blockSize = MetalSplitPaneDivider.this.getDividerSize();
                        int n = extraX = insets != null ? insets.left : 0;
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(extraX, oneTouchOffset, blockSize, blockSize * 2);
                        rightButton.setBounds(extraX, oneTouchOffset + oneTouchSize * 2, blockSize, blockSize * 2);
                    }
                } else {
                    leftButton.setBounds(-5, -5, 1, 1);
                    rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }
}

