/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRowSet
implements Serializable,
Cloneable {
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rowSetType = 1004;
    private boolean showDeleted = false;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int concurrency = 1008;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    private Map map;
    private Vector listeners = new Vector();
    private Hashtable params;
    static final long serialVersionUID = 4886719666485113312L;

    protected void initParams() {
        this.params = new Hashtable();
    }

    public void addRowSetListener(RowSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeRowSetListener(RowSetListener listener) {
        this.listeners.remove(listener);
    }

    private void checkforRowSetInterface() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException("The class extending abstract class BaseRowSet must implement javax.sql.RowSet or one of it's sub-interfaces.");
        }
    }

    protected void notifyCursorMoved() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent event = new RowSetEvent((RowSet)((Object)this));
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((RowSetListener)i.next()).cursorMoved(event);
            }
        }
    }

    protected void notifyRowChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent event = new RowSetEvent((RowSet)((Object)this));
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((RowSetListener)i.next()).rowChanged(event);
            }
        }
    }

    protected void notifyRowSetChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent event = new RowSetEvent((RowSet)((Object)this));
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((RowSetListener)i.next()).rowSetChanged(event);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String cmd) throws SQLException {
        if (cmd == null) {
            this.command = null;
        } else {
            if (cmd.length() == 0) {
                throw new SQLException("Invalid command string detected. Cannot be of length less than 0");
            }
            if (this.params == null) {
                throw new SQLException("Set initParams() before setCommand");
            }
            this.params.clear();
            this.command = new String(cmd);
        }
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public void setUrl(String url) throws SQLException {
        if (url == null) {
            url = null;
        } else {
            if (url.length() < 1) {
                throw new SQLException("Invalid url string detected. Cannot be of length less than 1");
            }
            this.URL = new String(url);
        }
        this.dataSource = null;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String name) throws SQLException {
        if (name == null) {
            this.dataSource = null;
        } else {
            if (name.equals("")) {
                throw new SQLException("DataSource name cannot be empty string");
            }
            this.dataSource = new String(name);
        }
        this.URL = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) {
        this.username = name == null ? null : new String(name);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass == null ? null : new String(pass);
    }

    public void setType(int type) throws SQLException {
        if (type != 1003 && type != 1004 && type != 1005) {
            throw new SQLException("Invalid type of RowSet set. Must be either ResultSet.TYPE_FORWARD_ONLY or ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_SCROLL_SENSITIVE.");
        }
        this.rowSetType = type;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public void setConcurrency(int concurrency) throws SQLException {
        if (concurrency != 1007 && concurrency != 1008) {
            throw new SQLException("Invalid concurrency set. Must be either ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE.");
        }
        this.concurrency = concurrency;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 0 && level != 2 && level != 1 && level != 4 && level != 8) {
            throw new SQLException("Invalid transaction isolation set. Must be either Connection.TRANSACTION_NONE or Connection.TRANSACTION_READ_UNCOMMITTED or Connection.TRANSACTION_READ_COMMITTED or Connection.RRANSACTION_REPEATABLE_READ or Connection.TRANSACTION_SERIALIZABLE");
        }
        this.isolation = level;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.map;
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        this.map = map;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Invalid max field size set. Cannot be of value: " + max);
        }
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Invalid max row size set. Cannot be of value: " + max);
        }
        if (max < this.getFetchSize()) {
            throw new SQLException("Invalid max row size set. Cannot be less than the fetchSize.");
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Invalid query timeout value set. Cannot be of value: " + seconds);
        }
        this.queryTimeout = seconds;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean value) throws SQLException {
        this.showDeleted = value;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (this.getType() == 1003 && direction != 1000 || direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.fetchDir = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.getMaxRows() == 0 && rows >= 0) {
            this.fetchSize = rows;
            return;
        }
        if (rows < 0 || rows > this.getMaxRows()) {
            throw new SQLException("Invalid fetch size set. Cannot be of value: " + rows);
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private void checkParamIndex(int idx) throws SQLException {
        if (idx < 1) {
            throw new SQLException("Invalid Parameter Index");
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] nullVal = new Object[]{null, new Integer(sqlType)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(parameterIndex - 1), nullVal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] nullVal = new Object[]{null, new Integer(sqlType), new String(typeName)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(parameterIndex - 1), nullVal);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(parameterIndex - 1), new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setByte");
        }
        this.params.put(new Integer(parameterIndex - 1), new Byte(x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setShort");
        }
        this.params.put(new Integer(parameterIndex - 1), new Short(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setInt");
        }
        this.params.put(new Integer(parameterIndex - 1), new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setLong");
        }
        this.params.put(new Integer(parameterIndex - 1), new Long(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setFloat");
        }
        this.params.put(new Integer(parameterIndex - 1), new Float(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDouble");
        }
        this.params.put(new Integer(parameterIndex - 1), new Double(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBigDecimal");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setString");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBytes");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] asciiStream = new Object[]{x, new Integer(length), new Integer(2)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setAsciiStream");
        }
        this.params.put(new Integer(parameterIndex - 1), asciiStream);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] binaryStream = new Object[]{x, new Integer(length), new Integer(1)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBinaryStream");
        }
        this.params.put(new Integer(parameterIndex - 1), binaryStream);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] unicodeStream = new Object[]{x, new Integer(length), new Integer(0)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setUnicodeStream");
        }
        this.params.put(new Integer(parameterIndex - 1), unicodeStream);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] charStream = new Object[]{reader, new Integer(length)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setCharacterStream");
        }
        this.params.put(new Integer(parameterIndex - 1), charStream);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(targetSqlType), new Integer(scale)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(parameterIndex - 1), obj);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(targetSqlType)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(parameterIndex - 1), obj);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(parameterIndex - 1), x);
    }

    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setRef");
        }
        this.params.put(new Integer(parameterIndex - 1), new SerialRef(ref));
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBlob");
        }
        this.params.put(new Integer(parameterIndex - 1), new SerialBlob(x));
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setClob");
        }
        this.params.put(new Integer(parameterIndex - 1), new SerialClob(x));
    }

    public void setArray(int parameterIndex, Array array) throws SQLException {
        this.checkParamIndex(parameterIndex);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setArray");
        }
        this.params.put(new Integer(parameterIndex - 1), new SerialArray(array));
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] date = new Object[]{x, cal};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(new Integer(parameterIndex - 1), date);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] time = new Object[]{x, cal};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(new Integer(parameterIndex - 1), time);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkParamIndex(parameterIndex);
        Object[] timestamp = new Object[]{x, cal};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(new Integer(parameterIndex - 1), timestamp);
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        if (this.params == null) {
            this.initParams();
            Object[] paramsArray = new Object[this.params.size()];
            return paramsArray;
        }
        Object[] paramsArray = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            paramsArray[i] = this.params.get(new Integer(i));
            if (paramsArray[i] != null) continue;
            throw new SQLException("missing parameter: " + (i + 1));
        }
        return paramsArray;
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setShort(String parameterName, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setInt(String parameterName, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setLong(String parameterName, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setString(String parameterName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNString(String parameterName, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }
}

