/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.PartiallyOrderedSet;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubRegistry {
    ServiceRegistry registry;
    Class category;
    PartiallyOrderedSet poset = new PartiallyOrderedSet();
    Map<Class<?>, Object> map = new HashMap();

    public SubRegistry(ServiceRegistry registry, Class category) {
        this.registry = registry;
        this.category = category;
    }

    public boolean registerServiceProvider(Object provider) {
        boolean present;
        Object oprovider = this.map.get(provider.getClass());
        boolean bl = present = oprovider != null;
        if (present) {
            this.deregisterServiceProvider(oprovider);
        }
        this.map.put(provider.getClass(), provider);
        this.poset.add(provider);
        if (provider instanceof RegisterableService) {
            RegisterableService rs = (RegisterableService)provider;
            rs.onRegistration(this.registry, this.category);
        }
        return !present;
    }

    public boolean deregisterServiceProvider(Object provider) {
        Object oprovider = this.map.get(provider.getClass());
        if (provider == oprovider) {
            this.map.remove(provider.getClass());
            this.poset.remove(provider);
            if (provider instanceof RegisterableService) {
                RegisterableService rs = (RegisterableService)provider;
                rs.onDeregistration(this.registry, this.category);
            }
            return true;
        }
        return false;
    }

    public boolean contains(Object provider) {
        Object oprovider = this.map.get(provider.getClass());
        return oprovider == provider;
    }

    public boolean setOrdering(Object firstProvider, Object secondProvider) {
        return this.poset.setOrdering(firstProvider, secondProvider);
    }

    public boolean unsetOrdering(Object firstProvider, Object secondProvider) {
        return this.poset.unsetOrdering(firstProvider, secondProvider);
    }

    public Iterator getServiceProviders(boolean useOrdering) {
        if (useOrdering) {
            return this.poset.iterator();
        }
        return this.map.values().iterator();
    }

    public <T> T getServiceProviderByClass(Class<T> providerClass) {
        return (T)this.map.get(providerClass);
    }

    public void clear() {
        Iterator<Object> iter = this.map.values().iterator();
        while (iter.hasNext()) {
            Object provider = iter.next();
            iter.remove();
            if (!(provider instanceof RegisterableService)) continue;
            RegisterableService rs = (RegisterableService)provider;
            rs.onDeregistration(this.registry, this.category);
        }
        this.poset.clear();
    }

    public void finalize() {
        this.clear();
    }
}

