/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.GetPropertyAction;

public class Cursor
implements Serializable {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    protected static Cursor[] predefined = new Cursor[14];
    private static final Cursor[] predefinedPrivate = new Cursor[14];
    static final String[][] cursorProperties = new String[][]{{"AWT.DefaultCursor", "Default Cursor"}, {"AWT.CrosshairCursor", "Crosshair Cursor"}, {"AWT.TextCursor", "Text Cursor"}, {"AWT.WaitCursor", "Wait Cursor"}, {"AWT.SWResizeCursor", "Southwest Resize Cursor"}, {"AWT.SEResizeCursor", "Southeast Resize Cursor"}, {"AWT.NWResizeCursor", "Northwest Resize Cursor"}, {"AWT.NEResizeCursor", "Northeast Resize Cursor"}, {"AWT.NResizeCursor", "North Resize Cursor"}, {"AWT.SResizeCursor", "South Resize Cursor"}, {"AWT.WResizeCursor", "West Resize Cursor"}, {"AWT.EResizeCursor", "East Resize Cursor"}, {"AWT.HandCursor", "Hand Cursor"}, {"AWT.MoveCursor", "Move Cursor"}};
    int type = 0;
    public static final int CUSTOM_CURSOR = -1;
    private static final Hashtable systemCustomCursors = new Hashtable(1);
    private static final String systemCustomCursorDirPrefix = Cursor.initCursorDir();
    private static final String systemCustomCursorPropertiesFile = systemCustomCursorDirPrefix + "cursors.properties";
    private static Properties systemCustomCursorProperties = null;
    private static final String CursorDotPrefix = "Cursor.";
    private static final String DotFileSuffix = ".File";
    private static final String DotHotspotSuffix = ".HotSpot";
    private static final String DotNameSuffix = ".Name";
    private static final long serialVersionUID = 8028237497568985504L;
    private static final Logger log = Logger.getLogger("java.awt.Cursor");
    private transient long pData;
    private transient Object anchor = new Object();
    transient CursorDisposer disposer;
    protected String name;

    private static String initCursorDir() {
        String jhome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        return jhome + File.separator + "lib" + File.separator + "images" + File.separator + "cursors" + File.separator;
    }

    private static native void initIDs();

    private void setPData(long pData) {
        this.pData = pData;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (this.disposer == null) {
            this.disposer = new CursorDisposer(pData);
            if (this.anchor == null) {
                this.anchor = new Object();
            }
            Disposer.addRecord(this.anchor, this.disposer);
        } else {
            this.disposer.pData = pData;
        }
    }

    public static Cursor getPredefinedCursor(int type) {
        if (type < 0 || type > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        Cursor c = predefinedPrivate[type];
        if (c == null) {
            Cursor.predefinedPrivate[type] = c = new Cursor(type);
        }
        if (predefined[type] == null) {
            Cursor.predefined[type] = c;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor getSystemCustomCursor(String name) throws AWTException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        Cursor cursor = (Cursor)systemCustomCursors.get(name);
        if (cursor == null) {
            String hotspot;
            Hashtable hashtable = systemCustomCursors;
            synchronized (hashtable) {
                if (systemCustomCursorProperties == null) {
                    Cursor.loadSystemCustomCursorProperties();
                }
            }
            String prefix = CursorDotPrefix + name;
            String key = prefix + DotFileSuffix;
            if (!systemCustomCursorProperties.containsKey(key)) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Cursor.getSystemCustomCursor(" + name + ") returned null");
                }
                return null;
            }
            final String fileName = systemCustomCursorProperties.getProperty(key);
            String localized = systemCustomCursorProperties.getProperty(prefix + DotNameSuffix);
            if (localized == null) {
                localized = name;
            }
            if ((hotspot = systemCustomCursorProperties.getProperty(prefix + DotHotspotSuffix)) == null) {
                throw new AWTException("no hotspot property defined for cursor: " + name);
            }
            StringTokenizer st = new StringTokenizer(hotspot, ",");
            if (st.countTokens() != 2) {
                throw new AWTException("failed to parse hotspot property for cursor: " + name);
            }
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new AWTException("failed to parse hotspot property for cursor: " + name);
            }
            try {
                final int fx = x;
                final int fy = y;
                final String flocalized = localized;
                cursor = (Cursor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Image image = toolkit.getImage(systemCustomCursorDirPrefix + fileName);
                        return toolkit.createCustomCursor(image, new Point(fx, fy), flocalized);
                    }
                });
            }
            catch (Exception e) {
                throw new AWTException("Exception: " + e.getClass() + " " + e.getMessage() + " occurred while creating cursor " + name);
            }
            if (cursor == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Cursor.getSystemCustomCursor(" + name + ") returned null");
                }
            } else {
                systemCustomCursors.put(name, cursor);
            }
        }
        return cursor;
    }

    public static Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public Cursor(int type) {
        if (type < 0 || type > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.type = type;
        this.name = Toolkit.getProperty(cursorProperties[type][0], cursorProperties[type][1]);
    }

    protected Cursor(String name) {
        this.type = -1;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSystemCustomCursorProperties() throws AWTException {
        Hashtable hashtable = systemCustomCursors;
        synchronized (hashtable) {
            systemCustomCursorProperties = new Properties();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(systemCustomCursorPropertiesFile);
                            systemCustomCursorProperties.load(fis);
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                systemCustomCursorProperties = null;
                throw new AWTException("Exception: " + e.getClass() + " " + e.getMessage() + " occurred while loading: " + systemCustomCursorPropertiesFile);
            }
        }
    }

    private static native void finalizeImpl(long var0);

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Cursor.initIDs();
        }
    }

    static class CursorDisposer
    implements DisposerRecord {
        volatile long pData;

        public CursorDisposer(long pData) {
            this.pData = pData;
        }

        public void dispose() {
            if (this.pData != 0L) {
                Cursor.finalizeImpl(this.pData);
            }
        }
    }
}

