/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextField;

public class XTextFieldEditor
extends XTextField
implements TableCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            XTextFieldEditor.this.fireEditingStopped();
        }
    };

    public XTextFieldEditor() {
        this.textField.addFocusListener(this.editorFocusListener);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem || e.getSource() instanceof JTextField) {
            this.fireEditingStopped();
        }
    }

    protected void dropSuccess() {
        this.fireEditingStopped();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public Object getCellEditorValue() {
        Object object = this.getValue();
        if (object instanceof XObject) {
            return ((XObject)object).getObject();
        }
        return object;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String className;
        if (table instanceof XTable) {
            XTable mytable = (XTable)table;
            className = mytable.getClassName(row);
        } else {
            className = String.class.getName();
        }
        try {
            this.init(value, Utils.getClass(className));
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }
}

