/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.Utils;

public class XOpenTypeViewer
extends JPanel
implements ActionListener {
    JButton prev;
    JButton incr;
    JButton decr;
    JButton tabularPrev;
    JButton tabularNext;
    JLabel compositeLabel;
    JLabel tabularLabel;
    JScrollPane container;
    XOpenTypeData current;
    XOpenTypeDataListener listener = new XOpenTypeDataListener();
    private static final String compositeNavigationSingle = Resources.getText("MBeansTab.compositeNavigationSingle", new Object[0]);
    private static final String tabularNavigationSingle = Resources.getText("MBeansTab.tabularNavigationSingle", new Object[0]);
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public static boolean isViewableValue(Object value) {
        if (value instanceof CompositeData || value instanceof TabularData) {
            return true;
        }
        if (value instanceof CompositeData[] || value instanceof TabularData[]) {
            return Array.getLength(value) > 0;
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                return false;
            }
            return Utils.isUniformCollection(c, CompositeData.class) || Utils.isUniformCollection(c, TabularData.class);
        }
        return false;
    }

    public static Component loadOpenType(Object value) {
        XOpenTypeViewer comp = null;
        if (XOpenTypeViewer.isViewableValue(value)) {
            XOpenTypeViewer open;
            comp = open = new XOpenTypeViewer(value);
        }
        return comp;
    }

    private XOpenTypeViewer(Object value) {
        XCompositeData comp = null;
        if (value instanceof CompositeData) {
            comp = new XCompositeData(null, (CompositeData)value);
        } else if (value instanceof TabularData) {
            comp = new XTabularData(null, (TabularData)value);
        } else if (value instanceof CompositeData[]) {
            CompositeData[] cda = (CompositeData[])value;
            CompositeType ct = cda[0].getCompositeType();
            comp = new XArrayData(null, 1, ct, cda);
        } else if (value instanceof TabularData[]) {
            TabularData[] tda = (TabularData[])value;
            TabularType tt = tda[0].getTabularType();
            comp = new XArrayData(null, 1, tt, tda);
        } else if (value instanceof Collection) {
            Object e = ((Collection)value).iterator().next();
            if (e instanceof CompositeData) {
                Collection cdc = (Collection)value;
                CompositeData[] cda = cdc.toArray(new CompositeData[0]);
                CompositeType ct = cda[0].getCompositeType();
                comp = new XArrayData(null, 1, ct, cda);
            } else if (e instanceof TabularData) {
                Collection tdc = (Collection)value;
                TabularData[] tda = tdc.toArray(new TabularData[0]);
                TabularType tt = tda[0].getTabularType();
                comp = new XArrayData(null, 1, tt, tda);
            }
        }
        this.setupDisplay(comp);
        try {
            ((XOpenTypeData)comp).viewed(this);
        }
        catch (Exception e) {
            System.out.println("Exception viewing openType : " + e);
        }
    }

    void setOpenType(XOpenTypeData data) {
        boolean hasMoreThanOneElement;
        if (this.current != null) {
            this.current.removeMouseListener(this.listener);
        }
        this.current = data;
        if (this.current.getViewedParent() == null) {
            this.prev.setEnabled(false);
        } else {
            this.prev.setEnabled(true);
        }
        this.current.addMouseListener(this.listener);
        if (!(data instanceof XViewedTabularData)) {
            this.tabularPrev.setEnabled(false);
            this.tabularNext.setEnabled(false);
            this.tabularLabel.setText(tabularNavigationSingle);
            this.tabularLabel.setEnabled(false);
        } else {
            XViewedTabularData tabular = (XViewedTabularData)((Object)data);
            this.tabularNext.setEnabled(tabular.canIncrement());
            this.tabularPrev.setEnabled(tabular.canDecrement());
            boolean bl = hasMoreThanOneElement = tabular.canIncrement() || tabular.canDecrement();
            if (hasMoreThanOneElement) {
                this.tabularLabel.setText(Resources.getText("MBeansTab.tabularNavigationMultiple", String.format("%d", tabular.getSelectedElementIndex() + 1), String.format("%d", tabular.getElementCount())));
            } else {
                this.tabularLabel.setText(tabularNavigationSingle);
            }
            this.tabularLabel.setEnabled(hasMoreThanOneElement);
        }
        if (!(data instanceof XViewedArrayData)) {
            this.incr.setEnabled(false);
            this.decr.setEnabled(false);
            this.compositeLabel.setText(compositeNavigationSingle);
            this.compositeLabel.setEnabled(false);
        } else {
            XViewedArrayData array = (XViewedArrayData)((Object)data);
            this.incr.setEnabled(array.canIncrement());
            this.decr.setEnabled(array.canDecrement());
            boolean bl = hasMoreThanOneElement = array.canIncrement() || array.canDecrement();
            if (hasMoreThanOneElement) {
                this.compositeLabel.setText(Resources.getText("MBeansTab.compositeNavigationMultiple", String.format("%d", array.getSelectedElementIndex() + 1), String.format("%d", array.getElementCount())));
            } else {
                this.compositeLabel.setText(compositeNavigationSingle);
            }
            this.compositeLabel.setEnabled(hasMoreThanOneElement);
        }
        this.container.invalidate();
        this.container.setViewportView(this.current);
        this.container.validate();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JButton) {
            JButton b = (JButton)event.getSource();
            if (b == this.prev) {
                XOpenTypeData parent = this.current.getViewedParent();
                try {
                    parent.viewed(this);
                }
                catch (Exception e) {}
            } else if (b == this.incr) {
                ((XViewedArrayData)((Object)this.current)).incrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception e) {}
            } else if (b == this.decr) {
                ((XViewedArrayData)((Object)this.current)).decrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception e) {}
            } else if (b == this.tabularNext) {
                ((XViewedTabularData)((Object)this.current)).incrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception e) {}
            } else if (b == this.tabularPrev) {
                ((XViewedTabularData)((Object)this.current)).decrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void setupDisplay(XOpenTypeData data) {
        this.setBackground(Color.white);
        this.container = new JScrollPane(data, 20, 30);
        JPanel buttons = new JPanel(new FlowLayout(0));
        this.tabularPrev = new JButton(Resources.getText("<", new Object[0]));
        this.tabularNext = new JButton(Resources.getText(">", new Object[0]));
        JPanel tabularButtons = new JPanel(new FlowLayout(0));
        tabularButtons.add(this.tabularPrev);
        this.tabularPrev.addActionListener(this);
        this.tabularLabel = new JLabel(tabularNavigationSingle);
        this.tabularLabel.setEnabled(false);
        tabularButtons.add(this.tabularLabel);
        tabularButtons.add(this.tabularNext);
        this.tabularNext.addActionListener(this);
        tabularButtons.setBackground(Color.white);
        this.prev = new JButton(Resources.getText("<<", new Object[0]));
        this.prev.addActionListener(this);
        buttons.add(this.prev);
        this.incr = new JButton(Resources.getText(">", new Object[0]));
        this.incr.addActionListener(this);
        this.decr = new JButton(Resources.getText("<", new Object[0]));
        this.decr.addActionListener(this);
        JPanel array = new JPanel();
        array.setBackground(Color.white);
        array.add(this.decr);
        this.compositeLabel = new JLabel(compositeNavigationSingle);
        this.compositeLabel.setEnabled(false);
        array.add(this.compositeLabel);
        array.add(this.incr);
        buttons.add(array);
        this.setLayout(new BorderLayout());
        buttons.setBackground(Color.white);
        JPanel navigationPanel = new JPanel(new BorderLayout());
        navigationPanel.setBackground(Color.white);
        navigationPanel.add((Component)tabularButtons, "North");
        navigationPanel.add((Component)buttons, "West");
        this.add((Component)navigationPanel, "North");
        this.add((Component)this.container, "West");
        Dimension d = new Dimension((int)this.container.getPreferredSize().getWidth() + 20, (int)this.container.getPreferredSize().getHeight() + 20);
        this.setPreferredSize(d);
    }

    static class XArrayData
    extends XCompositeData
    implements XViewedArrayData {
        private int dimension;
        private int size;
        private OpenType elemType;
        private Object val;
        private boolean isCompositeType;
        private boolean isTabularType;
        private int currentIndex;
        private CompositeData[] elements;
        private final String[] arrayColumns = new String[]{Resources.getText("Value", new Object[0])};
        private Font normalFont;
        private Font boldFont;

        XArrayData(XOpenTypeData parent, ArrayType type, Object val) {
            this(parent, type.getDimension(), type.getElementOpenType(), val);
        }

        XArrayData(XOpenTypeData parent, int dimension, OpenType elemType, Object val) {
            super(parent);
            this.dimension = dimension;
            this.elemType = elemType;
            this.val = val;
            String[] columns = null;
            if (dimension > 1) {
                return;
            }
            this.isCompositeType = elemType instanceof CompositeType;
            this.isTabularType = elemType instanceof TabularType;
            columns = this.isCompositeType ? this.columnNames : this.arrayColumns;
            this.initTable(columns);
            this.loadArray();
        }

        public void viewed(XOpenTypeViewer viewer) throws Exception {
            if (this.size == 0) {
                throw new Exception(Resources.getText("Empty array", new Object[0]));
            }
            if (this.dimension > 1) {
                throw new Exception(Resources.getText("Dimension is not supported:", new Object[0]) + this.dimension);
            }
            super.viewed(viewer);
        }

        public int getElementCount() {
            return this.size;
        }

        public int getSelectedElementIndex() {
            return this.currentIndex;
        }

        public void renderKey(String key, Component comp) {
            if (this.normalFont == null) {
                this.normalFont = comp.getFont();
                this.boldFont = this.normalFont.deriveFont(1);
            }
            if (this.isTabularType) {
                comp.setFont(this.boldFont);
            }
        }

        public void incrElement() {
            ++this.currentIndex;
            this.loadCompositeData(this.elements[this.currentIndex]);
        }

        public void decrElement() {
            --this.currentIndex;
            this.loadCompositeData(this.elements[this.currentIndex]);
        }

        public boolean canDecrement() {
            return this.isCompositeType && this.currentIndex > 0;
        }

        public boolean canIncrement() {
            return this.isCompositeType && this.currentIndex < this.size - 1;
        }

        private void loadArray() {
            if (this.isCompositeType) {
                this.elements = (CompositeData[])this.val;
                this.size = this.elements.length;
                if (this.size != 0) {
                    this.loadCompositeData(this.elements[0]);
                }
            } else {
                this.load();
            }
        }

        private void load() {
            Object[] rowData = new Object[1];
            this.size = Array.getLength(this.val);
            for (int i = 0; i < this.size; ++i) {
                rowData[0] = this.isTabularType ? new XTabularData((XOpenTypeData)this, (TabularData)Array.get(this.val, i)) : Array.get(this.val, i);
                String str = rowData[0].toString();
                if (str.length() > this.col1Width) {
                    this.col1Width = str.length();
                }
                ((DefaultTableModel)this.getModel()).addRow(rowData);
            }
        }

        public String toString() {
            if (this.dimension > 1) {
                return Resources.getText("Dimension is not supported:", new Object[0]) + this.dimension;
            }
            return this.elemType.getTypeName() + "[" + this.size + "]";
        }
    }

    static class XCompositeData
    extends XOpenTypeData {
        protected final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
        CompositeData composite;

        public XCompositeData() {
            super((XOpenTypeData)null);
            this.initTable(this.columnNames);
        }

        public XCompositeData(XOpenTypeData parent) {
            super(parent);
        }

        public XCompositeData(XOpenTypeData parent, CompositeData composite) {
            super(parent);
            this.initTable(this.columnNames);
            if (composite != null) {
                this.composite = composite;
                this.loadCompositeData(composite);
            }
        }

        public void viewed(XOpenTypeViewer viewer) throws Exception {
            viewer.setOpenType(this);
            this.updateColumnWidth();
        }

        public String toString() {
            return this.composite == null ? "" : this.composite.getCompositeType().getTypeName();
        }

        protected Object formatKey(String key) {
            return key;
        }

        private void load(CompositeData data) {
            CompositeType type = data.getCompositeType();
            Set<String> keys = type.keySet();
            Iterator<String> it = keys.iterator();
            Object[] rowData = new Object[2];
            while (it.hasNext()) {
                String key = it.next();
                Object val = data.get(key);
                rowData[0] = this.formatKey(key);
                if (val == null) {
                    rowData[1] = "";
                } else {
                    OpenType<?> openType = type.getType(key);
                    if (openType instanceof CompositeType) {
                        rowData[1] = new XCompositeData(this, (CompositeData)val);
                    } else if (openType instanceof ArrayType) {
                        rowData[1] = new XArrayData(this, (ArrayType)openType, val);
                    } else if (openType instanceof SimpleType) {
                        rowData[1] = val;
                    } else if (openType instanceof TabularType) {
                        rowData[1] = new XTabularData((XOpenTypeData)this, (TabularData)val);
                    }
                }
                String str = null;
                if (rowData[0] != null && (str = rowData[0].toString()).length() > this.col1Width) {
                    this.col1Width = str.length();
                }
                if (rowData[1] != null && (str = rowData[1].toString()).length() > this.col2Width) {
                    this.col2Width = str.length();
                }
                ((DefaultTableModel)this.getModel()).addRow(rowData);
            }
        }

        protected void loadCompositeData(CompositeData data) {
            this.composite = data;
            this.emptyTable();
            this.load(data);
            DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
            tableModel.newDataAvailable(new TableModelEvent(tableModel));
        }
    }

    static class XTabularData
    extends XCompositeData
    implements XViewedTabularData {
        TabularData tabular;
        TabularType type;
        int currentIndex = 0;
        Object[] elements;
        int size;
        private Font normalFont;
        private Font italicFont;

        public XTabularData(XOpenTypeData parent, TabularData tabular) {
            super(parent, XTabularData.accessFirstElement(tabular));
            this.elements = tabular.values().toArray();
            this.size = this.elements.length;
            this.tabular = tabular;
            this.type = tabular.getTabularType();
        }

        private static CompositeData accessFirstElement(TabularData tabular) {
            if (tabular.values().size() == 0) {
                return null;
            }
            return (CompositeData)tabular.values().toArray()[0];
        }

        public void renderKey(String key, Component comp) {
            if (this.normalFont == null) {
                this.normalFont = comp.getFont();
                this.italicFont = this.normalFont.deriveFont(2);
            }
            for (String k : this.type.getIndexNames()) {
                if (!key.equals(k)) continue;
                comp.setFont(this.italicFont);
            }
        }

        public int getElementCount() {
            return this.size;
        }

        public int getSelectedElementIndex() {
            return this.currentIndex;
        }

        public void incrElement() {
            ++this.currentIndex;
            this.loadCompositeData((CompositeData)this.elements[this.currentIndex]);
        }

        public void decrElement() {
            --this.currentIndex;
            this.loadCompositeData((CompositeData)this.elements[this.currentIndex]);
        }

        public boolean canDecrement() {
            return this.currentIndex != 0;
        }

        public boolean canIncrement() {
            return this.size != 0 && this.currentIndex != this.size - 1;
        }

        public String toString() {
            return this.type == null ? "" : this.type.getDescription();
        }
    }

    static abstract class XOpenTypeData
    extends JTable {
        XOpenTypeData parent;
        private Color defaultColor;
        protected int col1Width = -1;
        protected int col2Width = -1;
        private boolean init;
        private Font normalFont;
        private Font boldFont;

        protected XOpenTypeData(XOpenTypeData parent) {
            this.parent = parent;
        }

        public XOpenTypeData getViewedParent() {
            return this.parent;
        }

        public String getToolTip(int row, int col) {
            Object value;
            if (col == 1 && (value = this.getModel().getValueAt(row, col)) != null) {
                if (this.isClickableElement(value)) {
                    return Resources.getText("Double click to visualize", new Object[0]) + ". " + value.toString();
                }
                return value.toString();
            }
            return null;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)super.getCellRenderer(row, column);
            tcr.setToolTipText(this.getToolTip(row, column));
            return tcr;
        }

        public void renderKey(String key, Component comp) {
            comp.setFont(this.normalFont);
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            if (this.normalFont == null) {
                this.normalFont = comp.getFont();
                this.boldFont = this.normalFont.deriveFont(1);
            }
            Object o = ((DefaultTableModel)this.getModel()).getValueAt(row, column);
            if (column == 0) {
                String key = o.toString();
                this.renderKey(key, comp);
            } else if (this.isClickableElement(o)) {
                comp.setFont(this.boldFont);
            } else {
                comp.setFont(this.normalFont);
            }
            return comp;
        }

        protected boolean isClickableElement(Object obj) {
            if (obj instanceof XOpenTypeData) {
                if (obj instanceof Navigatable) {
                    return ((Navigatable)obj).getElementCount() != 0;
                }
                return obj instanceof XCompositeData;
            }
            return false;
        }

        protected void updateColumnWidth() {
            if (!this.init) {
                TableColumnModel colModel = this.getColumnModel();
                if (this.col2Width == -1) {
                    this.col1Width *= 7;
                    if ((double)this.col1Width < this.getPreferredScrollableViewportSize().getWidth()) {
                        this.col1Width = (int)this.getPreferredScrollableViewportSize().getWidth();
                    }
                    colModel.getColumn(0).setPreferredWidth(this.col1Width);
                    this.init = true;
                    return;
                }
                this.col1Width = this.col1Width * 7 + 7;
                this.col1Width = Math.max(this.col1Width, 70);
                this.col2Width = this.col2Width * 7 + 7;
                if ((double)(this.col1Width + this.col2Width) < this.getPreferredScrollableViewportSize().getWidth()) {
                    this.col2Width = (int)this.getPreferredScrollableViewportSize().getWidth() - this.col1Width;
                }
                colModel.getColumn(0).setPreferredWidth(this.col1Width);
                colModel.getColumn(1).setPreferredWidth(this.col2Width);
                this.init = true;
            }
        }

        public abstract void viewed(XOpenTypeViewer var1) throws Exception;

        protected void initTable(String[] columnNames) {
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            ((DefaultTableModel)this.getModel()).setColumnIdentifiers(columnNames);
            Enumeration<TableColumn> e = this.getColumnModel().getColumns();
            while (e.hasMoreElements()) {
                TableColumn tc = e.nextElement();
                tc.setCellEditor(editor);
            }
            this.addKeyListener(new Utils.CopyKeyAdapter());
            this.setAutoResizeMode(2);
            this.setPreferredScrollableViewportSize(new Dimension(350, 200));
        }

        protected void emptyTable() {
            this.invalidate();
            while (this.getModel().getRowCount() > 0) {
                ((DefaultTableModel)this.getModel()).removeRow(0);
            }
            this.validate();
        }

        public void setValueAt(Object value, int row, int col) {
        }
    }

    static interface XViewedArrayData
    extends Navigatable {
    }

    static interface XViewedTabularData
    extends Navigatable {
    }

    static interface Navigatable {
        public void incrElement();

        public void decrElement();

        public boolean canDecrement();

        public boolean canIncrement();

        public int getElementCount();

        public int getSelectedElementIndex();
    }

    class XOpenTypeDataListener
    extends MouseAdapter {
        XOpenTypeDataListener() {
        }

        public void mousePressed(MouseEvent e) {
            XOpenTypeData elem;
            if (e.getButton() == 1 && e.getClickCount() >= 2 && (elem = this.getSelectedViewedOpenType()) != null) {
                try {
                    elem.viewed(XOpenTypeViewer.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private XOpenTypeData getSelectedViewedOpenType() {
            int row = XOpenTypeViewer.this.current.getSelectedRow();
            int col = XOpenTypeViewer.this.current.getSelectedColumn();
            Object elem = XOpenTypeViewer.this.current.getModel().getValueAt(row, col);
            if (elem instanceof XOpenTypeData) {
                return (XOpenTypeData)elem;
            }
            return null;
        }
    }
}

