/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PrintingStatus {
    private final PrinterJob job;
    private final Component parent;
    private JDialog abortDialog;
    private JButton abortButton;
    private JLabel statusLabel;
    private MessageFormat statusFormat;
    private final AtomicBoolean isAborted = new AtomicBoolean(false);
    private final Action abortAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            if (!PrintingStatus.this.isAborted.get()) {
                PrintingStatus.this.isAborted.set(true);
                PrintingStatus.this.abortButton.setEnabled(false);
                PrintingStatus.this.abortDialog.setTitle(UIManager.getString("PrintingDialog.titleAbortingText"));
                PrintingStatus.this.statusLabel.setText(UIManager.getString("PrintingDialog.contentAbortingText"));
                PrintingStatus.this.job.cancel();
            }
        }
    };
    private final WindowAdapter closeListener = new WindowAdapter(){

        public void windowClosing(WindowEvent we) {
            PrintingStatus.this.abortAction.actionPerformed(null);
        }
    };

    public static PrintingStatus createPrintingStatus(Component parent, PrinterJob job) {
        return new PrintingStatus(parent, job);
    }

    protected PrintingStatus(Component parent, PrinterJob job) {
        this.job = job;
        this.parent = parent;
    }

    private void init() {
        String progressTitle = UIManager.getString("PrintingDialog.titleProgressText");
        String dialogInitialContent = UIManager.getString("PrintingDialog.contentInitialText");
        this.statusFormat = new MessageFormat(UIManager.getString("PrintingDialog.contentProgressText"));
        String abortText = UIManager.getString("PrintingDialog.abortButtonText");
        String abortTooltip = UIManager.getString("PrintingDialog.abortButtonToolTipText");
        int abortMnemonic = PrintingStatus.getInt("PrintingDialog.abortButtonMnemonic", -1);
        int abortMnemonicIndex = PrintingStatus.getInt("PrintingDialog.abortButtonDisplayedMnemonicIndex", -1);
        this.abortButton = new JButton(abortText);
        this.abortButton.addActionListener(this.abortAction);
        this.abortButton.setToolTipText(abortTooltip);
        if (abortMnemonic != -1) {
            this.abortButton.setMnemonic(abortMnemonic);
        }
        if (abortMnemonicIndex != -1) {
            this.abortButton.setDisplayedMnemonicIndex(abortMnemonicIndex);
        }
        this.statusLabel = new JLabel(dialogInitialContent);
        JOptionPane abortPane = new JOptionPane(this.statusLabel, 1, -1, null, new Object[]{this.abortButton}, this.abortButton);
        abortPane.getActionMap().put("close", this.abortAction);
        this.abortDialog = this.parent != null && this.parent.getParent() instanceof JViewport ? abortPane.createDialog(this.parent.getParent(), progressTitle) : abortPane.createDialog(this.parent, progressTitle);
        this.abortDialog.setDefaultCloseOperation(0);
        this.abortDialog.addWindowListener(this.closeListener);
    }

    public void showModal(final boolean isModal) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showModalOnEDT(isModal);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        PrintingStatus.this.showModalOnEDT(isModal);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    private void showModalOnEDT(boolean isModal) {
        assert (SwingUtilities.isEventDispatchThread());
        this.init();
        this.abortDialog.setModal(isModal);
        this.abortDialog.setVisible(true);
    }

    public void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeOnEDT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrintingStatus.this.disposeOnEDT();
                }
            });
        }
    }

    private void disposeOnEDT() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.abortDialog != null) {
            this.abortDialog.removeWindowListener(this.closeListener);
            this.abortDialog.dispose();
            this.abortDialog = null;
        }
    }

    public boolean isAborted() {
        return this.isAborted.get();
    }

    public Printable createNotificationPrintable(Printable printable) {
        return new NotificationPrintable(printable);
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private class NotificationPrintable
    implements Printable {
        private final Printable printDelegatee;

        public NotificationPrintable(Printable delegatee) {
            if (delegatee == null) {
                throw new NullPointerException("Printable is null");
            }
            this.printDelegatee = delegatee;
        }

        public int print(Graphics graphics, PageFormat pageFormat, final int pageIndex) throws PrinterException {
            int retVal = this.printDelegatee.print(graphics, pageFormat, pageIndex);
            if (retVal != 1 && !PrintingStatus.this.isAborted()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.updateStatusOnEDT(pageIndex);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NotificationPrintable.this.updateStatusOnEDT(pageIndex);
                        }
                    });
                }
            }
            return retVal;
        }

        private void updateStatusOnEDT(int pageIndex) {
            assert (SwingUtilities.isEventDispatchThread());
            Object[] pageNumber = new Object[]{new Integer(pageIndex + 1)};
            PrintingStatus.this.statusLabel.setText(PrintingStatus.this.statusFormat.format(pageNumber));
        }
    }
}

