/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    public String historicalName() {
        return "UTF8";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static final void updatePositions(Buffer src, int sp, Buffer dst, int dp) {
        src.position(sp - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
    }

    private static class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        private Encoder(Charset cs) {
            super(cs, 1.1f, 4.0f);
        }

        public boolean canEncode(char c) {
            return !Surrogate.is(c);
        }

        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] >= 0 || super.isLegalReplacement(repl);
        }

        private static CoderResult overflow(CharBuffer src, int sp, ByteBuffer dst, int dp) {
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer src, int mark) {
            src.position(mark);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int dlASCII = dp + Math.min(sl - sp, dl - dp);
            while (dp < dlASCII && sa[sp] < '\u0080') {
                da[dp++] = (byte)sa[sp++];
            }
            while (sp < sl) {
                char c = sa[sp];
                if (c < '\u0080') {
                    if (dp >= dl) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)c;
                } else if (c < '\u0800') {
                    if (dl - dp < 2) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                } else if (Surrogate.is(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp, sl)) < 0) {
                        UTF_8.updatePositions(src, sp, dst, dp);
                        return this.sgp.error();
                    }
                    if (dl - dp < 4) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xF0 | uc >> 18);
                    da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc & 0x3F);
                    ++sp;
                } else {
                    if (dl - dp < 3) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xE0 | c >> 12);
                    da[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                }
                ++sp;
            }
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            while (src.hasRemaining()) {
                char c = src.get();
                if (c < '\u0080') {
                    if (!dst.hasRemaining()) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)c);
                } else if (c < '\u0800') {
                    if (dst.remaining() < 2) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xC0 | c >> 6));
                    dst.put((byte)(0x80 | c & 0x3F));
                } else if (Surrogate.is(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, src)) < 0) {
                        src.position(mark);
                        return this.sgp.error();
                    }
                    if (dst.remaining() < 4) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xF0 | uc >> 18));
                    dst.put((byte)(0x80 | uc >> 12 & 0x3F));
                    dst.put((byte)(0x80 | uc >> 6 & 0x3F));
                    dst.put((byte)(0x80 | uc & 0x3F));
                    ++mark;
                } else {
                    if (dst.remaining() < 3) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xE0 | c >> 12));
                    dst.put((byte)(0x80 | c >> 6 & 0x3F));
                    dst.put((byte)(0x80 | c & 0x3F));
                }
                ++mark;
            }
            src.position(mark);
            return CoderResult.UNDERFLOW;
        }

        protected final CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int b) {
            return (b & 0xC0) != 128;
        }

        private static boolean isMalformed2(int b1, int b2) {
            return (b1 & 0x1E) == 0 || (b2 & 0xC0) != 128;
        }

        private static boolean isMalformed3(int b1, int b2, int b3) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int b2, int b3, int b4) {
            return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer src, int n) {
            for (int i = 1; i < n; ++i) {
                if (!Decoder.isNotContinuation(src.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n);
        }

        private static CoderResult malformedN(ByteBuffer src, int nb) {
            switch (nb) {
                case 1: {
                    byte b1 = src.get();
                    if (b1 >> 2 == -2) {
                        if (src.remaining() < 4) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(src, 5);
                    }
                    if (b1 >> 1 == -2) {
                        if (src.remaining() < 5) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(src, 6);
                    }
                    return CoderResult.malformedForLength(1);
                }
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte b1 = src.get();
                    byte b2 = src.get();
                    return CoderResult.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || Decoder.isNotContinuation(b2) ? 1 : 2);
                }
                case 4: {
                    int b1 = src.get() & 0xFF;
                    int b2 = src.get() & 0xFF;
                    if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || Decoder.isNotContinuation(b2)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(src.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
            src.position(sp - src.arrayOffset());
            CoderResult cr = Decoder.malformedN(src, nb);
            UTF_8.updatePositions(src, sp, dst, dp);
            return cr;
        }

        private static CoderResult malformed(ByteBuffer src, int mark, int nb) {
            src.position(mark);
            CoderResult cr = Decoder.malformedN(src, nb);
            src.position(mark);
            return cr;
        }

        private static CoderResult xflow(Buffer src, int sp, int sl, Buffer dst, int dp, int nb) {
            UTF_8.updatePositions(src, sp, dst, dp);
            return nb == 0 || sl - sp < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer src, int mark, int nb) {
            CoderResult cr = nb == 0 || src.remaining() < nb - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
            src.position(mark);
            return cr;
        }

        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int dlASCII = dp + Math.min(sl - sp, dl - dp);
            while (dp < dlASCII && sa[sp] >= 0) {
                da[dp++] = (char)sa[sp++];
            }
            while (sp < sl) {
                byte b3;
                byte b2;
                byte b1 = sa[sp];
                if (b1 >= 0) {
                    if (dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 1);
                    }
                    da[dp++] = (char)b1;
                    ++sp;
                    continue;
                }
                if (b1 >> 5 == -2) {
                    if (sl - sp < 2 || dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 2);
                    }
                    b2 = sa[sp + 1];
                    if (Decoder.isMalformed2(b1, b2)) {
                        return Decoder.malformed(src, sp, dst, dp, 2);
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    sp += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    if (sl - sp < 3 || dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 3);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    if (Decoder.isMalformed3(b1, b2, b3)) {
                        return Decoder.malformed(src, sp, dst, dp, 3);
                    }
                    da[dp++] = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0x1F80);
                    sp += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    if (sl - sp < 4 || dl - dp < 2) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 4);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    byte b4 = sa[sp + 3];
                    int uc = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
                    if (Decoder.isMalformed4(b2, b3, b4) || !Surrogate.neededFor(uc)) {
                        return Decoder.malformed(src, sp, dst, dp, 4);
                    }
                    da[dp++] = Surrogate.high(uc);
                    da[dp++] = Surrogate.low(uc);
                    sp += 4;
                    continue;
                }
                return Decoder.malformed(src, sp, dst, dp, 1);
            }
            return Decoder.xflow(src, sp, sl, dst, dp, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            int limit = src.limit();
            while (mark < limit) {
                byte b3;
                byte b2;
                byte b1 = src.get();
                if (b1 >= 0) {
                    if (dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 1);
                    }
                    dst.put((char)b1);
                    ++mark;
                    continue;
                }
                if (b1 >> 5 == -2) {
                    if (limit - mark < 2 || dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 2);
                    }
                    b2 = src.get();
                    if (Decoder.isMalformed2(b1, b2)) {
                        return Decoder.malformed(src, mark, 2);
                    }
                    dst.put((char)(b1 << 6 ^ b2 ^ 0xF80));
                    mark += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    if (limit - mark < 3 || dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 3);
                    }
                    b2 = src.get();
                    if (Decoder.isMalformed3(b1, b2, b3 = src.get())) {
                        return Decoder.malformed(src, mark, 3);
                    }
                    dst.put((char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0x1F80));
                    mark += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    if (limit - mark < 4 || dst.remaining() < 2) {
                        return Decoder.xflow(src, mark, 4);
                    }
                    b2 = src.get();
                    b3 = src.get();
                    byte b4 = src.get();
                    int uc = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
                    if (Decoder.isMalformed4(b2, b3, b4) || !Surrogate.neededFor(uc)) {
                        return Decoder.malformed(src, mark, 4);
                    }
                    dst.put(Surrogate.high(uc));
                    dst.put(Surrogate.low(uc));
                    mark += 4;
                    continue;
                }
                return Decoder.malformed(src, mark, 1);
            }
            return Decoder.xflow(src, mark, 0);
        }

        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

