/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Adjustable;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ScrollPaneWheelScroller {
    private static final Logger log = Logger.getLogger("sun.awt.ScrollPaneWheelScroller");

    private ScrollPaneWheelScroller() {
    }

    public static void handleWheelScrolling(ScrollPane sp, MouseWheelEvent e) {
        Adjustable adj;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "x = " + e.getX() + ", y = " + e.getY() + ", src is " + e.getSource());
        }
        int increment = 0;
        if (sp != null && e.getScrollAmount() != 0 && (adj = ScrollPaneWheelScroller.getAdjustableToScroll(sp)) != null) {
            increment = ScrollPaneWheelScroller.getIncrementFromAdjustable(adj, e);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "increment from adjustable(" + adj.getClass() + ") : " + increment);
            }
            ScrollPaneWheelScroller.scrollAdjustable(adj, increment);
        }
    }

    public static Adjustable getAdjustableToScroll(ScrollPane sp) {
        int policy = sp.getScrollbarDisplayPolicy();
        if (policy == 1 || policy == 2) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using vertical scrolling due to scrollbar policy");
            }
            return sp.getVAdjustable();
        }
        Insets ins = sp.getInsets();
        int vertScrollWidth = sp.getVScrollbarWidth();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "insets: l = " + ins.left + ", r = " + ins.right + ", t = " + ins.top + ", b = " + ins.bottom);
            log.log(Level.FINER, "vertScrollWidth = " + vertScrollWidth);
        }
        if (ins.right >= vertScrollWidth) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using vertical scrolling because scrollbar is present");
            }
            return sp.getVAdjustable();
        }
        int horizScrollHeight = sp.getHScrollbarHeight();
        if (ins.bottom >= horizScrollHeight) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using horiz scrolling because scrollbar is present");
            }
            return sp.getHAdjustable();
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "using NO scrollbar becsause neither is present");
        }
        return null;
    }

    public static int getIncrementFromAdjustable(Adjustable adj, MouseWheelEvent e) {
        if (log.isLoggable(Level.FINE) && adj == null) {
            log.log(Level.FINE, "Assertion (adj != null) failed");
        }
        int increment = 0;
        if (e.getScrollType() == 0) {
            increment = e.getUnitsToScroll() * adj.getUnitIncrement();
        } else if (e.getScrollType() == 1) {
            increment = adj.getBlockIncrement() * e.getWheelRotation();
        }
        return increment;
    }

    public static void scrollAdjustable(Adjustable adj, int amount) {
        if (log.isLoggable(Level.FINE)) {
            if (adj == null) {
                log.log(Level.FINE, "Assertion (adj != null) failed");
            }
            if (amount == 0) {
                log.log(Level.FINE, "Assertion (amount != 0) failed");
            }
        }
        int current = adj.getValue();
        int upperLimit = adj.getMaximum() - adj.getVisibleAmount();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "doScrolling by " + amount);
        }
        if (amount > 0 && current < upperLimit) {
            if (current + amount < upperLimit) {
                adj.setValue(current + amount);
                return;
            }
            adj.setValue(upperLimit);
            return;
        }
        if (amount < 0 && current > adj.getMinimum()) {
            if (current + amount > adj.getMinimum()) {
                adj.setValue(current + amount);
                return;
            }
            adj.setValue(adj.getMinimum());
            return;
        }
    }
}

