/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginMain;

public class JavaConsole {
    private boolean initialized = false;
    JFrame consoleWindow;
    JTextArea stdErrText;
    JTextArea stdOutText;

    public void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.consoleWindow = new JFrame("Java Console");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        Font monoSpace = new Font("Monospaced", 0, 12);
        this.stdOutText = new JTextArea();
        JScrollPane stdOutScrollPane = new JScrollPane(this.stdOutText);
        stdOutScrollPane.setBorder(new TitledBorder(new EmptyBorder(5, 5, 5, 5), "System.out"));
        this.stdOutText.setEditable(false);
        this.stdOutText.setFont(monoSpace);
        TextAreaUpdater stdOutUpdater = new TextAreaUpdater(new File(PluginMain.PLUGIN_STDOUT_FILE), this.stdOutText);
        stdOutUpdater.setName("IcedteaPlugin Console Thread(System.out)");
        this.stdErrText = new JTextArea();
        JScrollPane stdErrScrollPane = new JScrollPane(this.stdErrText);
        stdErrScrollPane.setBorder(new TitledBorder(new EmptyBorder(5, 5, 5, 5), "System.err"));
        this.stdErrText.setEditable(false);
        this.stdErrText.setFont(monoSpace);
        TextAreaUpdater stdErrUpdater = new TextAreaUpdater(new File(PluginMain.PLUGIN_STDERR_FILE), this.stdErrText);
        stdErrUpdater.setName("IcedteaPlugin Console Thread(System.err)");
        JSplitPane splitPane = new JSplitPane(1, stdOutScrollPane, stdErrScrollPane);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridheight = 10;
        c.weighty = 1.0;
        contentPanel.add((Component)splitPane, c);
        c = new GridBagConstraints();
        c.gridy = 10;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        JPanel buttonPanel = new JPanel();
        contentPanel.add((Component)buttonPanel, c);
        JButton gcButton = new JButton("Run GC");
        buttonPanel.add(gcButton);
        gcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
                System.out.print("Performing Garbage Collection....");
                System.gc();
                System.out.println("Done");
                JavaConsole.this.printMemoryInfo();
            }
        });
        JButton finalizersButton = new JButton("Run Finalizers");
        buttonPanel.add(finalizersButton);
        finalizersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
                System.out.print("Running finalization....");
                Runtime.getRuntime().runFinalization();
                System.out.println("Done");
                JavaConsole.this.printMemoryInfo();
            }
        });
        JButton memoryButton = new JButton("Memory Info");
        buttonPanel.add(memoryButton);
        memoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
            }
        });
        JButton systemPropertiesButton = new JButton("System Properties");
        buttonPanel.add(systemPropertiesButton);
        systemPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printSystemProperties();
            }
        });
        JButton classloadersButton = new JButton("Classloaders");
        buttonPanel.add(classloadersButton);
        classloadersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printClassLoaders();
            }
        });
        JButton threadListButton = new JButton("Thread List");
        buttonPanel.add(threadListButton);
        threadListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printThreadInfo();
            }
        });
        JButton closeButton = new JButton("Close");
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaConsole.this.hideConsole();
                    }
                });
            }
        });
        stdOutUpdater.start();
        stdErrUpdater.start();
        this.consoleWindow.add(contentPanel);
        this.consoleWindow.setDefaultCloseOperation(1);
        this.consoleWindow.pack();
        this.consoleWindow.setSize(new Dimension(900, 600));
        this.consoleWindow.setMinimumSize(new Dimension(900, 300));
        this.initialized = true;
        splitPane.setDividerLocation(0.5);
        splitPane.setResizeWeight(0.5);
    }

    public void showConsole() {
        if (!this.initialized) {
            this.initialize();
        }
        this.consoleWindow.setVisible(true);
    }

    public void hideConsole() {
        this.consoleWindow.setVisible(false);
    }

    protected void printSystemProperties() {
        System.out.println(" ----");
        System.out.println("System Properties:");
        System.out.println();
        Properties p = System.getProperties();
        Set keys = p.keySet();
        for (Object key : keys) {
            System.out.println(key.toString() + ": " + p.get(key));
        }
        System.out.println(" ----");
    }

    private void printClassLoaders() {
        System.out.println(" ----");
        System.out.println("Available Classloaders: ");
        Set<String> loaders = PluginAppletSecurityContext.getLoaderInfo().keySet();
        for (String loader : loaders) {
            System.out.println(loader + "\n" + "  codebase = " + PluginAppletSecurityContext.getLoaderInfo().get(loader));
        }
        System.out.println(" ----");
    }

    private void printMemoryInfo() {
        System.out.println(" ----- ");
        System.out.println("  Memory Info:");
        System.out.println("    Max Memory:   " + String.format("%1$10d", Runtime.getRuntime().maxMemory()));
        System.out.println("    Total Memory: " + String.format("%1$10d", Runtime.getRuntime().totalMemory()));
        System.out.println("    Free Memory:  " + String.format("%1$10d", Runtime.getRuntime().freeMemory()));
        System.out.println(" ----");
    }

    private void printThreadInfo() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> keys = map.keySet();
        for (Thread key : keys) {
            System.out.println("Thread " + key.getId() + ": " + key.getName());
            for (StackTraceElement element : map.get(key)) {
                System.out.println("  " + element);
            }
        }
    }

    public static void main(String[] args) {
        final JavaConsole console = new JavaConsole();
        boolean toShowConsole = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != "--show-console") continue;
            toShowConsole = true;
        }
        if (toShowConsole) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    console.showConsole();
                }
            });
        }
    }

    class TextAreaUpdater
    extends Thread {
        File fileToRead;
        JTextArea outputTextArea;

        public TextAreaUpdater(File file, JTextArea textArea) {
            this.fileToRead = file;
            this.outputTextArea = textArea;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.fileToRead));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) != null) {
                        this.outputTextArea.insert(line + "\n", this.outputTextArea.getDocument().getLength());
                        this.outputTextArea.setCaretPosition(this.outputTextArea.getText().length());
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }
}

