/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthEditorPaneUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class SynthTextPaneUI
extends SynthEditorPaneUI {
    SynthTextPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthTextPaneUI();
    }

    protected String getPropertyPrefix() {
        return "TextPane";
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateForeground(c.getForeground());
        this.updateFont(c.getFont());
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String name = evt.getPropertyName();
        if (name.equals("foreground")) {
            this.updateForeground((Color)evt.getNewValue());
        } else if (name.equals("font")) {
            this.updateFont((Font)evt.getNewValue());
        } else if (name.equals("document")) {
            JTextComponent comp = this.getComponent();
            this.updateForeground(comp.getForeground());
            this.updateFont(comp.getFont());
        }
    }

    private void updateForeground(Color color) {
        StyledDocument doc = (StyledDocument)this.getComponent().getDocument();
        Style style = doc.getStyle("default");
        if (style == null) {
            return;
        }
        if (color == null) {
            style.removeAttribute(StyleConstants.Foreground);
        } else {
            StyleConstants.setForeground(style, color);
        }
    }

    private void updateFont(Font font) {
        StyledDocument doc = (StyledDocument)this.getComponent().getDocument();
        Style style = doc.getStyle("default");
        if (style == null) {
            return;
        }
        if (font == null) {
            style.removeAttribute(StyleConstants.FontFamily);
            style.removeAttribute(StyleConstants.FontSize);
            style.removeAttribute(StyleConstants.Bold);
            style.removeAttribute(StyleConstants.Italic);
        } else {
            StyleConstants.setFontFamily(style, font.getName());
            StyleConstants.setFontSize(style, font.getSize());
            StyleConstants.setBold(style, font.isBold());
            StyleConstants.setItalic(style, font.isItalic());
        }
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        context.getPainter().paintTextPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTextPaneBorder(context, g, x, y, w, h);
    }
}

