/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthProgressBarUI
extends BasicProgressBarUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;
    private boolean rotateText;
    private boolean paintOutsideClip;
    private boolean tileWhenIndeterminate;
    private int tileWidth;

    SynthProgressBarUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SynthProgressBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        this.setCellLength(this.style.getInt(context, "ProgressBar.cellLength", 1));
        this.setCellSpacing(this.style.getInt(context, "ProgressBar.cellSpacing", 0));
        this.progressPadding = this.style.getInt(context, "ProgressBar.progressPadding", 0);
        this.paintOutsideClip = this.style.getBoolean(context, "ProgressBar.paintOutsideClip", false);
        this.rotateText = this.style.getBoolean(context, "ProgressBar.rotateText", false);
        this.tileWhenIndeterminate = this.style.getBoolean(context, "ProgressBar.tileWhenIndeterminate", false);
        this.tileWidth = this.style.getInt(context, "ProgressBar.tileWidth", 15);
        String scaleKey = (String)this.progressBar.getClientProperty("JComponent.sizeVariant");
        if (scaleKey != null) {
            if ("large".equals(scaleKey)) {
                this.tileWidth = (int)((double)this.tileWidth * 1.15);
            } else if ("small".equals(scaleKey)) {
                this.tileWidth = (int)((double)this.tileWidth * 0.857);
            } else if ("mini".equals(scaleKey)) {
                this.tileWidth = (int)((double)this.tileWidth * 0.784);
            }
        }
        context.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        if (this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            SynthContext context = this.getContext(c);
            Font font = context.getStyle().getFont(context);
            FontMetrics metrics = this.progressBar.getFontMetrics(font);
            context.dispose();
            return (height - metrics.getAscent() - metrics.getDescent()) / 2 + metrics.getAscent();
        }
        return -1;
    }

    protected Rectangle getBox(Rectangle r) {
        if (this.tileWhenIndeterminate) {
            return SwingUtilities.calculateInnerArea(this.progressBar, r);
        }
        return super.getBox(r);
    }

    protected void setAnimationIndex(int newValue) {
        if (this.paintOutsideClip) {
            if (this.getAnimationIndex() == newValue) {
                return;
            }
            super.setAnimationIndex(newValue);
            this.progressBar.repaint();
        } else {
            super.setAnimationIndex(newValue);
        }
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintProgressBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.progressBar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        JProgressBar pBar = (JProgressBar)context.getComponent();
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (!pBar.isIndeterminate()) {
            Insets pBarInsets = pBar.getInsets();
            double percentComplete = pBar.getPercentComplete();
            if (percentComplete != 0.0) {
                if (pBar.getOrientation() == 0) {
                    x = pBarInsets.left + this.progressPadding;
                    y = pBarInsets.top + this.progressPadding;
                    width = (int)(percentComplete * (double)(pBar.getWidth() - (pBarInsets.left + this.progressPadding + pBarInsets.right + this.progressPadding)));
                    height = pBar.getHeight() - (pBarInsets.top + this.progressPadding + pBarInsets.bottom + this.progressPadding);
                    if (!SynthLookAndFeel.isLeftToRight(pBar)) {
                        x = pBar.getWidth() - pBarInsets.right - width - this.progressPadding;
                    }
                } else {
                    x = pBarInsets.left + this.progressPadding;
                    width = pBar.getWidth() - (pBarInsets.left + this.progressPadding + pBarInsets.right + this.progressPadding);
                    height = (int)(percentComplete * (double)(pBar.getHeight() - (pBarInsets.top + this.progressPadding + pBarInsets.bottom + this.progressPadding)));
                    y = pBar.getHeight() - pBarInsets.bottom - height - this.progressPadding;
                }
            }
        } else {
            this.boxRect = this.getBox(this.boxRect);
            x = this.boxRect.x + this.progressPadding;
            y = this.boxRect.y + this.progressPadding;
            width = this.boxRect.width - this.progressPadding - this.progressPadding;
            height = this.boxRect.height - this.progressPadding - this.progressPadding;
        }
        if (this.tileWhenIndeterminate && pBar.isIndeterminate()) {
            double percentComplete = (double)this.getAnimationIndex() / (double)this.getFrameCount();
            int offset = (int)(percentComplete * (double)this.tileWidth);
            Shape clip = g.getClip();
            g.clipRect(x, y, width, height);
            if (pBar.getOrientation() == 0) {
                for (int i = x - this.tileWidth + offset; i <= width; i += this.tileWidth) {
                    context.getPainter().paintProgressBarForeground(context, g, i, y, this.tileWidth, height, pBar.getOrientation());
                }
            } else {
                for (int i = y - offset; i < height + this.tileWidth; i += this.tileWidth) {
                    context.getPainter().paintProgressBarForeground(context, g, x, i, width, this.tileWidth, pBar.getOrientation());
                }
            }
            g.setClip(clip);
        } else {
            context.getPainter().paintProgressBarForeground(context, g, x, y, width, height, pBar.getOrientation());
        }
        if (pBar.isStringPainted()) {
            this.paintText(context, g, pBar.getString());
        }
    }

    protected void paintText(SynthContext context, Graphics g, String title) {
        if (this.progressBar.isStringPainted()) {
            SynthStyle style = context.getStyle();
            Font font = style.getFont(context);
            FontMetrics fm = SwingUtilities2.getFontMetrics(this.progressBar, g, font);
            int strLength = style.getGraphicsUtils(context).computeStringWidth(context, font, fm, title);
            Rectangle bounds = this.progressBar.getBounds();
            if (this.rotateText && this.progressBar.getOrientation() == 1) {
                Point textPos;
                AffineTransform rotation;
                Graphics2D g2 = (Graphics2D)g;
                if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                    rotation = AffineTransform.getRotateInstance(-1.5707963267948966);
                    textPos = new Point((bounds.width + fm.getAscent() - fm.getDescent()) / 2, (bounds.height + strLength) / 2);
                } else {
                    rotation = AffineTransform.getRotateInstance(1.5707963267948966);
                    textPos = new Point((bounds.width - fm.getAscent() + fm.getDescent()) / 2, (bounds.height - strLength) / 2);
                }
                if (textPos.x < 0) {
                    return;
                }
                font = font.deriveFont(rotation);
                g2.setFont(font);
                g2.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                style.getGraphicsUtils(context).paintText(context, g, title, textPos.x, textPos.y, -1);
            } else {
                Rectangle textRect = new Rectangle(bounds.width / 2 - strLength / 2, (bounds.height - (fm.getAscent() + fm.getDescent())) / 2, 0, 0);
                if (textRect.y < 0) {
                    return;
                }
                g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                g.setFont(font);
                style.getGraphicsUtils(context).paintText(context, g, title, textRect.x, textRect.y, -1);
            }
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintProgressBarBorder(context, g, x, y, w, h, this.progressBar.getOrientation());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e) || "indeterminate".equals(e.getPropertyName())) {
            this.updateStyle((JProgressBar)e.getSource());
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        String scaleKey;
        int stringWidth;
        Dimension size = null;
        Insets border = this.progressBar.getInsets();
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        String progString = this.progressBar.getString();
        int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
        if (this.progressBar.getOrientation() == 0) {
            size = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                if (stringHeight > size.height) {
                    size.height = stringHeight;
                }
                if ((stringWidth = SwingUtilities2.stringWidth(this.progressBar, fontSizer, progString)) > size.width) {
                    size.width = stringWidth;
                }
            }
        } else {
            size = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                if (stringHeight > size.width) {
                    size.width = stringHeight;
                }
                if ((stringWidth = SwingUtilities2.stringWidth(this.progressBar, fontSizer, progString)) > size.height) {
                    size.height = stringWidth;
                }
            }
        }
        if ((scaleKey = (String)this.progressBar.getClientProperty("JComponent.sizeVariant")) != null) {
            if ("large".equals(scaleKey)) {
                size.width = (int)((float)size.width * 1.15f);
                size.height = (int)((float)size.height * 1.15f);
            } else if ("small".equals(scaleKey)) {
                size.width = (int)((float)size.width * 0.9f);
                size.height = (int)((float)size.height * 0.9f);
            } else if ("mini".equals(scaleKey)) {
                size.width = (int)((float)size.width * 0.784f);
                size.height = (int)((float)size.height * 0.784f);
            }
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

