/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.SwingContainerOrderFocusTraversalPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private Comparator<? super Component> comparator;
    private boolean implicitDownCycleTraversal = true;
    private Logger log = Logger.getLogger("javax.swing.SortingFocusTraversalPolicy");
    private Container cachedRoot;
    private List cachedCycle;
    private static final SwingContainerOrderFocusTraversalPolicy fitnessTestPolicy = new SwingContainerOrderFocusTraversalPolicy();

    protected SortingFocusTraversalPolicy() {
    }

    public SortingFocusTraversalPolicy(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    private void enumerateAndSortCycle(Container focusCycleRoot, List cycle, Map defaults) {
        boolean addDefaultComponents;
        ArrayList<Component> defaultRoots = null;
        if (!focusCycleRoot.isShowing()) {
            return;
        }
        this.enumerateCycle(focusCycleRoot, cycle);
        boolean bl = addDefaultComponents = defaults != null && this.getImplicitDownCycleTraversal();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Will add defaults: " + addDefaultComponents);
        }
        if (addDefaultComponents) {
            defaultRoots = new ArrayList<Component>();
            for (Component comp : cycle) {
                if (!(comp instanceof Container) || !((Container)comp).isFocusCycleRoot()) continue;
                defaultRoots.add(comp);
            }
            Collections.sort(defaultRoots, this.comparator);
        }
        Collections.sort(cycle, this.comparator);
        if (addDefaultComponents) {
            ListIterator defaultRootsIter = defaultRoots.listIterator(defaultRoots.size());
            while (defaultRootsIter.hasPrevious()) {
                Container root = (Container)defaultRootsIter.previous();
                Component defComp = root.getFocusTraversalPolicy().getDefaultComponent(root);
                if (defComp == null || !defComp.isShowing()) continue;
                int index = Collections.binarySearch(cycle, root, this.comparator);
                if (index < 0) {
                    index = -index - 2;
                }
                defaults.put(new Integer(index), defComp);
            }
        }
    }

    private void enumerateCycle(Container container, List cycle) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        cycle.add(container);
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (!(!(comp instanceof Container) || ((Container)comp).isFocusTraversalPolicyProvider() || ((Container)comp).isFocusCycleRoot() || comp instanceof JComponent && ((JComponent)comp).isManagingFocus())) {
                this.enumerateCycle((Container)comp, cycle);
                continue;
            }
            cycle.add(comp);
        }
    }

    Container getTopmostProvider(Container focusCycleRoot, Component aComponent) {
        Container aCont;
        Container ftp = null;
        for (aCont = aComponent.getParent(); aCont != focusCycleRoot && aCont != null; aCont = aCont.getParent()) {
            if (!aCont.isFocusTraversalPolicyProvider()) continue;
            ftp = aCont;
        }
        if (aCont == null) {
            return null;
        }
        return ftp;
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Component comp;
        Component defComp;
        int index;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Searching in " + aContainer.getName() + " for component after " + aComponent.getName());
        }
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container ftp = this.getTopmostProvider(aContainer, aComponent);
        if (ftp != null) {
            FocusTraversalPolicy policy;
            Component retval;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Asking FTP " + ftp.getName() + " for component after " + aComponent.getName());
            }
            if ((retval = (policy = ftp.getFocusTraversalPolicy()).getComponentAfter(ftp, aComponent)) == policy.getFirstComponent(ftp)) {
                retval = null;
            }
            if (retval != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("### FTP returned " + retval.getName());
                }
                return retval;
            }
            aComponent = ftp;
        }
        ArrayList cycle = new ArrayList();
        HashMap defaults = new HashMap();
        this.enumerateAndSortCycle(aContainer, cycle, defaults);
        try {
            index = Collections.binarySearch(cycle, aComponent, this.comparator);
        }
        catch (ClassCastException e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Didn't find component " + aComponent.getName() + " in a cycle " + aContainer.getName());
            }
            return this.getFirstComponent(aContainer);
        }
        if (index < 0) {
            int i = cycle.indexOf(aComponent);
            index = i >= 0 ? i : -index - 2;
        }
        if ((defComp = (Component)defaults.get(new Integer(index))) != null) {
            return defComp;
        }
        do {
            if (++index >= cycle.size()) {
                if (aContainer.isFocusCycleRoot()) {
                    this.cachedRoot = aContainer;
                    this.cachedCycle = cycle;
                    Component retval = this.getFirstComponent(aContainer);
                    this.cachedRoot = null;
                    this.cachedCycle = null;
                    return retval;
                }
                return null;
            }
            comp = (Component)cycle.get(index);
            if (!this.accept(comp)) continue;
            return comp;
        } while (!(comp instanceof Container) || !((Container)comp).isFocusTraversalPolicyProvider());
        return ((Container)comp).getFocusTraversalPolicy().getDefaultComponent((Container)comp);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component defComp;
        int index;
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container ftp = this.getTopmostProvider(aContainer, aComponent);
        if (ftp != null) {
            FocusTraversalPolicy policy;
            Component retval;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Asking FTP " + ftp.getName() + " for component after " + aComponent.getName());
            }
            if ((retval = (policy = ftp.getFocusTraversalPolicy()).getComponentBefore(ftp, aComponent)) == policy.getLastComponent(ftp)) {
                retval = null;
            }
            if (retval != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("### FTP returned " + retval.getName());
                }
                return retval;
            }
            aComponent = ftp;
        }
        ArrayList cycle = new ArrayList();
        HashMap defaults = new HashMap();
        this.enumerateAndSortCycle(aContainer, cycle, defaults);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Cycle is " + cycle + ", component is " + aComponent);
        }
        try {
            index = Collections.binarySearch(cycle, aComponent, this.comparator);
        }
        catch (ClassCastException e) {
            return this.getLastComponent(aContainer);
        }
        index = index < 0 ? -index - 2 : --index;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Index is " + index);
        }
        if (index >= 0 && (defComp = (Component)defaults.get(new Integer(index))) != null && cycle.get(index) != aContainer) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Returning default " + defComp.getName() + " at " + index);
            }
            return defComp;
        }
        while (true) {
            if (index < 0) {
                this.cachedRoot = aContainer;
                this.cachedCycle = cycle;
                Component retval = this.getLastComponent(aContainer);
                this.cachedRoot = null;
                this.cachedCycle = null;
                return retval;
            }
            Component comp = (Component)cycle.get(index);
            if (this.accept(comp)) {
                return comp;
            }
            if (comp instanceof Container && ((Container)comp).isFocusTraversalPolicyProvider()) {
                return ((Container)comp).getFocusTraversalPolicy().getLastComponent((Container)comp);
            }
            --index;
        }
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        ArrayList cycle;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Getting first component in " + aContainer.getName());
        }
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (this.cachedRoot == aContainer) {
            cycle = this.cachedCycle;
        } else {
            cycle = new ArrayList();
            this.enumerateAndSortCycle(aContainer, cycle, null);
        }
        int size = cycle.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < cycle.size(); ++i) {
            Component comp = (Component)cycle.get(i);
            if (this.accept(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || comp == aContainer || !((Container)comp).isFocusTraversalPolicyProvider()) continue;
            return ((Container)comp).getFocusTraversalPolicy().getDefaultComponent((Container)comp);
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        ArrayList cycle;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Getting last component in " + aContainer.getName());
        }
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (this.cachedRoot == aContainer) {
            cycle = this.cachedCycle;
        } else {
            cycle = new ArrayList();
            this.enumerateAndSortCycle(aContainer, cycle, null);
        }
        int size = cycle.size();
        if (size == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Cycle is " + cycle);
        }
        for (int i = cycle.size() - 1; i >= 0; --i) {
            Component comp = (Component)cycle.get(i);
            if (this.accept(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || comp == aContainer || !((Container)comp).isFocusTraversalPolicyProvider()) continue;
            return ((Container)comp).getFocusTraversalPolicy().getLastComponent((Container)comp);
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    public void setImplicitDownCycleTraversal(boolean implicitDownCycleTraversal) {
        this.implicitDownCycleTraversal = implicitDownCycleTraversal;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected void setComparator(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    protected Comparator<? super Component> getComparator() {
        return this.comparator;
    }

    protected boolean accept(Component aComponent) {
        return fitnessTestPolicy.accept(aComponent);
    }
}

