/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int nread = 0;
    private int size = 0;

    public ProgressMonitorInputStream(Component parentComponent, Object message, InputStream in) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
        this.monitor = new ProgressMonitor(parentComponent, message, null, 0, this.size);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.monitor.setProgress(++this.nread);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.monitor.setProgress(this.nread += nr);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        return nr;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.monitor.setProgress(this.nread += nr);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        return nr;
    }

    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.monitor.setProgress(this.nread);
        }
        return nr;
    }

    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.monitor.setProgress(this.nread);
    }
}

