/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.naming.spi.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContinuationContext
implements Context,
Resolver {
    protected CannotProceedException cpe;
    protected Hashtable env;
    protected Context contCtx = null;

    protected ContinuationContext(CannotProceedException cpe, Hashtable env) {
        this.cpe = cpe;
        this.env = env;
    }

    protected Context getTargetContext() throws NamingException {
        if (this.contCtx == null) {
            if (this.cpe.getResolvedObj() == null) {
                throw (NamingException)this.cpe.fillInStackTrace();
            }
            this.contCtx = NamingManager.getContext(this.cpe.getResolvedObj(), this.cpe.getAltName(), this.cpe.getAltNameCtx(), this.env);
            if (this.contCtx == null) {
                throw (NamingException)this.cpe.fillInStackTrace();
            }
        }
        return this.contCtx;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.lookup(name);
    }

    @Override
    public void bind(Name name, Object newObj) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.bind(name, newObj);
    }

    @Override
    public void bind(String name, Object newObj) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.bind(name, newObj);
    }

    @Override
    public void rebind(Name name, Object newObj) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.rebind(name, newObj);
    }

    @Override
    public void rebind(String name, Object newObj) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.rebind(name, newObj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.unbind(name);
    }

    @Override
    public void rename(Name name, Name newName) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.rename(name, newName);
    }

    @Override
    public void rename(String name, String newName) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.rename(name, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        ctx.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object value) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.addToEnvironment(propName, value);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.getEnvironment();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        Context ctx = this.getTargetContext();
        return ctx.getNameInNamespace();
    }

    @Override
    public ResolveResult resolveToClass(Name name, Class<? extends Context> contextType) throws NamingException {
        if (this.cpe.getResolvedObj() == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        Resolver res = NamingManager.getResolver(this.cpe.getResolvedObj(), this.cpe.getAltName(), this.cpe.getAltNameCtx(), this.env);
        if (res == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        return res.resolveToClass(name, contextType);
    }

    @Override
    public ResolveResult resolveToClass(String name, Class<? extends Context> contextType) throws NamingException {
        if (this.cpe.getResolvedObj() == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        Resolver res = NamingManager.getResolver(this.cpe.getResolvedObj(), this.cpe.getAltName(), this.cpe.getAltNameCtx(), this.env);
        if (res == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        return res.resolveToClass(name, contextType);
    }

    @Override
    public void close() throws NamingException {
        this.cpe = null;
        this.env = null;
        if (this.contCtx != null) {
            this.contCtx.close();
            this.contCtx = null;
        }
    }
}

