/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIIIOPServerImpl
extends RMIServerImpl {
    private final Map<String, ?> env;
    private final AccessControlContext callerACC;

    public RMIIIOPServerImpl(Map<String, ?> env) throws IOException {
        super(env);
        this.env = env == null ? Collections.emptyMap() : env;
        this.callerACC = AccessController.getContext();
    }

    @Override
    protected void export() throws IOException {
        PortableRemoteObject.exportObject(this);
    }

    @Override
    protected String getProtocol() {
        return "iiop";
    }

    @Override
    public Remote toStub() throws IOException {
        Remote stub = PortableRemoteObject.toStub(this);
        return stub;
    }

    @Override
    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.env);
        PortableRemoteObject.exportObject(client);
        return client;
    }

    @Override
    protected void closeClient(RMIConnection client) throws IOException {
        PortableRemoteObject.unexportObject(client);
    }

    @Override
    protected void closeServer() throws IOException {
        PortableRemoteObject.unexportObject(this);
    }

    @Override
    RMIConnection doNewClient(final Object credentials) throws IOException {
        if (this.callerACC == null) {
            throw new SecurityException("AccessControlContext cannot be null");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RMIConnection>(){

                @Override
                public RMIConnection run() throws IOException {
                    return RMIIIOPServerImpl.this.superDoNewClient(credentials);
                }
            }, this.callerACC);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    RMIConnection superDoNewClient(Object credentials) throws IOException {
        return super.doNewClient(credentials);
    }
}

