/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import sun.rmi.server.ActivationGroupImpl;
import sun.security.action.GetIntegerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    private ActivationGroupID groupID;
    private ActivationMonitor monitor;
    private long incarnation;
    private static ActivationGroup currGroup;
    private static ActivationGroupID currGroupID;
    private static ActivationSystem currSystem;
    private static boolean canCreate;
    private static final long serialVersionUID = -7696947875314805420L;

    protected ActivationGroup(ActivationGroupID groupID) throws RemoteException {
        this.groupID = groupID;
    }

    public boolean inactiveObject(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
        this.getMonitor().inactiveObject(id);
        return true;
    }

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public static synchronized ActivationGroup createGroup(ActivationGroupID id, ActivationGroupDesc desc, long incarnation) throws ActivationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (currGroup != null) {
            throw new ActivationException("group already exists");
        }
        if (!canCreate) {
            throw new ActivationException("group deactivated and cannot be recreated");
        }
        try {
            Class cl;
            String groupClassName = desc.getClassName();
            Class<ActivationGroupImpl> defaultGroupClass = ActivationGroupImpl.class;
            if (groupClassName == null || groupClassName.equals(defaultGroupClass.getName())) {
                cl = defaultGroupClass;
            } else {
                Class<?> cl0;
                try {
                    cl0 = RMIClassLoader.loadClass(desc.getLocation(), groupClassName);
                }
                catch (Exception ex) {
                    throw new ActivationException("Could not load group implementation class", ex);
                }
                if (ActivationGroup.class.isAssignableFrom(cl0)) {
                    cl = cl0.asSubclass(ActivationGroup.class);
                } else {
                    throw new ActivationException("group not correct class: " + cl0.getName());
                }
            }
            Constructor constructor = cl.getConstructor(ActivationGroupID.class, MarshalledObject.class);
            ActivationGroup newGroup = (ActivationGroup)constructor.newInstance(id, desc.getData());
            currSystem = id.getSystem();
            newGroup.incarnation = incarnation;
            newGroup.monitor = currSystem.activeGroup(id, newGroup, incarnation);
            currGroup = newGroup;
            currGroupID = id;
            canCreate = false;
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new ActivationException("exception in group constructor", e.getTargetException());
        }
        catch (ActivationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActivationException("exception creating group", e);
        }
        return currGroup;
    }

    public static synchronized ActivationGroupID currentGroupID() {
        return currGroupID;
    }

    static synchronized ActivationGroupID internalCurrentGroupID() throws ActivationException {
        if (currGroupID == null) {
            throw new ActivationException("nonexistent group");
        }
        return currGroupID;
    }

    public static synchronized void setSystem(ActivationSystem system) throws ActivationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (currSystem != null) {
            throw new ActivationException("activation system already set");
        }
        currSystem = system;
    }

    public static synchronized ActivationSystem getSystem() throws ActivationException {
        if (currSystem == null) {
            try {
                int port = AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
                currSystem = (ActivationSystem)Naming.lookup("//:" + port + "/java.rmi.activation.ActivationSystem");
            }
            catch (Exception e) {
                throw new ActivationException("unable to obtain ActivationSystem", e);
            }
        }
        return currSystem;
    }

    protected void activeObject(ActivationID id, MarshalledObject<? extends Remote> mobj) throws ActivationException, UnknownObjectException, RemoteException {
        this.getMonitor().activeObject(id, mobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        try {
            this.getMonitor().inactiveGroup(this.groupID, this.incarnation);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            ActivationGroup.destroyGroup();
            throw throwable;
        }
        ActivationGroup.destroyGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivationMonitor getMonitor() throws RemoteException {
        Class<ActivationGroup> clazz = ActivationGroup.class;
        synchronized (ActivationGroup.class) {
            if (this.monitor != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.monitor;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new RemoteException("monitor not received");
        }
    }

    private static synchronized void destroyGroup() {
        currGroup = null;
        currGroupID = null;
    }

    static synchronized ActivationGroup currentGroup() throws ActivationException {
        if (currGroup == null) {
            throw new ActivationException("group is not active");
        }
        return currGroup;
    }

    static {
        canCreate = true;
    }
}

