/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;

public abstract class MappedByteBuffer
extends ByteBuffer {
    volatile boolean isAMappedBuffer;

    MappedByteBuffer(int mark, int pos, int lim, int cap, boolean mapped) {
        super(mark, pos, lim, cap);
        this.isAMappedBuffer = mapped;
    }

    MappedByteBuffer(int mark, int pos, int lim, int cap) {
        super(mark, pos, lim, cap);
        this.isAMappedBuffer = false;
    }

    private void checkMapped() {
        if (!this.isAMappedBuffer) {
            throw new UnsupportedOperationException();
        }
    }

    public final boolean isLoaded() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return true;
        }
        return this.isLoaded0(((DirectByteBuffer)this).address(), this.capacity());
    }

    public final MappedByteBuffer load() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return this;
        }
        this.load0(((DirectByteBuffer)this).address(), this.capacity(), Bits.pageSize());
        return this;
    }

    public final MappedByteBuffer force() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return this;
        }
        this.force0(((DirectByteBuffer)this).address(), this.capacity());
        return this;
    }

    private native boolean isLoaded0(long var1, long var3);

    private native int load0(long var1, long var3, int var5);

    private native void force0(long var1, long var3);
}

