/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BeanContextChildSupport
implements BeanContextChild,
BeanContextServicesListener,
Serializable {
    static final long serialVersionUID = 6328947014421475877L;
    public BeanContextChild beanContextChildPeer;
    protected PropertyChangeSupport pcSupport;
    protected VetoableChangeSupport vcSupport;
    protected transient BeanContext beanContext;
    protected transient boolean rejectedSetBCOnce;

    public BeanContextChildSupport() {
        this.beanContextChildPeer = this;
        this.pcSupport = new PropertyChangeSupport(this.beanContextChildPeer);
        this.vcSupport = new VetoableChangeSupport(this.beanContextChildPeer);
    }

    public BeanContextChildSupport(BeanContextChild bcc) {
        this.beanContextChildPeer = bcc != null ? bcc : this;
        this.pcSupport = new PropertyChangeSupport(this.beanContextChildPeer);
        this.vcSupport = new VetoableChangeSupport(this.beanContextChildPeer);
    }

    public synchronized void setBeanContext(BeanContext bc) throws PropertyVetoException {
        if (bc == this.beanContext) {
            return;
        }
        BeanContext oldValue = this.beanContext;
        BeanContext newValue = bc;
        if (!this.rejectedSetBCOnce) {
            this.rejectedSetBCOnce = !this.validatePendingSetBeanContext(bc);
            if (this.rejectedSetBCOnce) {
                throw new PropertyVetoException("setBeanContext() change rejected:", new PropertyChangeEvent(this.beanContextChildPeer, "beanContext", oldValue, newValue));
            }
            try {
                this.fireVetoableChange("beanContext", oldValue, newValue);
            }
            catch (PropertyVetoException pve) {
                this.rejectedSetBCOnce = true;
                throw pve;
            }
        }
        if (this.beanContext != null) {
            this.releaseBeanContextResources();
        }
        this.beanContext = newValue;
        this.rejectedSetBCOnce = false;
        this.firePropertyChange("beanContext", oldValue, newValue);
        if (this.beanContext != null) {
            this.initializeBeanContextResources();
        }
    }

    public synchronized BeanContext getBeanContext() {
        return this.beanContext;
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.pcSupport.addPropertyChangeListener(name, pcl);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.pcSupport.removePropertyChangeListener(name, pcl);
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.vcSupport.addVetoableChangeListener(name, vcl);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.vcSupport.removeVetoableChangeListener(name, vcl);
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent bcsae) {
    }

    public BeanContextChild getBeanContextChildPeer() {
        return this.beanContextChildPeer;
    }

    public boolean isDelegated() {
        return !this.equals(this.beanContextChildPeer);
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcSupport.firePropertyChange(name, oldValue, newValue);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vcSupport.fireVetoableChange(name, oldValue, newValue);
    }

    public boolean validatePendingSetBeanContext(BeanContext newValue) {
        return true;
    }

    protected void releaseBeanContextResources() {
    }

    protected void initializeBeanContextResources() {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.equals(this.beanContextChildPeer) && !(this.beanContextChildPeer instanceof Serializable)) {
            throw new IOException("BeanContextChildSupport beanContextChildPeer not Serializable");
        }
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }
}

