/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaMethodImpl
implements JavaMethod {
    private String inputAction;
    private String outputAction;
    private final List<CheckedExceptionImpl> exceptions = new ArrayList<CheckedExceptionImpl>();
    private final Method method;
    final List<ParameterImpl> requestParams = new ArrayList<ParameterImpl>();
    final List<ParameterImpl> responseParams = new ArrayList<ParameterImpl>();
    private final List<ParameterImpl> unmReqParams = Collections.unmodifiableList(this.requestParams);
    private final List<ParameterImpl> unmResParams = Collections.unmodifiableList(this.responseParams);
    private SOAPBindingImpl binding;
    private MEP mep;
    private String operationName;
    private WSDLBoundOperationImpl wsdlOperation;
    final AbstractSEIModelImpl owner;
    private final Method seiMethod;

    public JavaMethodImpl(AbstractSEIModelImpl owner, Method method, Method seiMethod) {
        this.owner = owner;
        this.method = method;
        this.seiMethod = seiMethod;
        Action action = method.getAnnotation(Action.class);
        if (action != null) {
            this.inputAction = action.input();
            this.outputAction = action.output();
        }
    }

    @Override
    public SEIModel getOwner() {
        return this.owner;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Method getSEIMethod() {
        return this.seiMethod;
    }

    @Override
    public MEP getMEP() {
        return this.mep;
    }

    void setMEP(MEP mep) {
        this.mep = mep;
    }

    @Override
    public SOAPBindingImpl getBinding() {
        if (this.binding == null) {
            return new SOAPBindingImpl();
        }
        return this.binding;
    }

    void setBinding(SOAPBindingImpl binding) {
        this.binding = binding;
    }

    @NotNull
    public WSDLBoundOperation getOperation() {
        assert (this.wsdlOperation != null);
        return this.wsdlOperation;
    }

    public void setOperationName(String name) {
        this.operationName = name;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public String getRequestMessageName() {
        return this.operationName;
    }

    @Override
    public String getResponseMessageName() {
        if (this.mep.isOneWay()) {
            return null;
        }
        return this.operationName + "Response";
    }

    @Override
    @Nullable
    public QName getRequestPayloadName() {
        return this.wsdlOperation.getReqPayloadName();
    }

    @Override
    @Nullable
    public QName getResponsePayloadName() {
        return this.mep == MEP.ONE_WAY ? null : this.wsdlOperation.getResPayloadName();
    }

    public List<ParameterImpl> getRequestParameters() {
        return this.unmReqParams;
    }

    public List<ParameterImpl> getResponseParameters() {
        return this.unmResParams;
    }

    void addParameter(ParameterImpl p) {
        if (p.isIN() || p.isINOUT()) {
            assert (!this.requestParams.contains(p));
            this.requestParams.add(p);
        }
        if (p.isOUT() || p.isINOUT()) {
            assert (!this.responseParams.contains(p));
            this.responseParams.add(p);
        }
    }

    void addRequestParameter(ParameterImpl p) {
        if (p.isIN() || p.isINOUT()) {
            this.requestParams.add(p);
        }
    }

    void addResponseParameter(ParameterImpl p) {
        if (p.isOUT() || p.isINOUT()) {
            this.responseParams.add(p);
        }
    }

    public int getInputParametersCount() {
        int count = 0;
        for (ParameterImpl param : this.requestParams) {
            if (param.isWrapperStyle()) {
                count += ((WrapperParameter)param).getWrapperChildren().size();
                continue;
            }
            ++count;
        }
        for (ParameterImpl param : this.responseParams) {
            if (param.isWrapperStyle()) {
                for (ParameterImpl wc : ((WrapperParameter)param).getWrapperChildren()) {
                    if (wc.isResponse() || !wc.isOUT()) continue;
                    ++count;
                }
                continue;
            }
            if (param.isResponse() || !param.isOUT()) continue;
            ++count;
        }
        return count;
    }

    void addException(CheckedExceptionImpl ce) {
        if (!this.exceptions.contains(ce)) {
            this.exceptions.add(ce);
        }
    }

    public CheckedExceptionImpl getCheckedException(Class exceptionClass) {
        for (CheckedExceptionImpl ce : this.exceptions) {
            if (ce.getExceptionClass() != exceptionClass) continue;
            return ce;
        }
        return null;
    }

    public List<CheckedExceptionImpl> getCheckedExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public String getInputAction() {
        return this.inputAction;
    }

    public String getOutputAction() {
        return this.outputAction;
    }

    public CheckedExceptionImpl getCheckedException(TypeReference detailType) {
        for (CheckedExceptionImpl ce : this.exceptions) {
            TypeReference actual = ce.getDetailType();
            if (!actual.tagName.equals(detailType.tagName) || actual.type != detailType.type) continue;
            return ce;
        }
        return null;
    }

    public boolean isAsync() {
        return this.mep.isAsync;
    }

    void freeze(WSDLPortImpl portType) {
        this.wsdlOperation = portType.getBinding().get(new QName(portType.getBinding().getPortType().getName().getNamespaceURI(), this.operationName));
        if (this.wsdlOperation == null) {
            throw new Error("Undefined operation name " + this.operationName);
        }
    }

    final void fillTypes(List<TypeReference> types) {
        this.fillTypes(this.requestParams, types);
        this.fillTypes(this.responseParams, types);
        for (CheckedExceptionImpl ce : this.exceptions) {
            types.add(ce.getDetailType());
        }
    }

    private void fillTypes(List<ParameterImpl> params, List<TypeReference> types) {
        for (ParameterImpl p : params) {
            p.fillTypes(types);
        }
    }
}

