/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.client.SelectOptimalEncodingFeature;
import com.sun.xml.internal.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.internal.ws.api.message.ExceptionHasMessage;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Codecs;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.MtomCodec;
import com.sun.xml.internal.ws.encoding.SwACodec;
import com.sun.xml.internal.ws.protocol.soap.MessageCreationException;
import com.sun.xml.internal.ws.resources.StreamingMessages;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;

public class SOAPBindingCodec
extends MimeCodec
implements com.sun.xml.internal.ws.api.pipe.SOAPBindingCodec {
    private static final String BASE_ACCEPT_VALUE = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private boolean isFastInfosetDisabled;
    private boolean useFastInfosetForEncoding;
    private boolean ignoreContentNegotiationProperty;
    private final StreamSOAPCodec xmlSoapCodec;
    private final Codec fiSoapCodec;
    private final MimeCodec xmlMtomCodec;
    private final MimeCodec xmlSwaCodec;
    private final MimeCodec fiSwaCodec;
    private final SOAPBindingImpl binding;
    private final String xmlMimeType;
    private final String fiMimeType;
    private final String xmlAccept;
    private final String connegXmlAccept;
    private AcceptContentType _adaptingContentType = new AcceptContentType();

    public StreamSOAPCodec getXMLCodec() {
        return this.xmlSoapCodec;
    }

    public SOAPBindingCodec(WSBinding binding) {
        this(binding, Codecs.createSOAPEnvelopeXmlCodec(binding.getSOAPVersion()));
    }

    public SOAPBindingCodec(WSBinding binding, StreamSOAPCodec xmlSoapCodec) {
        super(binding.getSOAPVersion(), binding);
        this.xmlSoapCodec = xmlSoapCodec;
        this.xmlMimeType = xmlSoapCodec.getMimeType();
        this.xmlMtomCodec = new MtomCodec(this.version, xmlSoapCodec, binding, binding.getFeature(MTOMFeature.class));
        this.xmlSwaCodec = new SwACodec(this.version, binding, xmlSoapCodec);
        String clientAcceptedContentTypes = xmlSoapCodec.getMimeType() + ", " + this.xmlMtomCodec.getMimeType() + ", " + BASE_ACCEPT_VALUE;
        FastInfosetFeature fi = binding.getFeature(FastInfosetFeature.class);
        boolean bl = this.isFastInfosetDisabled = fi != null && !fi.isEnabled();
        if (!this.isFastInfosetDisabled) {
            this.fiSoapCodec = SOAPBindingCodec.getFICodec(xmlSoapCodec, this.version);
            if (this.fiSoapCodec != null) {
                this.fiMimeType = this.fiSoapCodec.getMimeType();
                this.fiSwaCodec = new SwACodec(this.version, binding, this.fiSoapCodec);
                this.connegXmlAccept = this.fiMimeType + ", " + clientAcceptedContentTypes;
                SelectOptimalEncodingFeature select = binding.getFeature(SelectOptimalEncodingFeature.class);
                if (select != null) {
                    this.ignoreContentNegotiationProperty = true;
                    if (select.isEnabled()) {
                        if (fi != null) {
                            this.useFastInfosetForEncoding = true;
                        }
                        clientAcceptedContentTypes = this.connegXmlAccept;
                    } else {
                        this.isFastInfosetDisabled = true;
                    }
                }
            } else {
                this.isFastInfosetDisabled = true;
                this.fiSwaCodec = null;
                this.fiMimeType = "";
                this.connegXmlAccept = clientAcceptedContentTypes;
                this.ignoreContentNegotiationProperty = true;
            }
        } else {
            this.fiSwaCodec = null;
            this.fiSoapCodec = null;
            this.fiMimeType = "";
            this.connegXmlAccept = clientAcceptedContentTypes;
            this.ignoreContentNegotiationProperty = true;
        }
        this.xmlAccept = clientAcceptedContentTypes;
        if (!(binding instanceof SOAPBindingImpl)) {
            throw new WebServiceException("Expecting a SOAP binding but found " + binding);
        }
        this.binding = (SOAPBindingImpl)binding;
    }

    public String getMimeType() {
        return null;
    }

    public ContentType getStaticContentType(Packet packet) {
        ContentType toAdapt = this.getEncoder(packet).getStaticContentType(packet);
        return toAdapt != null ? this._adaptingContentType.set(packet, toAdapt) : null;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, out));
    }

    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, buffer));
    }

    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        if (contentType == null) {
            throw new UnsupportedMediaException();
        }
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
        try {
            if (this.isMultipartRelated(contentType)) {
                super.decode(in, contentType, packet);
            } else if (this.isFastInfoset(contentType)) {
                if (!this.ignoreContentNegotiationProperty && packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(in, contentType, packet);
            } else {
                this.xmlSoapCodec.decode(in, contentType, packet);
            }
        }
        catch (RuntimeException we) {
            if (we instanceof ExceptionHasMessage || we instanceof UnsupportedMediaException) {
                throw we;
            }
            throw new MessageCreationException(this.binding.getSOAPVersion(), we);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        if (contentType == null) {
            throw new UnsupportedMediaException();
        }
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
        try {
            if (this.isMultipartRelated(contentType)) {
                super.decode(in, contentType, packet);
            } else if (this.isFastInfoset(contentType)) {
                if (packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(in, contentType, packet);
            } else {
                this.xmlSoapCodec.decode(in, contentType, packet);
            }
        }
        catch (RuntimeException we) {
            if (we instanceof ExceptionHasMessage || we instanceof UnsupportedMediaException) {
                throw we;
            }
            throw new MessageCreationException(this.binding.getSOAPVersion(), we);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public SOAPBindingCodec copy() {
        return new SOAPBindingCodec(this.binding, (StreamSOAPCodec)this.xmlSoapCodec.copy());
    }

    protected void decode(MimeMultipartParser mpp, Packet packet) throws IOException {
        String rootContentType = mpp.getRootPart().getContentType();
        if (this.isApplicationXopXml(rootContentType)) {
            this.xmlMtomCodec.decode(mpp, packet);
        } else if (this.isFastInfoset(rootContentType)) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSwaCodec.decode(mpp, packet);
        } else if (this.isXml(rootContentType)) {
            this.xmlSwaCodec.decode(mpp, packet);
        } else {
            throw new IOException("");
        }
    }

    private boolean isMultipartRelated(String contentType) {
        return this.compareStrings(contentType, "multipart/related");
    }

    private boolean isApplicationXopXml(String contentType) {
        return this.compareStrings(contentType, "application/xop+xml");
    }

    private boolean isXml(String contentType) {
        return this.compareStrings(contentType, this.xmlMimeType);
    }

    private boolean isFastInfoset(String contentType) {
        if (this.isFastInfosetDisabled) {
            return false;
        }
        return this.compareStrings(contentType, this.fiMimeType);
    }

    private boolean compareStrings(String a, String b) {
        return a.length() >= b.length() && b.equalsIgnoreCase(a.substring(0, b.length()));
    }

    private boolean isFastInfosetAcceptable(String accept) {
        if (accept == null || this.isFastInfosetDisabled) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase(this.fiMimeType)) continue;
            return true;
        }
        return false;
    }

    private Codec getEncoder(Packet p) {
        if (!this.ignoreContentNegotiationProperty) {
            if (p.contentNegotiation == ContentNegotiation.none) {
                this.useFastInfosetForEncoding = false;
            } else if (p.contentNegotiation == ContentNegotiation.optimistic) {
                this.useFastInfosetForEncoding = true;
            }
        }
        if (this.useFastInfosetForEncoding) {
            Message m = p.getMessage();
            if (m == null || m.getAttachments().isEmpty() || this.binding.isFeatureEnabled(MTOMFeature.class)) {
                return this.fiSoapCodec;
            }
            return this.fiSwaCodec;
        }
        if (this.binding.isFeatureEnabled(MTOMFeature.class)) {
            return this.xmlMtomCodec;
        }
        Message m = p.getMessage();
        if (m == null || m.getAttachments().isEmpty()) {
            return this.xmlSoapCodec;
        }
        return this.xmlSwaCodec;
    }

    private RuntimeException noFastInfosetForDecoding() {
        return new RuntimeException(StreamingMessages.FASTINFOSET_DECODING_NOT_ACCEPTED());
    }

    private static Codec getFICodec(StreamSOAPCodec soapCodec, SOAPVersion version) {
        try {
            Class<?> c = Class.forName("com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamSOAPCodec");
            Method m = c.getMethod("create", StreamSOAPCodec.class, SOAPVersion.class);
            return (Codec)m.invoke(null, new Object[]{soapCodec, version});
        }
        catch (Exception e) {
            return null;
        }
    }

    private class AcceptContentType
    implements ContentType {
        private ContentType _c;
        private String _accept;

        private AcceptContentType() {
        }

        public AcceptContentType set(Packet p, ContentType c) {
            this._accept = !SOAPBindingCodec.this.ignoreContentNegotiationProperty && p.contentNegotiation != ContentNegotiation.none ? SOAPBindingCodec.this.connegXmlAccept : SOAPBindingCodec.this.xmlAccept;
            this._c = c;
            return this;
        }

        public String getContentType() {
            return this._c.getContentType();
        }

        public String getSOAPActionHeader() {
            return this._c.getSOAPActionHeader();
        }

        public String getAcceptHeader() {
            return this._accept;
        }
    }
}

