/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidSearchFilterException;

final class Filter {
    private static final boolean dbg = false;
    private static int dbgIndent = 0;
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_NOT = 162;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_GE = 165;
    static final int LDAP_FILTER_LE = 166;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_APPROX = 168;
    static final int LDAP_FILTER_EXT = 169;
    static final int LDAP_FILTER_EXT_RULE = 129;
    static final int LDAP_FILTER_EXT_TYPE = 130;
    static final int LDAP_FILTER_EXT_VAL = 131;
    static final int LDAP_FILTER_EXT_DN = 132;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;

    Filter() {
    }

    static void encodeFilterString(BerEncoder ber, String filterStr, boolean isLdapv3) throws IOException, NamingException {
        if (filterStr == null || filterStr.equals("")) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        byte[] filter = isLdapv3 ? filterStr.getBytes("UTF8") : filterStr.getBytes("8859_1");
        int filterLen = filter.length;
        Filter.encodeFilter(ber, filter, 0, filterLen);
    }

    private static void encodeFilter(BerEncoder ber, byte[] filter, int filterStart, int filterEnd) throws IOException, NamingException {
        if (filterEnd - filterStart <= 0) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        int parens = 0;
        int[] filtOffset = new int[]{filterStart};
        while (filtOffset[0] < filterEnd) {
            block0 : switch (filter[filtOffset[0]]) {
                case 40: {
                    filtOffset[0] = filtOffset[0] + 1;
                    ++parens;
                    switch (filter[filtOffset[0]]) {
                        case 38: {
                            Filter.encodeComplexFilter(ber, filter, 160, filtOffset, filterEnd);
                            --parens;
                            break block0;
                        }
                        case 124: {
                            Filter.encodeComplexFilter(ber, filter, 161, filtOffset, filterEnd);
                            --parens;
                            break block0;
                        }
                        case 33: {
                            Filter.encodeComplexFilter(ber, filter, 162, filtOffset, filterEnd);
                            --parens;
                            break block0;
                        }
                    }
                    int balance = 1;
                    boolean escape = false;
                    int nextOffset = filtOffset[0];
                    while (nextOffset < filterEnd && balance > 0) {
                        if (!escape) {
                            if (filter[nextOffset] == 40) {
                                ++balance;
                            } else if (filter[nextOffset] == 41) {
                                --balance;
                            }
                        }
                        escape = filter[nextOffset] == 92 && !escape;
                        if (balance <= 0) continue;
                        ++nextOffset;
                    }
                    if (balance != 0) {
                        throw new InvalidSearchFilterException("Unbalanced parenthesis");
                    }
                    Filter.encodeSimpleFilter(ber, filter, filtOffset[0], nextOffset);
                    filtOffset[0] = nextOffset;
                    --parens;
                    break;
                }
                case 41: {
                    ber.endSeq();
                    filtOffset[0] = filtOffset[0] + 1;
                    --parens;
                    break;
                }
                case 32: {
                    filtOffset[0] = filtOffset[0] + 1;
                    break;
                }
                default: {
                    Filter.encodeSimpleFilter(ber, filter, filtOffset[0], filterEnd);
                    filtOffset[0] = filterEnd;
                }
            }
            filtOffset[0] = filtOffset[0] + 1;
        }
        if (parens > 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
    }

    private static int hexchar2int(byte c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        return -1;
    }

    static byte[] unescapeFilterValue(byte[] orig, int start, int end) throws NamingException {
        boolean escape = false;
        boolean escStart = false;
        int len = end - start;
        byte[] tbuf = new byte[len];
        int j = 0;
        for (int i = start; i < end; ++i) {
            byte ch = orig[i];
            if (escape) {
                int ival = Filter.hexchar2int(ch);
                if (ival < 0) {
                    if (escStart) {
                        escape = false;
                        tbuf[j++] = ch;
                        continue;
                    }
                    throw new InvalidSearchFilterException("invalid escape sequence: " + orig);
                }
                if (escStart) {
                    tbuf[j] = (byte)(ival << 4);
                    escStart = false;
                    continue;
                }
                int n = j++;
                tbuf[n] = (byte)(tbuf[n] | (byte)ival);
                escape = false;
                continue;
            }
            if (ch != 92) {
                tbuf[j++] = ch;
                escape = false;
                continue;
            }
            escape = true;
            escStart = true;
        }
        byte[] answer = new byte[j];
        System.arraycopy(tbuf, 0, answer, 0, j);
        return answer;
    }

    private static int indexOf(byte[] str, char ch, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (str[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(byte[] str, String target, int start, int end) {
        int where = Filter.indexOf(str, target.charAt(0), start, end);
        if (where >= 0) {
            for (int i = 1; i < target.length(); ++i) {
                if (str[where + i] == target.charAt(i)) continue;
                return -1;
            }
        }
        return where;
    }

    private static int findUnescaped(byte[] str, char ch, int start, int end) {
        while (start < end) {
            int where = Filter.indexOf(str, ch, start, end);
            int backSlashCnt = 0;
            int backSlashPos = where - 1;
            while (backSlashPos >= start && str[backSlashPos] == 92) {
                --backSlashPos;
                ++backSlashCnt;
            }
            if (where == start || where == -1 || backSlashCnt % 2 == 0) {
                return where;
            }
            start = where + 1;
        }
        return -1;
    }

    private static void encodeSimpleFilter(BerEncoder ber, byte[] filter, int filtStart, int filtEnd) throws IOException, NamingException {
        int typeEnd;
        int ftype;
        int eq = Filter.indexOf(filter, '=', filtStart, filtEnd);
        if (eq == -1) {
            throw new InvalidSearchFilterException("Missing 'equals'");
        }
        int valueStart = eq + 1;
        int valueEnd = filtEnd;
        int typeStart = filtStart;
        switch (filter[eq - 1]) {
            case 60: {
                ftype = 166;
                typeEnd = eq - 1;
                break;
            }
            case 62: {
                ftype = 165;
                typeEnd = eq - 1;
                break;
            }
            case 126: {
                ftype = 168;
                typeEnd = eq - 1;
                break;
            }
            case 58: {
                ftype = 169;
                typeEnd = eq - 1;
                break;
            }
            default: {
                typeEnd = eq;
                if (Filter.findUnescaped(filter, '*', valueStart, valueEnd) == -1) {
                    ftype = 163;
                    break;
                }
                if (filter[valueStart] == 42 && valueStart == valueEnd - 1) {
                    ftype = 135;
                    break;
                }
                Filter.encodeSubstringFilter(ber, filter, typeStart, typeEnd, valueStart, valueEnd);
                return;
            }
        }
        if (ftype == 135) {
            ber.encodeOctetString(filter, ftype, typeStart, typeEnd - typeStart);
        } else if (ftype == 169) {
            Filter.encodeExtensibleMatch(ber, filter, typeStart, typeEnd, valueStart, valueEnd);
        } else {
            ber.beginSeq(ftype);
            ber.encodeOctetString(filter, 4, typeStart, typeEnd - typeStart);
            ber.encodeOctetString(Filter.unescapeFilterValue(filter, valueStart, valueEnd), 4);
            ber.endSeq();
        }
    }

    private static void encodeSubstringFilter(BerEncoder ber, byte[] filter, int typeStart, int typeEnd, int valueStart, int valueEnd) throws IOException, NamingException {
        int index;
        ber.beginSeq(164);
        ber.encodeOctetString(filter, 4, typeStart, typeEnd - typeStart);
        ber.beginSeq(48);
        int previndex = valueStart;
        while ((index = Filter.findUnescaped(filter, '*', previndex, valueEnd)) != -1) {
            if (previndex == valueStart) {
                if (previndex < index) {
                    ber.encodeOctetString(Filter.unescapeFilterValue(filter, previndex, index), 128);
                }
            } else if (previndex < index) {
                ber.encodeOctetString(Filter.unescapeFilterValue(filter, previndex, index), 129);
            }
            previndex = index + 1;
        }
        if (previndex < valueEnd) {
            ber.encodeOctetString(Filter.unescapeFilterValue(filter, previndex, valueEnd), 130);
        }
        ber.endSeq();
        ber.endSeq();
    }

    private static void encodeComplexFilter(BerEncoder ber, byte[] filter, int filterType, int[] filtOffset, int filtEnd) throws IOException, NamingException {
        filtOffset[0] = filtOffset[0] + 1;
        ber.beginSeq(filterType);
        int[] parens = Filter.findRightParen(filter, filtOffset, filtEnd);
        Filter.encodeFilterList(ber, filter, parens[0], parens[1]);
        ber.endSeq();
    }

    private static int[] findRightParen(byte[] filter, int[] filtOffset, int end) throws IOException, NamingException {
        int balance = 1;
        boolean escape = false;
        int nextOffset = filtOffset[0];
        while (nextOffset < end && balance > 0) {
            if (!escape) {
                if (filter[nextOffset] == 40) {
                    ++balance;
                } else if (filter[nextOffset] == 41) {
                    --balance;
                }
            }
            escape = filter[nextOffset] == 92 && !escape;
            if (balance <= 0) continue;
            ++nextOffset;
        }
        if (balance != 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
        int[] tmp = new int[]{filtOffset[0], nextOffset};
        filtOffset[0] = nextOffset + 1;
        return tmp;
    }

    private static void encodeFilterList(BerEncoder ber, byte[] filter, int start, int end) throws IOException, NamingException {
        int[] filtOffset = new int[]{start};
        while (filtOffset[0] < end) {
            if (!Character.isSpaceChar((char)filter[filtOffset[0]]) && filter[filtOffset[0]] != 40) {
                int[] parens = Filter.findRightParen(filter, filtOffset, end);
                int len = parens[1] - parens[0];
                byte[] newfilter = new byte[len + 2];
                System.arraycopy(filter, parens[0], newfilter, 1, len);
                newfilter[0] = 40;
                newfilter[len + 1] = 41;
                Filter.encodeFilter(ber, newfilter, 0, newfilter.length);
            }
            filtOffset[0] = filtOffset[0] + 1;
        }
    }

    private static void encodeExtensibleMatch(BerEncoder ber, byte[] filter, int matchStart, int matchEnd, int valueStart, int valueEnd) throws IOException, NamingException {
        boolean matchDN = false;
        ber.beginSeq(169);
        int colon = Filter.indexOf(filter, ':', matchStart, matchEnd);
        if (colon >= 0) {
            int colon2;
            int i = Filter.indexOf(filter, ":dn", colon, matchEnd);
            if (i >= 0) {
                matchDN = true;
            }
            if ((colon2 = Filter.indexOf(filter, ':', colon + 1, matchEnd)) >= 0 || i == -1) {
                if (i == colon) {
                    ber.encodeOctetString(filter, 129, colon2 + 1, matchEnd - (colon2 + 1));
                } else if (i == colon2 && i >= 0) {
                    ber.encodeOctetString(filter, 129, colon + 1, colon2 - (colon + 1));
                } else {
                    ber.encodeOctetString(filter, 129, colon + 1, matchEnd - (colon + 1));
                }
            }
            if (colon > matchStart) {
                ber.encodeOctetString(filter, 130, matchStart, colon - matchStart);
            }
        } else {
            ber.encodeOctetString(filter, 130, matchStart, matchEnd - matchStart);
        }
        ber.encodeOctetString(Filter.unescapeFilterValue(filter, valueStart, valueEnd), 131);
        ber.encodeBoolean(matchDN, 132);
        ber.endSeq();
    }

    private static void dprint(String msg) {
        Filter.dprint(msg, new byte[0], 0, 0);
    }

    private static void dprint(String msg, byte[] str) {
        Filter.dprint(msg, str, 0, str.length);
    }

    private static void dprint(String msg, byte[] str, int start, int end) {
        String dstr = "  ";
        int i = dbgIndent;
        while (i-- > 0) {
            dstr = dstr + "  ";
        }
        dstr = dstr + msg;
        System.err.print(dstr);
        for (int j = start; j < end; ++j) {
            System.err.print((char)str[j]);
        }
        System.err.println();
    }
}

