/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import javax.swing.KeyStroke;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class MotifTextUI {
    static final JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 1), "selection-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 1), "selection-forward")};

    public static Caret createCaret() {
        return new MotifCaret();
    }

    public static class MotifCaret
    extends DefaultCaret
    implements UIResource {
        static final int IBeamOverhang = 2;

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            this.getComponent().repaint();
        }

        protected void damage(Rectangle r) {
            if (r != null) {
                this.x = r.x - 2 - 1;
                this.y = r.y;
                this.width = r.width + 4 + 3;
                this.height = r.height;
                this.repaint();
            }
        }

        public void paint(Graphics g) {
            if (this.isVisible()) {
                try {
                    JTextComponent c = this.getComponent();
                    Color fg = c.hasFocus() ? c.getCaretColor() : c.getDisabledTextColor();
                    TextUI mapper = c.getUI();
                    int dot = this.getDot();
                    Rectangle r = mapper.modelToView(c, dot);
                    int x0 = r.x - 2;
                    int x1 = r.x + 2;
                    int y0 = r.y + 1;
                    int y1 = r.y + r.height - 2;
                    g.setColor(fg);
                    g.drawLine(r.x, y0, r.x, y1);
                    g.drawLine(x0, y0, x1, y0);
                    g.drawLine(x0, y1, x1, y1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

