/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.CryptoPermission;
import javax.crypto.CryptoPolicyParser;
import javax.crypto.PermissionsEnumerator;

final class CryptoPermissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4946547168093391015L;
    private Hashtable perms = new Hashtable(7);

    CryptoPermissions() {
    }

    void load(InputStream in) throws IOException, CryptoPolicyParser.ParsingException {
        CryptoPolicyParser parser = new CryptoPolicyParser();
        parser.read(new BufferedReader(new InputStreamReader(in, "UTF-8")));
        CryptoPermission[] parsingResult = parser.getPermissions();
        for (int i = 0; i < parsingResult.length; ++i) {
            this.add(parsingResult[i]);
        }
    }

    boolean isEmpty() {
        return this.perms.isEmpty();
    }

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("Attempt to add a Permission to a readonly CryptoPermissions object");
        }
        if (!(permission instanceof CryptoPermission)) {
            return;
        }
        CryptoPermission cryptoPerm = (CryptoPermission)permission;
        PermissionCollection pc = this.getPermissionCollection(cryptoPerm);
        pc.add(cryptoPerm);
        String alg = cryptoPerm.getAlgorithm();
        if (!this.perms.containsKey(alg)) {
            this.perms.put(alg, pc);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof CryptoPermission)) {
            return false;
        }
        CryptoPermission cryptoPerm = (CryptoPermission)permission;
        PermissionCollection pc = this.getPermissionCollection(cryptoPerm.getAlgorithm());
        return pc.implies(cryptoPerm);
    }

    public Enumeration elements() {
        return new PermissionsEnumerator(this.perms.elements());
    }

    CryptoPermissions getMinimum(CryptoPermissions other) {
        if (other == null) {
            return null;
        }
        if (this.perms.containsKey("CryptoAllPermission")) {
            return other;
        }
        if (other.perms.containsKey("CryptoAllPermission")) {
            return this;
        }
        CryptoPermissions ret = new CryptoPermissions();
        PermissionCollection thatWildcard = (PermissionCollection)other.perms.get("*");
        int maxKeySize = 0;
        if (thatWildcard != null) {
            maxKeySize = ((CryptoPermission)thatWildcard.elements().nextElement()).getMaxKeySize();
        }
        Enumeration thisKeys = this.perms.keys();
        while (thisKeys.hasMoreElements()) {
            CryptoPermission[] partialResult;
            String alg = (String)thisKeys.nextElement();
            PermissionCollection thisPc = (PermissionCollection)this.perms.get(alg);
            PermissionCollection thatPc = (PermissionCollection)other.perms.get(alg);
            if (thatPc == null) {
                if (thatWildcard == null) continue;
                partialResult = this.getMinimum(maxKeySize, thisPc);
            } else {
                partialResult = this.getMinimum(thisPc, thatPc);
            }
            for (int i = 0; i < partialResult.length; ++i) {
                ret.add(partialResult[i]);
            }
        }
        PermissionCollection thisWildcard = (PermissionCollection)this.perms.get("*");
        if (thisWildcard == null) {
            return ret;
        }
        maxKeySize = ((CryptoPermission)thisWildcard.elements().nextElement()).getMaxKeySize();
        Enumeration thatKeys = other.perms.keys();
        while (thatKeys.hasMoreElements()) {
            String alg = (String)thatKeys.nextElement();
            if (this.perms.containsKey(alg)) continue;
            PermissionCollection thatPc = (PermissionCollection)other.perms.get(alg);
            CryptoPermission[] partialResult = this.getMinimum(maxKeySize, thatPc);
            for (int i = 0; i < partialResult.length; ++i) {
                ret.add(partialResult[i]);
            }
        }
        return ret;
    }

    private CryptoPermission[] getMinimum(PermissionCollection thisPc, PermissionCollection thatPc) {
        Vector<CryptoPermission> permVector = new Vector<CryptoPermission>(2);
        Enumeration<Permission> thisPcPermissions = thisPc.elements();
        block0: while (thisPcPermissions.hasMoreElements()) {
            CryptoPermission thisCp = (CryptoPermission)thisPcPermissions.nextElement();
            Enumeration<Permission> thatPcPermissions = thatPc.elements();
            while (thatPcPermissions.hasMoreElements()) {
                CryptoPermission thatCp = (CryptoPermission)thatPcPermissions.nextElement();
                if (thatCp.implies(thisCp)) {
                    permVector.addElement(thisCp);
                    continue block0;
                }
                if (!thisCp.implies(thatCp)) continue;
                permVector.addElement(thatCp);
            }
        }
        Object[] ret = new CryptoPermission[permVector.size()];
        permVector.copyInto(ret);
        return ret;
    }

    private CryptoPermission[] getMinimum(int maxKeySize, PermissionCollection pc) {
        Vector<CryptoPermission> permVector = new Vector<CryptoPermission>(1);
        Enumeration<Permission> enum_ = pc.elements();
        while (enum_.hasMoreElements()) {
            CryptoPermission cp = (CryptoPermission)enum_.nextElement();
            if (cp.getMaxKeySize() <= maxKeySize) {
                permVector.addElement(cp);
                continue;
            }
            if (cp.getCheckParam()) {
                permVector.addElement(new CryptoPermission(cp.getAlgorithm(), maxKeySize, cp.getAlgorithmParameterSpec(), cp.getExemptionMechanism()));
                continue;
            }
            permVector.addElement(new CryptoPermission(cp.getAlgorithm(), maxKeySize, cp.getExemptionMechanism()));
        }
        Object[] ret = new CryptoPermission[permVector.size()];
        permVector.copyInto(ret);
        return ret;
    }

    PermissionCollection getPermissionCollection(String alg) {
        if (this.perms.containsKey("CryptoAllPermission")) {
            return (PermissionCollection)this.perms.get("CryptoAllPermission");
        }
        PermissionCollection pc = (PermissionCollection)this.perms.get(alg);
        if (pc == null) {
            pc = (PermissionCollection)this.perms.get("*");
        }
        return pc;
    }

    private PermissionCollection getPermissionCollection(CryptoPermission cryptoPerm) {
        String alg = cryptoPerm.getAlgorithm();
        PermissionCollection pc = (PermissionCollection)this.perms.get(alg);
        if (pc == null) {
            pc = cryptoPerm.newPermissionCollection();
        }
        return pc;
    }
}

