/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteJIS0201;
import sun.io.CharToByteJIS0208;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteEUC_JP_LINUX
extends CharToByteJIS0208 {
    CharToByteJIS0201 cbJIS0201 = new CharToByteJIS0201();

    public String getCharacterEncoding() {
        return "EUC_JP_LINUX";
    }

    protected int convSingleByte(char inputChar, byte[] outputByte) {
        if (inputChar == '\u0000') {
            outputByte[0] = 0;
            return 1;
        }
        byte b = this.cbJIS0201.getNative(inputChar);
        if (b == 0) {
            return 0;
        }
        if (b > 0 && b < 128) {
            outputByte[0] = b;
            return 1;
        }
        outputByte[0] = -114;
        outputByte[1] = b;
        return 2;
    }

    protected int getNative(char ch) {
        int offset = this.index1[(ch & 0xFF00) >> 8] << 8;
        char r = this.index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
        if (r != '\u0000') {
            return r + 32896;
        }
        return r;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int inputSize = 0;
        int outputSize = 0;
        byte[] tmpbuf = new byte[4];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            char inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        while (this.charOff < inEnd) {
            byte[] outputByte;
            block15: {
                inputSize = 1;
                outputByte = tmpbuf;
                char inputChar = input[this.charOff];
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 >= inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + 1];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                        inputSize = 2;
                        break block15;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                outputSize = this.convSingleByte(inputChar, outputByte);
                if (outputSize == 0) {
                    int ncode = this.getNative(inputChar);
                    if (ncode != 0 && (ncode & 0xFF0000) == 0) {
                        outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                        outputByte[1] = (byte)(ncode & 0xFF);
                        outputSize = 2;
                    } else {
                        if (!this.subMode) {
                            this.badInputLength = 1;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                    }
                }
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }
}

