/*
 * Decompiled with CFR 0.152.
 */
package build.tools.javazic;

import build.tools.javazic.Main;
import build.tools.javazic.Month;
import build.tools.javazic.Rule;
import build.tools.javazic.RuleRec;
import build.tools.javazic.Time;
import build.tools.javazic.Timezone;
import build.tools.javazic.Zone;
import build.tools.javazic.ZoneRec;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class Zoneinfo {
    private static final int minYear = 1900;
    private static final int maxYear = 2037;
    private static final long minTime = Time.getLocalTime(1900, Month.JANUARY, 1, 0);
    private static int startYear = 1900;
    private static int endYear = 2037;
    static boolean isYearForTimeZoneDataSpecified = false;
    private Map<String, Zone> zones = new HashMap<String, Zone>();
    private Map<String, Rule> rules = new HashMap<String, Rule>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private static String line;
    private static int lineNum;

    Zoneinfo() {
    }

    void add(Zone zone) {
        String string = zone.getName();
        this.zones.put(string, zone);
    }

    void add(Rule rule) {
        String string = rule.getName();
        this.rules.put(string, rule);
    }

    void putAlias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    static void setYear(int n) {
        Zoneinfo.setStartYear(n);
        Zoneinfo.setEndYear(n);
        isYearForTimeZoneDataSpecified = true;
    }

    static void setStartYear(int n) {
        if (n < 1900 || n > endYear) {
            throw new IllegalArgumentException("invalid start year specified: " + n);
        }
        startYear = n;
    }

    static int getStartYear() {
        return startYear;
    }

    static void setEndYear(int n) {
        if (n < startYear || n > 2037) {
            throw new IllegalArgumentException();
        }
        endYear = n;
    }

    static int getEndYear() {
        return endYear;
    }

    static int getMinYear() {
        return 1900;
    }

    static int getMaxYear() {
        return 2037;
    }

    Map<String, String> getAliases() {
        return this.aliases;
    }

    Map<String, Zone> getZones() {
        return this.zones;
    }

    Zone getZone(String string) {
        return this.zones.get(string);
    }

    Rule getRule(String string) {
        return this.rules.get(string);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Zoneinfo parse(String var0) {
        var1_1 = null;
        try {
            var2_2 = new FileReader(var0);
            var1_1 = new BufferedReader((Reader)var2_2);
        }
        catch (FileNotFoundException var2_3) {
            Zoneinfo.panic("can't open file: " + var0);
        }
        var2_2 = new Zoneinfo();
        var3_4 = false;
        var4_5 = null;
        try {
            while (true) lbl-1000:
            // 10 sources

            {
                if ((Zoneinfo.line = var1_1.readLine()) == null) {
                    var1_1.close();
                    return var2_2;
                }
                ++Zoneinfo.lineNum;
                if (Zoneinfo.line.length() == 0 || Zoneinfo.line.charAt(0) == '#' || !(var7_9 = new StringTokenizer(var5_6 = (var6_7 = Zoneinfo.line.lastIndexOf(35)) != -1 ? Zoneinfo.line.substring(0, var6_7) : Zoneinfo.line)).hasMoreTokens()) continue;
                var8_10 = var7_9.nextToken();
                if (var3_4 || "Zone".equals(var8_10)) {
                    if (var4_5 == null) {
                        if (!var7_9.hasMoreTokens()) {
                            Zoneinfo.panic("syntax error: zone no more token");
                        }
                        if ((var8_10 = var7_9.nextToken()).startsWith("GMT+") || var8_10.startsWith("GMT-")) continue;
                        var4_5 = new Zone(var8_10);
                    } else {
                        var7_9 = new StringTokenizer(var5_6);
                    }
                    var9_11 = ZoneRec.parse(var7_9);
                    var9_11.setLine(Zoneinfo.line);
                    var4_5.add((ZoneRec)var9_11);
                    var3_4 = var9_11.hasUntil();
                    if (var3_4) continue;
                    if (Zone.isTargetZone(var4_5.getName())) {
                        var2_2.add(var4_5);
                    }
                    var4_5 = null;
                    continue;
                }
                if ("Rule".equals(var8_10)) {
                    if (!var7_9.hasMoreTokens()) {
                        Zoneinfo.panic("syntax error: rule no more token");
                    }
                    if ((var9_11 = var2_2.getRule(var8_10 = var7_9.nextToken())) == null) {
                        var9_11 = new Rule(var8_10);
                        var2_2.add((Rule)var9_11);
                    }
                    var10_13 = RuleRec.parse(var7_9);
                    var10_13.setLine(Zoneinfo.line);
                    var9_11.add((RuleRec)var10_13);
                    continue;
                }
                if (!"Link".equals(var8_10)) continue;
                try {
                    var9_11 = var7_9.nextToken();
                    var10_13 = var7_9.nextToken();
                    if (var10_13.startsWith("GMT+") || var10_13.startsWith("GMT-") || "ROC".equals(var10_13)) ** GOTO lbl-1000
                    var2_2.putAlias((String)var10_13, (String)var9_11);
                }
                catch (Exception var9_12) {
                    Zoneinfo.panic("syntax error: no more token for Link");
                    continue;
                }
                break;
            }
        }
        catch (IOException var6_8) {
            Zoneinfo.panic("IO error: " + var6_8.getMessage());
        }
        ** GOTO lbl-1000
        return var2_2;
    }

    Timezone phase2(String string) {
        int n;
        Timezone timezone = new Timezone(string);
        Zone zone = this.getZone(string);
        zone.resolve(this);
        if (isYearForTimeZoneDataSpecified) {
            ZoneRec zoneRec = zone.get(zone.size() - 1);
            timezone.setLastZoneRec(zoneRec);
            timezone.setRawOffset(zoneRec.getGmtOffset());
            if (zoneRec.hasRuleReference()) {
                List<RuleRec> list = zoneRec.getRuleRef().getRules(startYear);
                if (list.size() == 2) {
                    RuleRec ruleRec = list.get(0);
                    RuleRec ruleRec2 = list.get(1);
                    if (ruleRec.getSave() == 0 && ruleRec2.getSave() > 0) {
                        list.set(0, ruleRec2);
                        list.set(1, ruleRec);
                    } else if (ruleRec.getSave() <= 0 || ruleRec2.getSave() != 0) {
                        list = null;
                        Main.error(string + ": rules for " + startYear + " not found.");
                    }
                } else {
                    list = null;
                }
                if (list != null) {
                    timezone.setLastRules(list);
                }
            }
            return timezone;
        }
        int n2 = n = 1900;
        long l = Time.getLocalTime(startYear, Month.JANUARY, 1, 0);
        ZoneRec zoneRec = zone.get(zone.size() - 1);
        timezone.getOffsetIndex(zoneRec.getGmtOffset());
        int n3 = 0;
        for (int i = 0; i < zone.size(); ++i) {
            zoneRec = zone.get(i);
            boolean bl = false;
            int n4 = zoneRec.getGmtOffset();
            int n5 = zoneRec.getDirectSave();
            if (!zoneRec.hasUntil()) {
                timezone.setRawOffset(n4, l);
                if (zoneRec.hasRuleReference()) {
                    timezone.setLastRules(zoneRec.getRuleRef().getLastRules());
                } else if (n5 != 0) {
                    timezone.setLastDSTSaving(n5);
                }
            }
            if (!zoneRec.hasRuleReference()) {
                if (!zoneRec.hasUntil() || zoneRec.getUntilTime(n5) >= l) {
                    timezone.addTransition(l, timezone.getOffsetIndex(n4 + n5), timezone.getDstOffsetIndex(n5));
                    bl = true;
                }
                n3 = n5;
                if (!zoneRec.hasUntil()) {
                    if (timezone.getNTransitions() > 0) {
                        if (n5 == 0) {
                            timezone.setDSTType(3);
                        } else {
                            timezone.setDSTType(2);
                        }
                        long l2 = Time.getLocalTime(2037, Month.JANUARY, 1, 0);
                        timezone.addTransition(l2 -= (long)zoneRec.getGmtOffset(), timezone.getOffsetIndex(n4 + n5), timezone.getDstOffsetIndex(n5));
                        timezone.addUsedRec(zoneRec);
                        break;
                    }
                    timezone.setDSTType(1);
                    break;
                }
            } else {
                Rule rule = zoneRec.getRuleRef();
                boolean bl2 = false;
                n3 = 0;
                block1: for (n = Zoneinfo.getMinYear(); !(n > endYear || zoneRec.hasUntil() && n > zoneRec.getUntilYear()); ++n) {
                    List<RuleRec> list = rule.getRules(n);
                    if (list.size() > 0) {
                        for (int j = 0; j < list.size(); ++j) {
                            RuleRec ruleRec = list.get(j);
                            long l3 = ruleRec.getTransitionTime(n, n4, n3);
                            if (zoneRec.hasUntil() && l3 >= zoneRec.getUntilTime(n3)) break block1;
                            if (!bl2) {
                                int n6;
                                if (l <= l3) {
                                    bl2 = true;
                                    if (l != minTime) {
                                        List<RuleRec> list2;
                                        ZoneRec zoneRec2 = zone.get(i - 1);
                                        if (ruleRec.isSameTransition(zoneRec2, n6 = j > 0 ? list.get(j - 1).getSave() : ((list2 = rule.getRules(n - 1)).size() > 0 ? list2.get(list2.size() - 1).getSave() : 0), n4)) {
                                            n3 = ruleRec.getSave();
                                            timezone.addTransition(l, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                                            timezone.addUsedRec(ruleRec);
                                            bl = true;
                                            continue;
                                        }
                                        if (!zoneRec2.hasRuleReference() || rule != zoneRec2.getRuleRef() || rule == zoneRec2.getRuleRef() && n4 != zoneRec2.getGmtOffset()) {
                                            int n7 = l == l3 ? ruleRec.getSave() : n3;
                                            timezone.addTransition(l, timezone.getOffsetIndex(n4 + n7), timezone.getDstOffsetIndex(n7));
                                            timezone.addUsedRec(ruleRec);
                                            bl = true;
                                        }
                                    } else {
                                        n6 = ruleRec.getSave();
                                        timezone.addTransition(l, timezone.getOffsetIndex(n4 + n6), timezone.getDstOffsetIndex(n6));
                                        timezone.addUsedRec(ruleRec);
                                        bl = true;
                                    }
                                } else if (n == n2 && j == list.size() - 1) {
                                    n6 = ruleRec.getSave();
                                    timezone.addTransition(l, timezone.getOffsetIndex(n4 + n6), timezone.getDstOffsetIndex(n6));
                                }
                            }
                            n3 = ruleRec.getSave();
                            if (l >= l3) continue;
                            timezone.addTransition(l3, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                            timezone.addUsedRec(ruleRec);
                            bl = true;
                        }
                        continue;
                    }
                    if (n == n2) {
                        timezone.addTransition(l, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                        bl2 = true;
                    }
                    if (n != endYear || zoneRec.hasUntil()) continue;
                    if (timezone.getNTransitions() > 0) {
                        timezone.setDSTType(3);
                        long l4 = Time.getLocalTime(2037, Month.JANUARY, 1, 0);
                        timezone.addTransition(l4 -= (long)zoneRec.getGmtOffset(), timezone.getOffsetIndex(n4), timezone.getDstOffsetIndex(0));
                        bl = true;
                        continue;
                    }
                    timezone.setDSTType(1);
                }
            }
            if (bl) {
                timezone.addUsedRec(zoneRec);
            }
            if (!zoneRec.hasUntil() || zoneRec.getUntilTime(n3) <= l) continue;
            l = zoneRec.getUntilTime(n3);
            n2 = zoneRec.getUntilYear();
            n = zoneRec.getUntilYear();
        }
        if (timezone.getDSTType() == 0) {
            timezone.setDSTType(4);
        }
        timezone.optimize();
        timezone.checksum();
        return timezone;
    }

    private static void panic(String string) {
        Main.panic(string);
    }
}

