/*
 * Decompiled with CFR 0.152.
 */
package build.tools.javazic;

import build.tools.javazic.Main;
import build.tools.javazic.Month;
import build.tools.javazic.RuleDay;
import build.tools.javazic.Time;
import build.tools.javazic.ZoneRec;
import build.tools.javazic.Zoneinfo;
import java.util.StringTokenizer;

class RuleRec {
    private int fromYear;
    private int toYear;
    private String type;
    private Month inMonth;
    private RuleDay onDay;
    private Time atTime;
    private int save;
    private String letters;
    private String line;
    private boolean isLastRule;

    RuleRec() {
    }

    int getFromYear() {
        return this.fromYear;
    }

    int getToYear() {
        return this.toYear;
    }

    Month getMonth() {
        return this.inMonth;
    }

    int getMonthNum() {
        return this.inMonth.value();
    }

    RuleDay getDay() {
        return this.onDay;
    }

    Time getTime() {
        return this.atTime;
    }

    int getSave() {
        return this.save;
    }

    String getLine() {
        return this.line;
    }

    void setLine(String string) {
        this.line = string;
    }

    boolean isOdd() {
        return "odd".equals(this.type);
    }

    boolean isEven() {
        return "even".equals(this.type);
    }

    boolean isLastRule() {
        return this.isLastRule;
    }

    boolean isSameTransition(ZoneRec zoneRec, int n, int n2) {
        long l;
        long l2;
        if (zoneRec.getUntilTime().getType() != this.atTime.getType()) {
            l2 = zoneRec.getLocalUntilTime(n, n2);
            l = Time.getLocalTime(zoneRec.getUntilYear(), this.getMonth(), this.getDay(), n, n2, this.atTime);
        } else {
            l2 = zoneRec.getLocalUntilTime();
            l = Time.getLocalTime(zoneRec.getUntilYear(), this.getMonth(), this.getDay(), this.atTime.getTime());
        }
        return l2 == l;
    }

    static RuleRec parse(StringTokenizer stringTokenizer) {
        RuleRec ruleRec = new RuleRec();
        try {
            String string = stringTokenizer.nextToken();
            try {
                ruleRec.fromYear = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if ("min".equals(string) || "minimum".equals(string)) {
                    ruleRec.fromYear = Zoneinfo.getMinYear();
                }
                if ("max".equals(string) || "maximum".equals(string)) {
                    ruleRec.fromYear = Zoneinfo.getMaxYear();
                }
                Main.panic("invalid year value: " + string);
            }
            string = stringTokenizer.nextToken();
            ruleRec.isLastRule = false;
            try {
                ruleRec.toYear = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if ("min".equals(string) || "minimum".equals(string)) {
                    ruleRec.fromYear = Zoneinfo.getMinYear();
                }
                if ("max".equals(string) || "maximum".equals(string)) {
                    ruleRec.toYear = Integer.MAX_VALUE;
                    ruleRec.isLastRule = true;
                }
                if ("only".equals(string)) {
                    ruleRec.toYear = ruleRec.fromYear;
                }
                Main.panic("invalid year value: " + string);
            }
            ruleRec.type = stringTokenizer.nextToken();
            ruleRec.inMonth = Month.parse(stringTokenizer.nextToken());
            ruleRec.onDay = RuleDay.parse(stringTokenizer.nextToken());
            ruleRec.atTime = Time.parse(stringTokenizer.nextToken());
            ruleRec.save = (int)Time.parse(stringTokenizer.nextToken()).getTime();
            ruleRec.letters = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ruleRec;
    }

    long getTransitionTime(int n, int n2, int n3) {
        long l = Time.getLocalTime(n, this.getMonth(), this.getDay(), this.atTime.getTime());
        if (this.atTime.isSTD()) {
            l -= (long)n2;
        } else if (this.atTime.isWall()) {
            l -= (long)(n2 + n3);
        }
        return l;
    }

    private static int getInt(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        return Integer.parseInt(string);
    }
}

