/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import java.util.List;
import org.classpath.icedtea.pulseaudio.ContextEvent;
import org.classpath.icedtea.pulseaudio.ContextListener;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

final class EventLoop
implements Runnable {
    final Object threadLock = new Object();
    private static EventLoop instance = null;
    private List<ContextListener> contextListeners;
    private String appName;
    private String serverString;
    private int status;
    private List<String> targetPortNameList = new ArrayList<String>();
    private List<String> sourcePortNameList = new ArrayList<String>();
    private byte[] contextPointer;
    private byte[] mainloopPointer;

    private native void native_setup(String var1, String var2);

    private native int native_iterate(int var1);

    private native void native_shutdown();

    private native void native_set_sink_volume(byte[] var1, int var2);

    private EventLoop() {
        this.contextListeners = new ArrayList<ContextListener>();
    }

    static synchronized EventLoop getEventLoop() {
        if (instance == null) {
            instance = new EventLoop();
        }
        return instance;
    }

    void setAppName(String appName) {
        this.appName = appName;
    }

    void setServer(String serverString) {
        this.serverString = serverString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.native_setup(this.appName, this.serverString);
        Debug.println(Debug.DebugLevel.Info, "Eventloop.run(): eventloop starting");
        while (true) {
            Object object = this.threadLock;
            synchronized (object) {
                this.native_iterate(100);
                if (Thread.interrupted()) {
                    this.native_shutdown();
                    List<ContextListener> list = this.contextListeners;
                    synchronized (list) {
                        this.contextListeners.clear();
                    }
                    Debug.println(Debug.DebugLevel.Info, "EventLoop.run(): event loop terminated");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextListener(ContextListener contextListener) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            this.contextListeners.add(contextListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextListener(ContextListener contextListener) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            this.contextListeners.remove(contextListener);
        }
    }

    int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(int status) {
        Object object = this.threadLock;
        synchronized (object) {
            this.status = status;
            switch (status) {
                case 0: {
                    this.fireEvent(new ContextEvent(ContextEvent.Type.UNCONNECTED));
                    break;
                }
                case 1: {
                    this.fireEvent(new ContextEvent(ContextEvent.Type.CONNECTING));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.fireEvent(new ContextEvent(ContextEvent.Type.READY));
                    break;
                }
                case 5: {
                    this.fireEvent(new ContextEvent(ContextEvent.Type.FAILED));
                    Debug.println(Debug.DebugLevel.Warning, "EventLoop.update(): Context failed");
                    break;
                }
                case 6: {
                    this.fireEvent(new ContextEvent(ContextEvent.Type.TERMINATED));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ContextEvent e) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            for (ContextListener listener : this.contextListeners) {
                listener.update(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVolume(byte[] streamPointer, int volume) {
        Object object = this.threadLock;
        synchronized (object) {
            this.native_set_sink_volume(streamPointer, volume);
        }
    }

    byte[] getContextPointer() {
        return this.contextPointer;
    }

    byte[] getMainLoopPointer() {
        return this.mainloopPointer;
    }

    private native byte[] nativeUpdateTargetPortNameList();

    private native byte[] nativeUpdateSourcePortNameList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<String> updateTargetPortNameList() {
        Operation op;
        this.targetPortNameList = new ArrayList<String>();
        Object object = this.threadLock;
        synchronized (object) {
            op = new Operation(this.nativeUpdateTargetPortNameList());
        }
        op.waitForCompletion();
        assert (op.getState() == Operation.State.Done);
        op.releaseReference();
        return this.targetPortNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<String> updateSourcePortNameList() {
        Operation op;
        this.sourcePortNameList = new ArrayList<String>();
        Object object = this.threadLock;
        synchronized (object) {
            op = new Operation(this.nativeUpdateSourcePortNameList());
        }
        op.waitForCompletion();
        assert (op.getState() == Operation.State.Done);
        op.releaseReference();
        return this.sourcePortNameList;
    }

    public void source_callback(String name) {
        this.sourcePortNameList.add(name);
    }

    public void sink_callback(String name) {
        this.targetPortNameList.add(name);
    }

    static {
        SecurityWrapper.loadNativeLibrary();
    }
}

