/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComboBox;
import sun.tools.jconsole.Plotter;

public class TimeComboBox
extends JComboBox
implements ItemListener,
PropertyChangeListener {
    private ArrayList<Plotter> plotters = new ArrayList();

    public TimeComboBox(Plotter ... plotterArray) {
        super(Plotter.rangeNames);
        this.addItemListener(this);
        if (plotterArray != null && plotterArray.length > 0) {
            this.plotters.addAll(Arrays.asList(plotterArray));
            this.selectValue(plotterArray[0].getViewRange());
            for (Plotter plotter : this.plotters) {
                plotter.addPropertyChangeListener(this);
            }
        }
    }

    public void addPlotter(Plotter plotter) {
        this.plotters.add(plotter);
        if (this.plotters.size() == 1) {
            this.selectValue(plotter.getViewRange());
        }
        plotter.addPropertyChangeListener(this);
    }

    public void itemStateChanged(ItemEvent ev) {
        for (Plotter plotter : this.plotters) {
            plotter.setViewRange(Plotter.rangeValues[this.getSelectedIndex()]);
        }
    }

    private void selectValue(int value) {
        for (int i = 0; i < Plotter.rangeValues.length; ++i) {
            if (Plotter.rangeValues[i] != value) continue;
            this.setSelectedItem(Plotter.rangeNames[i]);
        }
        if (this.plotters.size() > 1) {
            for (Plotter plotter : this.plotters) {
                plotter.setViewRange(value);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName() == "viewRange") {
            this.selectValue((Integer)ev.getNewValue());
        }
    }
}

