/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.AbstractWrapper;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager;
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;

    public SSLContextImpl() {
        this(null);
    }

    SSLContextImpl(SSLContextImpl other) {
        if (other == null) {
            this.ephemeralKeyManager = new EphemeralKeyManager();
            this.clientCache = new SSLSessionContextImpl();
            this.serverCache = new SSLSessionContextImpl();
        } else {
            this.ephemeralKeyManager = other.ephemeralKeyManager;
            this.clientCache = other.clientCache;
            this.serverCache = other.serverCache;
        }
    }

    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(km);
        if (tm == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(tm);
        if (sr == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && sr.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = sr;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] tm) throws KeyManagementException {
        for (int i = 0; tm != null && i < tm.length; ++i) {
            if (!(tm[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(tm[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            return (X509TrustManager)tm[i];
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] kms) throws KeyManagementException {
        for (int i = 0; kms != null && i < kms.length; ++i) {
            KeyManager km = kms[i];
            if (!(km instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (km instanceof X509KeyManagerImpl || km instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)km;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (km instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)km;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractWrapper((X509KeyManager)km);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this, host, port);
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }
}

