/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    static final AlgorithmId rsaId = new AlgorithmId(AlgorithmId.RSAEncryption_oid);

    public static RSAPrivateKey newKey(byte[] encoded) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl key = new RSAPrivateCrtKeyImpl(encoded);
        if (key.getPublicExponent().signum() == 0) {
            return new RSAPrivateKeyImpl(key.getModulus(), key.getPrivateExponent());
        }
        return key;
    }

    RSAPrivateCrtKeyImpl(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
    }

    RSAPrivateCrtKeyImpl(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) throws InvalidKeyException {
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.pe = pe;
        this.qe = qe;
        this.coeff = coeff;
        RSAKeyFactory.checkRSAProviderKeyLengths(n.bitLength(), e);
        this.algid = rsaId;
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(0);
            out.putInteger(n);
            out.putInteger(e);
            out.putInteger(d);
            out.putInteger(p);
            out.putInteger(q);
            out.putInteger(pe);
            out.putInteger(qe);
            out.putInteger(coeff);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            int version = data.getInteger();
            if (version != 0) {
                throw new IOException("Version must be 0");
            }
            this.n = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.e = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.d = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.p = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.q = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.pe = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.qe = RSAPrivateCrtKeyImpl.getBigInteger(data);
            this.coeff = RSAPrivateCrtKeyImpl.getBigInteger(data);
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid RSA private key", e);
        }
    }

    static BigInteger getBigInteger(DerInputStream data) throws IOException {
        BigInteger b = data.getBigInteger();
        if (b.signum() < 0) {
            b = new BigInteger(1, b.toByteArray());
        }
        return b;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sun RSA private CRT key, ");
        sb.append(this.n.bitLength());
        sb.append(" bits\n  modulus:          ");
        sb.append(this.n);
        sb.append("\n  public exponent:  ");
        sb.append(this.e);
        sb.append("\n  private exponent: ");
        sb.append(this.d);
        sb.append("\n  prime p:          ");
        sb.append(this.p);
        sb.append("\n  prime q:          ");
        sb.append(this.q);
        sb.append("\n  prime exponent p: ");
        sb.append(this.pe);
        sb.append("\n  prime exponent q: ");
        sb.append(this.qe);
        sb.append("\n  crt coefficient:  ");
        sb.append(this.coeff);
        return sb.toString();
    }
}

