/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final long MAX_CLOCK_SKEW = 900000L;

    /*
     * WARNING - void declaration
     */
    OCSPResponse(byte[] bytes, Date dateCheckedAgainst, X509Certificate responderCert) throws IOException, CertPathValidatorException {
        void cert;
        short tag;
        DerValue der = new DerValue(bytes);
        if (der.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        this.responseStatus = rsvalues[status];
        if (DEBUG != null) {
            DEBUG.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            return;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.data.getDerValue();
        if (tmp.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.data;
        ObjectIdentifier responseType = derIn.getOID();
        if (responseType.equals(OCSP_BASIC_RESPONSE_OID)) {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: basic");
            }
        } else {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: " + responseType);
            }
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        byte[] responseDataDer = seqTmp[0].toByteArray();
        if (responseData.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.data;
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.data.getDerValue();
            int version = seq.getInteger();
            if (seq.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        if ((tag = (short)((byte)(seq.tag & 0x1F))) == 1) {
            if (DEBUG != null) {
                X500Name responderName = new X500Name(seq.getData());
                DEBUG.println("OCSP Responder name: " + responderName);
            }
        } else if (tag != 2) {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        seq = seqDerIn.getDerValue();
        if (DEBUG != null) {
            Date producedAtDate = seq.getGeneralizedTime();
            DEBUG.println("OCSP response produced at: " + producedAtDate);
        }
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(singleResponseDer.length);
        if (DEBUG != null) {
            DEBUG.println("OCSP number of SingleResponses: " + singleResponseDer.length);
        }
        for (int i = 0; i < singleResponseDer.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(singleResponseDer[i]);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] responseExtDer = seq.data.getSequence(3);
            for (int i = 0; i < responseExtDer.length; ++i) {
                Extension responseExtension = new Extension(responseExtDer[i]);
                if (DEBUG != null) {
                    DEBUG.println("OCSP extension: " + responseExtension);
                }
                if (responseExtension.getExtensionId().equals(OCSP_NONCE_EXTENSION_OID) || !responseExtension.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + responseExtension.getExtensionId());
            }
        }
        AlgorithmId sigAlgId = AlgorithmId.parse(seqTmp[1]);
        AlgorithmChecker.check(sigAlgId);
        byte[] signature = seqTmp[2].getBitString();
        X509CertImpl[] x509Certs = null;
        if (seqTmp.length > 3) {
            DerValue seqCert = seqTmp[3];
            if (!seqCert.isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] certs = seqCert.getData().getSequence(3);
            x509Certs = new X509CertImpl[certs.length];
            try {
                for (int i = 0; i < certs.length; ++i) {
                    x509Certs[i] = new X509CertImpl(certs[i].toByteArray());
                }
            }
            catch (CertificateException ce) {
                throw new IOException("Bad encoding in X509 Certificate", ce);
            }
        }
        if (x509Certs != null && x509Certs[0] != null && !(cert = x509Certs[0]).equals(responderCert) && cert.getIssuerX500Principal().equals(responderCert.getSubjectX500Principal())) {
            AlgorithmChecker.check((Certificate)cert);
            try {
                List<String> keyPurposes = cert.getExtendedKeyUsage();
                if (keyPurposes == null || !keyPurposes.contains(KP_OCSP_SIGNING_OID)) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                }
            }
            catch (CertificateParsingException cpe) {
                throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", cpe);
            }
            try {
                cert.verify(responderCert.getPublicKey());
                responderCert = cert;
            }
            catch (GeneralSecurityException e) {
                responderCert = null;
            }
        }
        if (responderCert != null) {
            if (!this.verifyResponse(responseDataDer, responderCert, sigAlgId, signature)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Responder's signature");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] responseData, X509Certificate cert, AlgorithmId sigAlgId, byte[] signBytes) throws CertPathValidatorException {
        try {
            Signature respSignature = Signature.getInstance(sigAlgId.getName());
            respSignature.initVerify(cert);
            respSignature.update(responseData);
            if (respSignature.verify(signBytes)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException ike) {
            throw new CertPathValidatorException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertPathValidatorException(nsae);
        }
        catch (SignatureException se) {
            throw new CertPathValidatorException(se);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private static OCSP.RevocationStatus.Reason[] values = OCSP.RevocationStatus.Reason.values();
        private final OCSP.RevocationStatus.Reason revocationReason;

        private SingleResponse(DerValue der) throws IOException {
            if (der.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream tmp = der.data;
            this.certId = new CertId(tmp.getDerValue().data);
            DerValue derVal = tmp.getDerValue();
            short tag = (byte)(derVal.tag & 0x1F);
            if (tag == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derVal.data.getGeneralizedTime();
                if (derVal.data.available() != 0) {
                    int reason;
                    DerValue dv = derVal.data.getDerValue();
                    tag = (byte)(dv.tag & 0x1F);
                    this.revocationReason = tag == 0 ? ((reason = dv.data.getEnumerated()) >= 0 && reason < values.length ? values[reason] : OCSP.RevocationStatus.Reason.UNSPECIFIED) : OCSP.RevocationStatus.Reason.UNSPECIFIED;
                } else {
                    this.revocationReason = OCSP.RevocationStatus.Reason.UNSPECIFIED;
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = OCSP.RevocationStatus.Reason.UNSPECIFIED;
                if (tag == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (tag == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = tmp.getGeneralizedTime();
            if (tmp.available() == 0) {
                this.nextUpdate = null;
            } else {
                derVal = tmp.getDerValue();
                tag = (byte)(derVal.tag & 0x1F);
                this.nextUpdate = tag == 0 ? derVal.data.getGeneralizedTime() : null;
            }
            if (tmp.available() > 0 && (derVal = tmp.getDerValue()).isContextSpecific((byte)1)) {
                DerValue[] singleExtDer = derVal.data.getSequence(3);
                for (int i = 0; i < singleExtDer.length; ++i) {
                    Extension ext = new Extension(singleExtDer[i]);
                    if (DEBUG != null) {
                        DEBUG.println("OCSP single extension: " + ext);
                    }
                    if (!ext.isCritical()) continue;
                    throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
                }
            }
            long now = System.currentTimeMillis();
            Date nowPlusSkew = new Date(now + 900000L);
            Date nowMinusSkew = new Date(now - 900000L);
            if (DEBUG != null) {
                String until = "";
                if (this.nextUpdate != null) {
                    until = " until " + this.nextUpdate;
                }
                DEBUG.println("Response's validity interval is from " + this.thisUpdate + until);
            }
            if (this.thisUpdate != null && nowPlusSkew.before(this.thisUpdate) || this.nextUpdate != null && nowMinusSkew.after(this.nextUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        public OCSP.RevocationStatus.Reason getRevocationReason() {
            return this.revocationReason;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SingleResponse:  \n");
            sb.append(this.certId);
            sb.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                sb.append("revocationTime is " + this.revocationTime + "\n");
                sb.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            sb.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                sb.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

