/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.util.DerValue;

class InitSecContextToken
extends InitialToken {
    private KrbApReq apReq = null;

    InitSecContextToken(Krb5Context context, Credentials tgt, Credentials serviceTicket) throws KrbException, IOException, GSSException {
        boolean mutualRequired = context.getMutualAuthState();
        boolean useSubkey = true;
        boolean useSequenceNumber = true;
        InitialToken.OverloadedChecksum gssChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, context, tgt, serviceTicket);
        Checksum checksum = gssChecksum.getChecksum();
        this.apReq = new KrbApReq(serviceTicket, mutualRequired, useSubkey, useSequenceNumber, checksum);
        context.resetMySequenceNumber(this.apReq.getSeqNumber());
        EncryptionKey subKey = this.apReq.getSubKey();
        if (subKey != null) {
            context.setKey(subKey);
        } else {
            context.setKey(serviceTicket.getSessionKey());
        }
        if (!mutualRequired) {
            context.resetPeerSequenceNumber(0);
        }
    }

    InitSecContextToken(Krb5Context context, EncryptionKey[] keys, InputStream is) throws IOException, GSSException, KrbException {
        Integer apReqSeqNumber;
        int tokenId = is.read() << 8 | is.read();
        if (tokenId != 256) {
            throw new GSSException(10, -1, "AP_REQ token id does not match!");
        }
        byte[] apReqBytes = new DerValue(is).toByteArray();
        InetAddress addr = null;
        if (context.getChannelBinding() != null) {
            addr = context.getChannelBinding().getInitiatorAddress();
        }
        this.apReq = new KrbApReq(apReqBytes, keys, addr);
        EncryptionKey sessionKey = this.apReq.getCreds().getSessionKey();
        EncryptionKey subKey = this.apReq.getSubKey();
        if (subKey != null) {
            context.setKey(subKey);
        } else {
            context.setKey(sessionKey);
        }
        InitialToken.OverloadedChecksum gssChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, context, this.apReq.getChecksum(), sessionKey);
        gssChecksum.setContextFlags(context);
        Credentials delegCred = gssChecksum.getDelegatedCreds();
        if (delegCred != null) {
            Krb5InitCredential credElement = Krb5InitCredential.getInstance((Krb5NameElement)context.getSrcName(), delegCred);
            context.setDelegCred(credElement);
        }
        int peerSeqNumber = (apReqSeqNumber = this.apReq.getSeqNumber()) != null ? apReqSeqNumber : 0;
        context.resetPeerSequenceNumber(peerSeqNumber);
        if (!context.getMutualAuthState()) {
            context.resetMySequenceNumber(peerSeqNumber);
        }
    }

    public final KrbApReq getKrbApReq() {
        return this.apReq;
    }

    public final byte[] encode() throws IOException {
        byte[] apReqBytes = this.apReq.getMessage();
        byte[] retVal = new byte[2 + apReqBytes.length];
        InitSecContextToken.writeInt(256, retVal, 0);
        System.arraycopy(apReqBytes, 0, retVal, 2, apReqBytes.length);
        return retVal;
    }
}

