/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPTransport
extends Transport {
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"))));
    private static final int maxConnectionThreads = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.maxConnectionThreads", Integer.MAX_VALUE));
    private static final long threadKeepAliveTime = AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.tcp.threadKeepAliveTime", 60000L));
    private static final ExecutorService connectionThreadPool = new ThreadPoolExecutor(0, maxConnectionThreads, threadKeepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return AccessController.doPrivileged(new NewThreadAction(runnable, "TCP Connection(idle)", true, true));
        }
    });
    private static final AtomicInteger connectionCount = new AtomicInteger(0);
    private static final ThreadLocal<ConnectionHandler> threadConnectionHandler = new ThreadLocal();
    private final LinkedList<TCPEndpoint> epList;
    private int exportCount = 0;
    private ServerSocket server = null;
    private final Map<TCPEndpoint, Reference<TCPChannel>> channelTable = new WeakHashMap<TCPEndpoint, Reference<TCPChannel>>();
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));

    TCPTransport(LinkedList<TCPEndpoint> epList) {
        this.epList = epList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        ArrayList<TCPChannel> channels;
        Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
        synchronized (map) {
            channels = new ArrayList<TCPChannel>(this.channelTable.values().size());
            for (Reference<TCPChannel> ref : this.channelTable.values()) {
                TCPChannel ch = ref.get();
                if (ch == null) continue;
                channels.add(ch);
            }
        }
        for (TCPChannel channel : channels) {
            channel.shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCPChannel getChannel(Endpoint ep) {
        TCPChannel ch = null;
        if (ep instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                Reference<TCPChannel> ref = this.channelTable.get(ep);
                if (ref != null) {
                    ch = ref.get();
                }
                if (ch == null) {
                    TCPEndpoint tcpEndpoint = (TCPEndpoint)ep;
                    ch = new TCPChannel(this, tcpEndpoint);
                    this.channelTable.put(tcpEndpoint, new WeakReference<TCPChannel>(ch));
                }
            }
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Endpoint ep) {
        if (ep instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                TCPChannel channel;
                Reference<TCPChannel> ref = this.channelTable.remove(ep);
                if (ref != null && (channel = ref.get()) != null) {
                    channel.shedCache();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportObject(Target target) throws RemoteException {
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            this.listen();
            ++this.exportCount;
        }
        boolean ok = false;
        try {
            super.exportObject(target);
            ok = true;
        }
        finally {
            if (!ok) {
                TCPTransport tCPTransport2 = this;
                synchronized (tCPTransport2) {
                    this.decrementExportCount();
                }
            }
        }
    }

    @Override
    protected synchronized void targetUnexported() {
        this.decrementExportCount();
    }

    private void decrementExportCount() {
        assert (Thread.holdsLock(this));
        --this.exportCount;
        if (this.exportCount == 0 && this.getEndpoint().getListenPort() != 0) {
            ServerSocket ss = this.server;
            this.server = null;
            try {
                ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void checkAcceptPermission(AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ConnectionHandler h = threadConnectionHandler.get();
        if (h == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        h.checkAcceptPermission(sm, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList<TCPEndpoint> linkedList = this.epList;
        synchronized (linkedList) {
            return this.epList.getLast();
        }
    }

    private void listen() throws RemoteException {
        assert (Thread.holdsLock(this));
        TCPEndpoint ep = this.getEndpoint();
        int port = ep.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + port + ") create server socket");
            }
            try {
                this.server = ep.newServerSocket();
                Thread t = AccessController.doPrivileged(new NewThreadAction(new AcceptLoop(this.server), "TCP Accept-" + port, true));
                t.start();
            }
            catch (BindException e) {
                throw new ExportException("Port already in use: " + port, e);
            }
            catch (IOException e) {
                throw new ExportException("Listen failed on port: " + port, e);
            }
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(port);
            }
        }
    }

    private static void closeSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection conn, boolean persistent) {
        int port = this.getEndpoint().getPort();
        try {
            DataInputStream in = new DataInputStream(conn.getInputStream());
            block19: do {
                int op;
                if ((op = in.read()) == -1) {
                    if (tcpLog.isLoggable(Log.BRIEF)) {
                        tcpLog.log(Log.BRIEF, "(port " + port + ") connection closed");
                    }
                    break;
                }
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "(port " + port + ") op = " + op);
                }
                switch (op) {
                    case 80: {
                        StreamRemoteCall call = new StreamRemoteCall(conn);
                        if (this.serviceCall(call)) continue block19;
                        return;
                    }
                    case 82: {
                        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                        out.writeByte(83);
                        conn.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(in));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + op);
                    }
                }
            } while (persistent);
        }
        catch (IOException e) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + port + ") exception: ", e);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (IOException ex) {}
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler h = threadConnectionHandler.get();
        if (h != null) {
            return h.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private Map<AccessControlContext, Reference<AccessControlContext>> authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;

        ConnectionHandler(Socket socket, String remoteHost) {
            this.socket = socket;
            this.remoteHost = remoteHost;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager sm, AccessControlContext acc) {
            if (sm != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap<AccessControlContext, Reference<AccessControlContext>>();
                this.cacheSecurityManager = sm;
            }
            if (acc.equals(this.okContext) || this.authCache.containsKey(acc)) {
                return;
            }
            InetAddress addr = this.socket.getInetAddress();
            String host = addr != null ? addr.getHostAddress() : "*";
            sm.checkAccept(host, this.socket.getPort());
            this.authCache.put(acc, new SoftReference<AccessControlContext>(acc));
            this.okContext = acc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread t = Thread.currentThread();
            String name = t.getName();
            try {
                t.setName("RMI TCP Connection(" + connectionCount.incrementAndGet() + ")-" + this.remoteHost);
                this.run0();
            }
            finally {
                t.setName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void run0() {
            TCPEndpoint endpoint = TCPTransport.this.getEndpoint();
            int port = endpoint.getPort();
            threadConnectionHandler.set(this);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (connectionReadTimeout > 0) {
                    this.socket.setSoTimeout(connectionReadTimeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                InputStream sockIn = this.socket.getInputStream();
                InputStream bufIn = sockIn.markSupported() ? sockIn : new BufferedInputStream(sockIn);
                bufIn.mark(4);
                DataInputStream in = new DataInputStream(bufIn);
                int magic = in.readInt();
                if (magic == 1347375956) {
                    tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                    bufIn.reset();
                    try {
                        this.socket = new HttpReceiveSocket(this.socket, bufIn, null);
                        this.remoteHost = "0.0.0.0";
                        sockIn = this.socket.getInputStream();
                        bufIn = new BufferedInputStream(sockIn);
                        in = new DataInputStream(bufIn);
                        magic = in.readInt();
                    }
                    catch (IOException e) {
                        throw new RemoteException("Error HTTP-unwrapping call", e);
                    }
                }
                short version = in.readShort();
                if (magic != 1246907721 || version != 2) {
                    TCPTransport.closeSocket(this.socket);
                    return;
                }
                OutputStream sockOut = this.socket.getOutputStream();
                BufferedOutputStream bufOut = new BufferedOutputStream(sockOut);
                DataOutputStream out = new DataOutputStream(bufOut);
                int remotePort = this.socket.getPort();
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + remotePort + "]");
                }
                byte protocol = in.readByte();
                switch (protocol) {
                    case 76: {
                        TCPEndpoint ep = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), endpoint.getClientSocketFactory(), endpoint.getServerSocketFactory());
                        TCPChannel ch = new TCPChannel(TCPTransport.this, ep);
                        TCPConnection conn = new TCPConnection(ch, this.socket, bufIn, bufOut);
                        TCPTransport.this.handleMessages(conn, false);
                        return;
                    }
                    case 75: {
                        out.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + port + ") " + "suggesting " + this.remoteHost + ":" + remotePort);
                        }
                        out.writeUTF(this.remoteHost);
                        out.writeInt(remotePort);
                        out.flush();
                        String clientHost = in.readUTF();
                        int clientPort = in.readInt();
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + port + ") client using " + clientHost + ":" + clientPort);
                        }
                        TCPEndpoint ep = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), endpoint.getClientSocketFactory(), endpoint.getServerSocketFactory());
                        TCPChannel ch = new TCPChannel(TCPTransport.this, ep);
                        TCPConnection conn = new TCPConnection(ch, this.socket, bufIn, bufOut);
                        TCPTransport.this.handleMessages(conn, true);
                        return;
                    }
                    case 77: {
                        ConnectionMultiplexer multiplexer;
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + port + ") accepting multiplex protocol");
                        }
                        out.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + port + ") suggesting " + this.remoteHost + ":" + remotePort);
                        }
                        out.writeUTF(this.remoteHost);
                        out.writeInt(remotePort);
                        out.flush();
                        TCPEndpoint ep = new TCPEndpoint(in.readUTF(), in.readInt(), endpoint.getClientSocketFactory(), endpoint.getServerSocketFactory());
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + port + ") client using " + ep.getHost() + ":" + ep.getPort());
                        }
                        Map map = TCPTransport.this.channelTable;
                        synchronized (map) {
                            TCPChannel ch = TCPTransport.this.getChannel(ep);
                            multiplexer = new ConnectionMultiplexer(ch, bufIn, sockOut, false);
                            ch.useMultiplexer(multiplexer);
                        }
                        multiplexer.run();
                        return;
                    }
                    default: {
                        out.writeByte(79);
                        out.flush();
                        return;
                    }
                }
            }
            catch (IOException e) {
                tcpLog.log(Log.BRIEF, "terminated with exception:", e);
                return;
            }
            finally {
                TCPTransport.closeSocket(this.socket);
            }
        }
    }

    private class AcceptLoop
    implements Runnable {
        private final ServerSocket serverSocket;
        private long lastExceptionTime = 0L;
        private int recentExceptionCount;

        AcceptLoop(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.executeAcceptLoop();
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop() {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "listening on port " + TCPTransport.this.getEndpoint().getPort());
            }
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    InetAddress clientAddr = socket.getInetAddress();
                    String clientHost = clientAddr != null ? clientAddr.getHostAddress() : "0.0.0.0";
                    try {
                        connectionThreadPool.execute(new ConnectionHandler(socket, clientHost));
                    }
                    catch (RejectedExecutionException e) {
                        TCPTransport.closeSocket(socket);
                        tcpLog.log(Log.BRIEF, "rejected connection from " + clientHost);
                    }
                    continue;
                }
                catch (Throwable t) {
                    try {
                        if (this.serverSocket.isClosed()) return;
                        try {
                            if (tcpLog.isLoggable(Level.WARNING)) {
                                tcpLog.log(Level.WARNING, "accept loop for " + this.serverSocket + " throws", t);
                            }
                        }
                        catch (Throwable tt) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (socket != null) {
                            TCPTransport.closeSocket(socket);
                        }
                    }
                    if (!(t instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (!(t instanceof Exception) && !(t instanceof OutOfMemoryError) && !(t instanceof NoClassDefFoundError)) throw (Error)t;
                    if (!this.continueAfterAcceptFailure(t)) return;
                    continue;
                }
                break;
            }
        }

        private boolean continueAfterAcceptFailure(Throwable t) {
            RMIFailureHandler fh = RMISocketFactory.getFailureHandler();
            if (fh != null) {
                return fh.failure(t instanceof Exception ? (Exception)t : new InvocationTargetException(t));
            }
            this.throttleLoopOnException();
            return true;
        }

        private void throttleLoopOnException() {
            long now = System.currentTimeMillis();
            if (this.lastExceptionTime == 0L || now - this.lastExceptionTime > 5000L) {
                this.lastExceptionTime = now;
                this.recentExceptionCount = 0;
            } else if (++this.recentExceptionCount >= 10) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

