/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private SocketOpts.IP.TCP options = null;
    private Socket socket = null;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;

    SocketChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider sp, FileDescriptor fd, InetSocketAddress remote) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = 2;
        this.remoteAddress = remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.writerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read(ByteBuffer buf) throws IOException {
        int n;
        if (buf == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1;
        }
        int n2 = 0;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                int n3 = 0;
                // MONITOREXIT : object2
                Object var8_7 = null;
                this.readerCleanup();
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n2 <= 0 && !this.isInputOpen) {
                    // MONITOREXIT : object3
                    // MONITOREXIT : object
                    return -1;
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.read(this.fd, buf, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object4
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object5
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long read0(ByteBuffer[] bufs) throws IOException {
        long l;
        if (bufs == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1L;
        }
        long n = 0L;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                long l2 = 0L;
                // MONITOREXIT : object2
                Object var10_7 = null;
                this.readerCleanup();
                this.end(n > 0L || n == -2L);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n <= 0L && !this.isInputOpen) {
                    // MONITOREXIT : object3
                    // MONITOREXIT : object
                    return -1L;
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n));
                // MONITOREXIT : object
                return l2;
            }
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n = IOUtil.read(this.fd, bufs, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(n);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.readerCleanup();
            this.end(n > 0L || n == -2L);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object4
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n > 0L || n == -2L);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object5
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return l;
        if (IOStatus.check(n)) return l;
        throw new AssertionError();
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(dsts, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(ByteBuffer buf) throws IOException {
        int n;
        if (buf == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        int n2 = 0;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                int n3 = 0;
                // MONITOREXIT : object2
                Object var8_7 = null;
                this.writerCleanup();
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n2 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.write(this.fd, buf, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long write0(ByteBuffer[] bufs) throws IOException {
        long l;
        if (bufs == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        long n = 0L;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                long l2 = 0L;
                // MONITOREXIT : object2
                Object var10_7 = null;
                this.writerCleanup();
                this.end(n > 0L || n == -2L);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n <= 0L && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n));
                // MONITOREXIT : object
                return l2;
            }
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n = IOUtil.write(this.fd, bufs, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(n);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.writerCleanup();
            this.end(n > 0L || n == -2L);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n > 0L || n == -2L);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return l;
        if (IOStatus.check(n)) return l;
        throw new AssertionError();
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(srcs, offset, length));
    }

    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher d = new SocketOptsImpl.Dispatcher(){

                    int getInt(int opt) throws IOException {
                        return Net.getIntOption(SocketChannelImpl.this.fd, opt);
                    }

                    void setInt(int opt, int arg) throws IOException {
                        Net.setIntOption(SocketChannelImpl.this.fd, opt, arg);
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP(d);
            }
            return this.options;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2 && (this.localAddress == null || ((InetSocketAddress)this.localAddress).getAddress().isAnyLocalAddress())) {
                this.localAddress = Net.localAddress(this.fd);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress local) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress isa = Net.checkAddress(local);
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(SocketAddress sa) throws IOException {
        int trafficClass = 0;
        boolean localPort = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                InetSocketAddress isa = Net.checkAddress(sa);
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
                }
                Object object3 = this.blockingLock();
                synchronized (object3) {
                    Object object4;
                    int n = 0;
                    try {
                        try {
                            InetAddress ia;
                            this.begin();
                            object4 = this.stateLock;
                            synchronized (object4) {
                                if (!this.isOpen()) {
                                    boolean bl = false;
                                    // MONITOREXIT @DISABLED, blocks:[3, 4, 23, 9, 10, 11, 12] lbl22 : MonitorExitStatement: MONITOREXIT : var10_10
                                    Object var14_13 = null;
                                    this.readerCleanup();
                                    this.end(n > 0 || n == -2);
                                    assert (IOStatus.check(n));
                                    return bl;
                                }
                                this.readerThread = NativeThread.current();
                            }
                            do {
                                if (!(ia = isa.getAddress()).isAnyLocalAddress()) continue;
                                ia = InetAddress.getLocalHost();
                            } while ((n = Net.connect(this.fd, ia, isa.getPort(), trafficClass)) == -3 && this.isOpen());
                            Object var14_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_15 = null;
                            this.readerCleanup();
                            this.end(n > 0 || n == -2);
                            assert (IOStatus.check(n));
                            throw throwable;
                        }
                        this.readerCleanup();
                        this.end(n > 0 || n == -2);
                        assert (IOStatus.check(n));
                    }
                    catch (IOException x) {
                        this.close();
                        throw x;
                    }
                    object4 = this.stateLock;
                    synchronized (object4) {
                        this.remoteAddress = isa;
                        if (n > 0) {
                            this.state = 2;
                            return true;
                        }
                        if (!this.isBlocking()) {
                            this.state = 1;
                        } else assert (false);
                        return false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != 1) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            try {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (!this.isOpen()) {
                    boolean bl = false;
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    Object var10_9 = null;
                    Object object6 = this.stateLock;
                    // MONITORENTER : object6
                    this.readerThread = 0L;
                    if (this.state == 3) {
                        this.kill();
                        n = 0;
                    }
                    // MONITOREXIT : object6
                    this.end(n > 0 || n == -2);
                    assert (IOStatus.check(n));
                    // MONITOREXIT : object3
                    // MONITOREXIT : object2
                    return bl;
                }
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object5
                if (!this.isBlocking()) {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object
                Object var10_10 = null;
                Object object7 = this.stateLock;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Object object8 = this.stateLock;
                // MONITORENTER : object8
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object8
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object7
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException x) {
            this.close();
            throw x;
        }
        if (n > 0) {
            object = this.stateLock;
            // MONITORENTER : object
            this.state = 2;
            // MONITOREXIT : object
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isInputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 0);
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isOutputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 1);
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            nd.preClose(this.fd);
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                return;
            }
            if (this.state == -1) {
                this.state = 4;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.readerThread == 0L && this.writerThread == 0L) {
                nd.close(this.fd);
                this.state = 4;
            } else {
                this.state = 3;
            }
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & 0x20) != 0) {
            return false;
        }
        if ((ops & 0x18) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            this.readyToConnect = true;
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & 1) != 0 && (intOps & 1) != 0 && this.state == 2) {
            newOps |= 1;
        }
        if ((ops & 4) != 0 && (intOps & 8) != 0 && (this.state == 0 || this.state == 1)) {
            newOps |= 8;
            this.readyToConnect = true;
        }
        if ((ops & 4) != 0 && (intOps & 4) != 0 && this.state == 2) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & 4) != 0) {
            newOps |= 4;
        }
        if ((ops & 8) != 0) {
            newOps |= 4;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSuperclass().getName());
        sb.append('[');
        if (!this.isOpen()) {
            sb.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        sb.append("unconnected");
                        break;
                    }
                    case 1: {
                        sb.append("connection-pending");
                        break;
                    }
                    case 2: {
                        sb.append("connected");
                        if (!this.isInputOpen) {
                            sb.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        sb.append(" oshut");
                    }
                }
                if (this.localAddress() != null) {
                    sb.append(" local=");
                    sb.append(this.localAddress().toString());
                }
                if (this.remoteAddress() != null) {
                    sb.append(" remote=");
                    sb.append(this.remoteAddress().toString());
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static {
        Util.load();
        nd = new SocketDispatcher();
    }
}

