/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAutoShutdown;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.XSettings;
import sun.awt.motif.MFontPeer;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.GetBooleanAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MToolkit
extends UNIXToolkit
implements Runnable {
    private static final Logger log = Logger.getLogger("sun.awt.motif.MToolkit");
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static final X11GraphicsConfig config = GraphicsEnvironment.isHeadless() ? null : (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final boolean motifdnd;
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";
    private static final long WORKAROUND_SLEEP = 100L;
    public static final int UNDETERMINED_WM = 1;
    public static final int NO_WM = 2;
    public static final int OTHER_WM = 3;
    public static final int OPENLOOK_WM = 4;
    public static final int MOTIF_WM = 5;
    public static final int CDE_WM = 6;
    public static final int ENLIGHTEN_WM = 7;
    public static final int KDE2_WM = 8;
    public static final int SAWFISH_WM = 9;
    public static final int ICE_WM = 10;
    public static final int METACITY_WM = 11;
    public static final int COMPIZ_WM = 12;
    public static final int LG3D_WM = 13;

    public MToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("MToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String mainClassName = null;
            StackTraceElement[] trace = new Throwable().getStackTrace();
            int bottom = trace.length - 1;
            if (bottom >= 0) {
                mainClassName = trace[bottom].getClassName();
            }
            if (mainClassName == null || mainClassName.equals("")) {
                mainClassName = "AWT";
            }
            this.init(mainClassName);
            Thread toolkitThread = new Thread(this, "AWT-Motif");
            toolkitThread.setPriority(6);
            toolkitThread.setDaemon(true);
            ThreadGroup mainTG = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup currentTG = Thread.currentThread().getThreadGroup();
                    ThreadGroup parentTG = currentTG.getParent();
                    while (parentTG != null) {
                        currentTG = parentTG;
                        parentTG = currentTG.getParent();
                    }
                    return currentTG;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(mainTG, new Runnable(){

                public void run() {
                    MToolkit.this.shutdown();
                }
            }, "Shutdown-Thread"));
            AWTAutoShutdown.notifyToolkitThreadBusy();
            toolkitThread.start();
        }
    }

    public native void init(String var1);

    @Override
    public native void run();

    private native void shutdown();

    @Override
    public ButtonPeer createButton(Button target) {
        return null;
    }

    @Override
    public TextFieldPeer createTextField(TextField target) {
        return null;
    }

    @Override
    public LabelPeer createLabel(Label target) {
        return null;
    }

    @Override
    public ListPeer createList(List target) {
        return null;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) {
        return null;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) {
        return null;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        return null;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) {
        return null;
    }

    @Override
    public ChoicePeer createChoice(Choice target) {
        return null;
    }

    @Override
    public FramePeer createFrame(Frame target) {
        return null;
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        return null;
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        return null;
    }

    @Override
    public WindowPeer createWindow(Window target) {
        return null;
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        return null;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog target) {
        return null;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        return null;
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        return null;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        return null;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        return null;
    }

    @Override
    public FontPeer getFontPeer(String name, int style) {
        return new MFontPeer(name, style);
    }

    @Override
    public void setDynamicLayout(boolean b) {
        dynamicLayoutSetting = b;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupportedNative();
    }

    @Override
    public native boolean isFrameStateSupported(int var1);

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon target) throws HeadlessException {
        return null;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray target) throws HeadlessException {
        return null;
    }

    @Override
    public boolean isTraySupported() {
        return false;
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    @Override
    public native int getScreenResolution();

    @Override
    public Insets getScreenInsets(GraphicsConfiguration gc) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected native int getScreenWidth();

    @Override
    protected native int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return super.getFontMetrics(font);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String doctitle, Properties props) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob = new PrintJob2D(frame, doctitle, props);
        if (!printJob.printDialog()) {
            printJob = null;
        }
        return printJob;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String doctitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob = new PrintJob2D(frame, doctitle, jobAttributes, pageAttributes);
        if (!printJob.printDialog()) {
            printJob = null;
        }
        return printJob;
    }

    @Override
    public native void beep();

    @Override
    public Clipboard getSystemClipboard() {
        return null;
    }

    @Override
    public Clipboard getSystemSelection() {
        return null;
    }

    @Override
    public boolean getLockingKeyState(int key) {
        if (key != 20 && key != 144 && key != 145 && key != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(key);
    }

    public native boolean getLockingKeyStateNative(int var1);

    @Override
    public native void loadSystemColors(int[] var1);

    public static Container getNativeContainer(Component c) {
        return Toolkit.getNativeContainer(c);
    }

    protected static final Object targetToPeer(Object target) {
        return SunToolkit.targetToPeer(target);
    }

    protected static final void targetDisposedPeer(Object target, Object peer) {
        SunToolkit.targetDisposedPeer(target, peer);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        return null;
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        return null;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return null;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        return null;
    }

    @Override
    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException {
        return null;
    }

    @Override
    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        return null;
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String name) {
        if (name.startsWith(prefix)) {
            String cursorName = name.substring(prefix.length(), name.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(cursorName);
            }
            catch (AWTException awte) {
                System.err.println("cannot load system cursor: " + cursorName);
                return null;
            }
        }
        if (name.equals("awt.dynamicLayoutSupported")) {
            return this.lazilyLoadDynamicLayoutSupportedProperty(name);
        }
        if (!this.loadedXSettings && (name.startsWith("gnome.") || name.equals("awt.font.desktophints") || name.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
                return this.desktopProperties.get(name);
            }
        }
        return super.lazilyLoadDesktopProperty(name);
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String name) {
        boolean nativeDynamic = this.isDynamicLayoutSupportedNative();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "nativeDynamic == " + nativeDynamic);
        }
        return nativeDynamic;
    }

    private native int getMulticlickTime();

    private native int getNumMouseButtons();

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 50);
        this.desktopProperties.put("DnD.Autoscroll.interval", 50);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", 5);
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", this.getMulticlickTime());
            this.desktopProperties.put("awt.mouse.numButtons", this.getNumMouseButtons());
        }
    }

    @Override
    public RobotPeer createRobot(Robot target, GraphicsDevice screen) {
        return null;
    }

    static boolean useMotifDnD() {
        return motifdnd;
    }

    private native void loadXSettings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXSettings(int screen_XXX_ignored, byte[] data) {
        Map updatedSettings;
        if (this.xs == null) {
            this.xs = new XSettings();
        }
        if ((updatedSettings = this.xs.update(data)) == null || updatedSettings.isEmpty()) {
            return;
        }
        for (Map.Entry e : updatedSettings.entrySet()) {
            String name = (String)e.getKey();
            name = "gnome." + name;
            this.setDesktopProperty(name, e.getValue());
        }
        this.setDesktopProperty("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        Integer dragThreshold = null;
        MToolkit mToolkit = this;
        synchronized (mToolkit) {
            dragThreshold = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (dragThreshold != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", dragThreshold);
        }
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.APPLICATION_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType exclusionType) {
        return exclusionType == Dialog.ModalExclusionType.NO_EXCLUDE;
    }

    private native boolean isSyncUpdated();

    private native boolean isSyncFailed();

    private native int getEventNumber();

    private native void updateSyncSelection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean syncNativeQueue(long timeout) {
        MToolkit.awtLock();
        try {
            long event_number = this.getEventNumber();
            this.updateSyncSelection();
            long start = System.currentTimeMillis();
            while (!this.isSyncUpdated() && !this.isSyncFailed()) {
                try {
                    MToolkit.awtLockWait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (System.currentTimeMillis() - start <= timeout || timeout < 0L) continue;
                throw new SunToolkit.OperationTimedOut();
            }
            if (this.isSyncFailed() && (long)this.getEventNumber() - event_number == 1L) {
                MToolkit.awtUnlock();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                finally {
                    MToolkit.awtLock();
                }
            }
            boolean bl = (long)this.getEventNumber() - event_number > 2L;
            return bl;
        }
        finally {
            MToolkit.awtUnlock();
        }
    }

    @Override
    public void grab(Window w) {
        WindowPeer peer = (WindowPeer)w.getPeer();
        if (peer != null) {
            this.nativeGrab(peer);
        }
    }

    @Override
    public void ungrab(Window w) {
        WindowPeer peer = (WindowPeer)w.getPeer();
        if (peer != null) {
            this.nativeUnGrab(peer);
        }
    }

    private native void nativeGrab(WindowPeer var1);

    private native void nativeUnGrab(WindowPeer var1);

    @Override
    public boolean isDesktopSupported() {
        return false;
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop target) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    public static int getWMID() {
        String wmName = MToolkit.getWMName();
        if ("NO_WM".equals(wmName)) {
            return 2;
        }
        if ("OTHER_WM".equals(wmName)) {
            return 3;
        }
        if ("ENLIGHTEN_WM".equals(wmName)) {
            return 7;
        }
        if ("KDE2_WM".equals(wmName)) {
            return 8;
        }
        if ("SAWFISH_WM".equals(wmName)) {
            return 9;
        }
        if ("ICE_WM".equals(wmName)) {
            return 10;
        }
        if ("METACITY_WM".equals(wmName)) {
            return 11;
        }
        if ("OPENLOOK_WM".equals(wmName)) {
            return 4;
        }
        if ("MOTIF_WM".equals(wmName)) {
            return 5;
        }
        if ("CDE_WM".equals(wmName)) {
            return 6;
        }
        if ("COMPIZ_WM".equals(wmName)) {
            return 12;
        }
        if ("LG3D_WM".equals(wmName)) {
            return 13;
        }
        return 1;
    }

    private static native String getWMName();

    static {
        X11GraphicsEnvironment.setNativeFontPath();
        motifdnd = AccessController.doPrivileged(new GetBooleanAction("awt.dnd.motifdnd"));
    }
}

