/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.ParagraphView;

class LineView
extends ParagraphView {
    int tabBase;

    public LineView(Element elem) {
        super(elem);
    }

    public boolean isVisible() {
        return true;
    }

    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    public int getResizeWeight(int axis) {
        switch (axis) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public float getAlignment(int axis) {
        if (axis == 0) {
            return 0.0f;
        }
        return super.getAlignment(axis);
    }

    protected void layout(int width, int height) {
        super.layout(0x7FFFFFFE, height);
    }

    public float nextTabStop(float x, int tabOffset) {
        if (this.getTabSet() == null && StyleConstants.getAlignment(this.getAttributes()) == 0) {
            return this.getPreTab(x, tabOffset);
        }
        return super.nextTabStop(x, tabOffset);
    }

    protected float getPreTab(float x, int tabOffset) {
        Document d = this.getDocument();
        View v = this.getViewAtPosition(tabOffset, null);
        if (d instanceof StyledDocument && v != null) {
            Font f = ((StyledDocument)d).getFont(v.getAttributes());
            Container c = this.getContainer();
            FontMetrics fm = c != null ? c.getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
            int width = this.getCharactersPerTab() * fm.charWidth('W');
            int tb = (int)this.getTabBase();
            return (((int)x - tb) / width + 1) * width + tb;
        }
        return 10.0f + x;
    }

    protected int getCharactersPerTab() {
        return 8;
    }
}

