/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import sun.font.FontManagerNativeLibrary;
import sun.text.CodePointIterator;

public final class Bidi {
    byte dir;
    byte baselevel;
    int length;
    int[] runs;
    int[] cws;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private static final int DIR_MIXED = 2;
    private static final char NUMLEVELS = '>';
    private static final int RMASK = 57378;

    public Bidi(String paragraph, int flags) {
        if (paragraph == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        Bidi.nativeBidiChars(this, paragraph.toCharArray(), 0, null, 0, paragraph.length(), flags);
    }

    public Bidi(AttributedCharacterIterator paragraph) {
        int newpos;
        if (paragraph == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        int flags = -2;
        byte[] embeddings = null;
        int start = paragraph.getBeginIndex();
        int limit = paragraph.getEndIndex();
        int length = limit - start;
        int n = 0;
        char[] text = new char[length];
        char c = paragraph.first();
        while (true) {
            if (c == '\uffff') break;
            text[n++] = c;
            c = paragraph.next();
        }
        paragraph.first();
        try {
            Boolean runDirection = (Boolean)paragraph.getAttribute(TextAttribute.RUN_DIRECTION);
            if (runDirection != null) {
                flags = TextAttribute.RUN_DIRECTION_LTR.equals(runDirection) ? 0 : 1;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            NumericShaper shaper = (NumericShaper)paragraph.getAttribute(TextAttribute.NUMERIC_SHAPING);
            if (shaper != null) {
                shaper.shape(text, 0, text.length);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        int pos = start;
        do {
            paragraph.setIndex(pos);
            Object embeddingLevel = paragraph.getAttribute(TextAttribute.BIDI_EMBEDDING);
            newpos = paragraph.getRunLimit(TextAttribute.BIDI_EMBEDDING);
            if (embeddingLevel == null) continue;
            try {
                int intLevel = (Integer)embeddingLevel;
                if (intLevel < -61 || intLevel >= 61) continue;
                byte level = (byte)(intLevel < 0 ? -intLevel | 0x80 : intLevel);
                if (embeddings == null) {
                    embeddings = new byte[length];
                }
                for (int i = pos - start; i < newpos - start; ++i) {
                    embeddings[i] = level;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        } while ((pos = newpos) < limit);
        Bidi.nativeBidiChars(this, text, 0, embeddings, 0, text.length, flags);
    }

    public Bidi(char[] text, int textStart, byte[] embeddings, int embStart, int paragraphLength, int flags) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (paragraphLength < 0) {
            throw new IllegalArgumentException("bad length: " + paragraphLength);
        }
        if (textStart < 0 || paragraphLength > text.length - textStart) {
            throw new IllegalArgumentException("bad range: " + textStart + " length: " + paragraphLength + " for text of length: " + text.length);
        }
        if (embeddings != null && (embStart < 0 || paragraphLength > embeddings.length - embStart)) {
            throw new IllegalArgumentException("bad range: " + embStart + " length: " + paragraphLength + " for embeddings of length: " + text.length);
        }
        if (embeddings != null) {
            int embLimit = embStart + paragraphLength;
            for (int i = embStart; i < embLimit; ++i) {
                if (embeddings[i] >= 0) continue;
                byte[] temp = new byte[paragraphLength];
                System.arraycopy(embeddings, embStart, temp, 0, paragraphLength);
                i -= embStart;
                while (i < paragraphLength) {
                    if (temp[i] < 0) {
                        temp[i] = (byte)(-temp[i] | 0x80);
                    }
                    ++i;
                }
                embeddings = temp;
                embStart = 0;
                break;
            }
        }
        Bidi.nativeBidiChars(this, text, textStart, embeddings, embStart, paragraphLength, flags);
    }

    private Bidi(int dir, int baseLevel, int length, int[] data, int[] cws) {
        this.reset(dir, baseLevel, length, data, cws);
    }

    private void reset(int dir, int baselevel, int length, int[] data, int[] cws) {
        this.dir = (byte)dir;
        this.baselevel = (byte)baselevel;
        this.length = length;
        this.runs = data;
        this.cws = cws;
    }

    public Bidi createLineBidi(int lineStart, int lineLimit) {
        if (lineStart == 0 && lineLimit == this.length) {
            return this;
        }
        int lineLength = lineLimit - lineStart;
        if (lineStart < 0 || lineLimit < lineStart || lineLimit > this.length) {
            throw new IllegalArgumentException("range " + lineStart + " to " + lineLimit + " is invalid for paragraph of length " + this.length);
        }
        if (this.runs == null) {
            return new Bidi(this.dir, this.baselevel, lineLength, null, null);
        }
        int cwspos = -1;
        int[] ncws = null;
        if (this.cws != null) {
            int cwsl = this.cws.length;
            for (int cwss = 0; cwss < cwsl; ++cwss) {
                if (this.cws[cwss] < lineStart) continue;
                for (cwsl = cwss; cwsl < this.cws.length && this.cws[cwsl] < lineLimit; ++cwsl) {
                }
                int ll = lineLimit - 1;
                while (cwsl > cwss && this.cws[cwsl - 1] == ll) {
                    cwspos = ll--;
                    --cwsl;
                }
                if (cwspos == lineStart) {
                    return new Bidi(this.dir, this.baselevel, lineLength, null, null);
                }
                int ncwslen = cwsl - cwss;
                if (ncwslen <= 0) break;
                ncws = new int[ncwslen];
                for (int i = 0; i < ncwslen; ++i) {
                    ncws[i] = this.cws[cwss + i] - lineStart;
                }
                break;
            }
        }
        int[] nruns = null;
        byte nlevel = this.baselevel;
        int limit = cwspos == -1 ? lineLimit : cwspos;
        int rl = this.runs.length;
        byte ndir = this.dir;
        for (int rs = 0; rs < this.runs.length; rs += 2) {
            if (this.runs[rs] <= lineStart) continue;
            for (rl = rs; rl < this.runs.length && this.runs[rl] < limit; rl += 2) {
            }
            if (rl > rs || this.runs[rs + 1] != this.baselevel) {
                if (cwspos != -1 && (rl += 2) > rs && this.runs[rl - 1] != this.baselevel) {
                    nruns = new int[rl - rs + 2];
                    nruns[rl - rs] = lineLength;
                    nruns[rl - rs + 1] = this.baselevel;
                } else {
                    limit = lineLimit;
                    nruns = new int[rl - rs];
                }
                int n = 0;
                for (int i = rs; i < rl; i += 2) {
                    nruns[n++] = this.runs[i] - lineStart;
                    nruns[n++] = this.runs[i + 1];
                }
                nruns[n - 2] = limit - lineStart;
                break;
            }
            ndir = (this.runs[rs + 1] & 1) == 0 ? (byte)0 : 1;
            break;
        }
        return new Bidi(ndir, this.baselevel, lineLength, nruns, ncws);
    }

    public boolean isMixed() {
        return this.dir == 2;
    }

    public boolean isLeftToRight() {
        return this.dir == 0;
    }

    public boolean isRightToLeft() {
        return this.dir == 1;
    }

    public int getLength() {
        return this.length;
    }

    public boolean baseIsLeftToRight() {
        return (this.baselevel & 1) == 0;
    }

    public int getBaseLevel() {
        return this.baselevel;
    }

    public int getLevelAt(int offset) {
        if (this.runs == null || offset < 0 || offset >= this.length) {
            return this.baselevel;
        }
        int i = 0;
        while (offset >= this.runs[i]) {
            i += 2;
        }
        return this.runs[i + 1];
    }

    public int getRunCount() {
        return this.runs == null ? 1 : this.runs.length / 2;
    }

    public int getRunLevel(int run) {
        return this.runs == null ? this.baselevel : this.runs[run * 2 + 1];
    }

    public int getRunStart(int run) {
        return this.runs == null || run == 0 ? 0 : this.runs[run * 2 - 2];
    }

    public int getRunLimit(int run) {
        return this.runs == null ? this.length : this.runs[run * 2];
    }

    public static boolean requiresBidi(char[] text, int start, int limit) {
        CodePointIterator cpi = CodePointIterator.create(text, start, limit);
        int cp = cpi.next();
        while (cp != -1) {
            int dc;
            if (cp > 1424 && (0xE022 & 1 << (dc = Bidi.nativeGetDirectionCode(cp))) != 0) {
                return true;
            }
            cp = cpi.next();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] levels, int levelStart, Object[] objects, int objectStart, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count " + count + " must be >= 0");
        }
        if (levelStart < 0 || levelStart + count > levels.length) {
            throw new IllegalArgumentException("levelStart " + levelStart + " and count " + count + " out of range [0, " + levels.length + "]");
        }
        if (objectStart < 0 || objectStart + count > objects.length) {
            throw new IllegalArgumentException("objectStart " + objectStart + " and count " + count + " out of range [0, " + objects.length + "]");
        }
        lowestOddLevel = 63;
        highestLevel = 0;
        levelLimit = levelStart + count;
        for (i = levelStart; i < levelLimit; ++i) {
            level = levels[i];
            if (level > highestLevel) {
                highestLevel = level;
            }
            if ((level & 1) == 0 || level >= lowestOddLevel) continue;
            lowestOddLevel = level;
        }
        delta = objectStart - levelStart;
        while (highestLevel >= lowestOddLevel) {
            i = levelStart;
            block2: while (true) {
                if (i < levelLimit && levels[i] < highestLevel) {
                    ++i;
                    continue;
                }
                if ((begin = i++) == levelLimit) break;
                while (i < levelLimit && levels[i] >= highestLevel) {
                    ++i;
                }
                end = i - 1;
                begin += delta;
                end += delta;
                while (true) {
                    if (begin < end) ** break;
                    continue block2;
                    temp = objects[begin];
                    objects[begin] = objects[end];
                    objects[end] = temp;
                    ++begin;
                    --end;
                }
                break;
            }
            highestLevel = (byte)(highestLevel - 1);
        }
    }

    private static native int nativeGetDirectionCode(int var0);

    private static synchronized native void nativeBidiChars(Bidi var0, char[] var1, int var2, byte[] var3, int var4, int var5, int var6);

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("[dir: " + this.dir);
        buf.append(" baselevel: " + this.baselevel);
        buf.append(" length: " + this.length);
        if (this.runs == null) {
            buf.append(" runs: null");
        } else {
            buf.append(" runs: [");
            for (i = 0; i < this.runs.length; i += 2) {
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(this.runs[i]);
                buf.append('/');
                buf.append(this.runs[i + 1]);
            }
            buf.append(']');
        }
        if (this.cws == null) {
            buf.append(" cws: null");
        } else {
            buf.append(" cws: [");
            for (i = 0; i < this.cws.length; ++i) {
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(Integer.toHexString(this.cws[i]));
            }
            buf.append(']');
        }
        buf.append(']');
        return buf.toString();
    }

    static {
        FontManagerNativeLibrary.load();
    }
}

