/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRS;
import java.nio.FloatBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferS
extends FloatBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.viewedBuffer = db;
    }

    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 2;
        assert (off >= 0);
        return new DirectFloatBufferS(this, -1, 0, rem, rem, off);
    }

    public FloatBuffer duplicate() {
        return new DirectFloatBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)(i << 2);
    }

    public float get() {
        return Float.intBitsToFloat(Bits.swap(unsafe.getInt(this.ix(this.nextGetIndex()))));
    }

    public float get(int i) {
        return Float.intBitsToFloat(Bits.swap(unsafe.getInt(this.ix(this.checkIndex(i)))));
    }

    public FloatBuffer get(float[] dst, int offset, int length) {
        if (length << 2 > 6) {
            int rem;
            DirectFloatBufferS.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(pos), dst, offset << 2, length << 2);
            } else {
                Bits.copyToByteArray(this.ix(pos), dst, offset << 2, length << 2);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    public FloatBuffer put(float x) {
        unsafe.putInt(this.ix(this.nextPutIndex()), Bits.swap(Float.floatToRawIntBits(x)));
        return this;
    }

    public FloatBuffer put(int i, float x) {
        unsafe.putInt(this.ix(this.checkIndex(i)), Bits.swap(Float.floatToRawIntBits(x)));
        return this;
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src instanceof DirectFloatBufferS) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferS sb = (DirectFloatBufferS)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), srem << 2);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    public FloatBuffer put(float[] src, int offset, int length) {
        if (length << 2 > 6) {
            int rem;
            DirectFloatBufferS.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(src, offset << 2, this.ix(pos), length << 2);
            } else {
                Bits.copyFromByteArray(src, offset << 2, this.ix(pos), length << 2);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), rem << 2);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

