/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import java.math.BitSieve;
import java.math.MutableBigInteger;
import java.security.SecureRandom;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigInteger
extends Number
implements Comparable<BigInteger> {
    int signum;
    int[] mag;
    private int bitCount = -1;
    private int bitLength = -1;
    private int lowestSetBit = -2;
    private int firstNonzeroByteNum = -2;
    private int firstNonzeroIntNum = -2;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    private static final BigInteger SMALL_PRIME_PRODUCT;
    private static volatile Random staticRandom;
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst;
    private static BigInteger[] negConst;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    public static final BigInteger TEN;
    static int[] bnExpModThreshTable;
    static final byte[] trailingZeroTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static int[] digitsPerInt;
    private static int[] intRadix;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final ObjectStreamField[] serialPersistentFields;

    public BigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.mag = BigInteger.makePositive(val);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(val);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    private BigInteger(int[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.mag = BigInteger.makePositive(val);
            this.signum = -1;
        } else {
            this.mag = BigInteger.trustedStripLeadingZeroInts(val);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    public BigInteger(int signum, byte[] magnitude) {
        this.mag = BigInteger.stripLeadingZeroBytes(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = signum;
        }
    }

    private BigInteger(int signum, int[] magnitude) {
        this.mag = BigInteger.stripLeadingZeroInts(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = signum;
        }
    }

    public BigInteger(String val, int radix) {
        int cursor = 0;
        int len = val.length();
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (val.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.signum = 1;
        int index = val.lastIndexOf(45);
        if (index != -1) {
            if (index == 0) {
                if (val.length() == 1) {
                    throw new NumberFormatException("Zero length BigInteger");
                }
                this.signum = -1;
                cursor = 1;
            } else {
                throw new NumberFormatException("Illegal embedded sign character");
            }
        }
        while (cursor < len && Character.digit(val.charAt(cursor), radix) == 0) {
            ++cursor;
        }
        if (cursor == len) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int numDigits = len - cursor;
        int numBits = (int)(((long)numDigits * bitsPerDigit[radix] >>> 10) + 1L);
        int numWords = (numBits + 31) / 32;
        this.mag = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[radix];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[radix];
        }
        String group = val.substring(cursor, cursor += firstGroupLen);
        this.mag[this.mag.length - 1] = Integer.parseInt(group, radix);
        if (this.mag[this.mag.length - 1] < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        int superRadix = intRadix[radix];
        int groupVal = 0;
        while (cursor < val.length()) {
            if ((groupVal = Integer.parseInt(group = val.substring(cursor, cursor += digitsPerInt[radix]), radix)) < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            BigInteger.destructiveMulAdd(this.mag, superRadix, groupVal);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(this.mag);
    }

    BigInteger(char[] val) {
        int numWords;
        int cursor = 0;
        int len = val.length;
        this.signum = 1;
        if (val[0] == '-') {
            if (len == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.signum = -1;
            cursor = 1;
        }
        while (cursor < len && Character.digit(val[cursor], 10) == 0) {
            ++cursor;
        }
        if (cursor == len) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int numDigits = len - cursor;
        if (len < 10) {
            numWords = 1;
        } else {
            int numBits = (int)(((long)numDigits * bitsPerDigit[10] >>> 10) + 1L);
            numWords = (numBits + 31) / 32;
        }
        this.mag = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[10];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[10];
        }
        this.mag[this.mag.length - 1] = this.parseInt(val, cursor, cursor += firstGroupLen);
        while (cursor < len) {
            int groupVal = this.parseInt(val, cursor, cursor += digitsPerInt[10]);
            BigInteger.destructiveMulAdd(this.mag, intRadix[10], groupVal);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(this.mag);
    }

    private int parseInt(char[] source, int start, int end) {
        int result;
        if ((result = Character.digit(source[start++], 10)) == -1) {
            throw new NumberFormatException(new String(source));
        }
        for (int index = start; index < end; ++index) {
            int nextVal = Character.digit(source[index], 10);
            if (nextVal == -1) {
                throw new NumberFormatException(new String(source));
            }
            result = 10 * result + nextVal;
        }
        return result;
    }

    private static void destructiveMulAdd(int[] x, int y, int z) {
        long ylong = (long)y & 0xFFFFFFFFL;
        long zlong = (long)z & 0xFFFFFFFFL;
        int len = x.length;
        long product = 0L;
        long carry = 0L;
        for (int i = len - 1; i >= 0; --i) {
            product = ylong * ((long)x[i] & 0xFFFFFFFFL) + carry;
            x[i] = (int)product;
            carry = product >>> 32;
        }
        long sum = ((long)x[len - 1] & 0xFFFFFFFFL) + zlong;
        x[len - 1] = (int)sum;
        carry = sum >>> 32;
        for (int i = len - 2; i >= 0; --i) {
            sum = ((long)x[i] & 0xFFFFFFFFL) + carry;
            x[i] = (int)sum;
            carry = sum >>> 32;
        }
    }

    public BigInteger(String val) {
        this(val, 10);
    }

    public BigInteger(int numBits, Random rnd) {
        this(1, BigInteger.randomBits(numBits, rnd));
    }

    private static byte[] randomBits(int numBits, Random rnd) {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int numBytes = (int)(((long)numBits + 7L) / 8L);
        byte[] randomBits = new byte[numBytes];
        if (numBytes > 0) {
            rnd.nextBytes(randomBits);
            int excessBits = 8 * numBytes - numBits;
            randomBits[0] = (byte)(randomBits[0] & (1 << 8 - excessBits) - 1);
        }
        return randomBits;
    }

    public BigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        BigInteger prime = bitLength < 95 ? BigInteger.smallPrime(bitLength, certainty, rnd) : BigInteger.largePrime(bitLength, certainty, rnd);
        this.signum = 1;
        this.mag = prime.mag;
    }

    public static BigInteger probablePrime(int bitLength, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        return bitLength < 95 ? BigInteger.smallPrime(bitLength, 100, rnd) : BigInteger.largePrime(bitLength, 100, rnd);
    }

    /*
     * Unable to fully structure code
     */
    private static BigInteger smallPrime(int bitLength, int certainty, Random rnd) {
        magLen = bitLength + 31 >>> 5;
        temp = new int[magLen];
        highBit = 1 << (bitLength + 31 & 31);
        highMask = (highBit << 1) - 1;
        while (true) {
            for (i = 0; i < magLen; ++i) {
                temp[i] = rnd.nextInt();
            }
            temp[0] = temp[0] & highMask | highBit;
            if (bitLength > 2) {
                v0 = magLen - 1;
                temp[v0] = temp[v0] | 1;
            }
            p = new BigInteger(temp, 1);
            if (bitLength > 6 && ((r = p.remainder(BigInteger.SMALL_PRIME_PRODUCT).longValue()) % 3L == 0L || r % 5L == 0L || r % 7L == 0L || r % 11L == 0L || r % 13L == 0L || r % 17L == 0L || r % 19L == 0L || r % 23L == 0L || r % 29L == 0L || r % 31L == 0L || r % 37L == 0L || r % 41L == 0L)) ** continue;
            if (bitLength < 4) {
                return p;
            }
            if (p.primeToCertainty(certainty, rnd)) break;
        }
        return p;
    }

    private static BigInteger largePrime(int bitLength, int certainty, Random rnd) {
        BigInteger p = new BigInteger(bitLength, rnd).setBit(bitLength - 1);
        int n = p.mag.length - 1;
        p.mag[n] = p.mag[n] & 0xFFFFFFFE;
        int searchLen = bitLength / 20 * 64;
        BitSieve searchSieve = new BitSieve(p, searchLen);
        BigInteger candidate = searchSieve.retrieve(p, certainty, rnd);
        while (candidate == null || candidate.bitLength() != bitLength) {
            if ((p = p.add(BigInteger.valueOf(2 * searchLen))).bitLength() != bitLength) {
                p = new BigInteger(bitLength, rnd).setBit(bitLength - 1);
            }
            int n2 = p.mag.length - 1;
            p.mag[n2] = p.mag[n2] & 0xFFFFFFFE;
            searchSieve = new BitSieve(p, searchLen);
            candidate = searchSieve.retrieve(p, certainty, rnd);
        }
        return candidate;
    }

    public BigInteger nextProbablePrime() {
        if (this.signum < 0) {
            throw new ArithmeticException("start < 0: " + this);
        }
        if (this.signum == 0 || this.equals(ONE)) {
            return TWO;
        }
        BigInteger result = this.add(ONE);
        if (result.bitLength() < 95) {
            if (!result.testBit(0)) {
                result = result.add(ONE);
            }
            while (true) {
                long r;
                if (result.bitLength() > 6 && ((r = result.remainder(SMALL_PRIME_PRODUCT).longValue()) % 3L == 0L || r % 5L == 0L || r % 7L == 0L || r % 11L == 0L || r % 13L == 0L || r % 17L == 0L || r % 19L == 0L || r % 23L == 0L || r % 29L == 0L || r % 31L == 0L || r % 37L == 0L || r % 41L == 0L)) {
                    result = result.add(TWO);
                    continue;
                }
                if (result.bitLength() < 4) {
                    return result;
                }
                if (result.primeToCertainty(100, null)) {
                    return result;
                }
                result = result.add(TWO);
            }
        }
        if (result.testBit(0)) {
            result = result.subtract(ONE);
        }
        int searchLen = result.bitLength() / 20 * 64;
        BitSieve searchSieve;
        BigInteger candidate;
        while ((candidate = (searchSieve = new BitSieve(result, searchLen)).retrieve(result, 100, null)) == null) {
            result = result.add(BigInteger.valueOf(2 * searchLen));
        }
        return candidate;
    }

    boolean primeToCertainty(int certainty, Random random) {
        int rounds = 0;
        int n = (Math.min(certainty, 0x7FFFFFFE) + 1) / 2;
        int sizeInBits = this.bitLength();
        if (sizeInBits < 100) {
            rounds = 50;
            rounds = n < rounds ? n : rounds;
            return this.passesMillerRabin(rounds, random);
        }
        rounds = sizeInBits < 256 ? 27 : (sizeInBits < 512 ? 15 : (sizeInBits < 768 ? 8 : (sizeInBits < 1024 ? 4 : 2)));
        rounds = n < rounds ? n : rounds;
        return this.passesMillerRabin(rounds, random) && this.passesLucasLehmer();
    }

    private boolean passesLucasLehmer() {
        BigInteger thisPlusOne = this.add(ONE);
        int d = 5;
        while (BigInteger.jacobiSymbol(d, this) != -1) {
            d = d < 0 ? Math.abs(d) + 2 : -(d + 2);
        }
        BigInteger u = BigInteger.lucasLehmerSequence(d, thisPlusOne, this);
        return u.mod(this).equals(ZERO);
    }

    private static int jacobiSymbol(int p, BigInteger n) {
        if (p == 0) {
            return 0;
        }
        int j = 1;
        int u = n.mag[n.mag.length - 1];
        if (p < 0) {
            p = -p;
            int n8 = u & 7;
            if (n8 == 3 || n8 == 7) {
                j = -j;
            }
        }
        while ((p & 3) == 0) {
            p >>= 2;
        }
        if ((p & 1) == 0) {
            p >>= 1;
            if (((u ^ u >> 1) & 2) != 0) {
                j = -j;
            }
        }
        if (p == 1) {
            return j;
        }
        if ((p & u & 2) != 0) {
            j = -j;
        }
        for (u = n.mod(BigInteger.valueOf(p)).intValue(); u != 0; u %= p) {
            while ((u & 3) == 0) {
                u >>= 2;
            }
            if ((u & 1) == 0) {
                u >>= 1;
                if (((p ^ p >> 1) & 2) != 0) {
                    j = -j;
                }
            }
            if (u == 1) {
                return j;
            }
            assert (u < p);
            u = p;
            int t = u;
            if ((u & (p = t) & 2) == 0) continue;
            j = -j;
        }
        return 0;
    }

    private static BigInteger lucasLehmerSequence(int z, BigInteger k, BigInteger n) {
        BigInteger d = BigInteger.valueOf(z);
        BigInteger u = ONE;
        BigInteger v = ONE;
        for (int i = k.bitLength() - 2; i >= 0; --i) {
            BigInteger u2 = u.multiply(v).mod(n);
            BigInteger v2 = v.square().add(d.multiply(u.square())).mod(n);
            if (v2.testBit(0)) {
                v2 = n.subtract(v2);
                v2.signum = -v2.signum;
            }
            v2 = v2.shiftRight(1);
            u = u2;
            v = v2;
            if (!k.testBit(i)) continue;
            u2 = u.add(v).mod(n);
            if (u2.testBit(0)) {
                u2 = n.subtract(u2);
                u2.signum = -u2.signum;
            }
            u2 = u2.shiftRight(1);
            v2 = v.add(d.multiply(u)).mod(n);
            if (v2.testBit(0)) {
                v2 = n.subtract(v2);
                v2.signum = -v2.signum;
            }
            v2 = v2.shiftRight(1);
            u = u2;
            v = v2;
        }
        return u;
    }

    private static Random getSecureRandom() {
        if (staticRandom == null) {
            staticRandom = new SecureRandom();
        }
        return staticRandom;
    }

    private boolean passesMillerRabin(int iterations, Random rnd) {
        BigInteger thisMinusOne;
        BigInteger m = thisMinusOne = this.subtract(ONE);
        int a = m.getLowestSetBit();
        m = m.shiftRight(a);
        if (rnd == null) {
            rnd = BigInteger.getSecureRandom();
        }
        for (int i = 0; i < iterations; ++i) {
            BigInteger b;
            while ((b = new BigInteger(this.bitLength(), rnd)).compareTo(ONE) <= 0 || b.compareTo(this) >= 0) {
            }
            int j = 0;
            BigInteger z = b.modPow(m, this);
            while (!(j == 0 && z.equals(ONE) || z.equals(thisMinusOne))) {
                if (j > 0 && z.equals(ONE) || ++j == a) {
                    return false;
                }
                z = z.modPow(TWO, this);
            }
        }
        return true;
    }

    private BigInteger(int[] magnitude, int signum) {
        this.signum = magnitude.length == 0 ? 0 : signum;
        this.mag = magnitude;
    }

    private BigInteger(byte[] magnitude, int signum) {
        this.signum = magnitude.length == 0 ? 0 : signum;
        this.mag = BigInteger.stripLeadingZeroBytes(magnitude);
    }

    BigInteger(MutableBigInteger val, int sign) {
        if (val.offset > 0 || val.value.length != val.intLen) {
            this.mag = new int[val.intLen];
            for (int i = 0; i < val.intLen; ++i) {
                this.mag[i] = val.value[val.offset + i];
            }
        } else {
            this.mag = val.value;
        }
        this.signum = val.intLen == 0 ? 0 : sign;
    }

    public static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val > 0L && val <= 16L) {
            return posConst[(int)val];
        }
        if (val < 0L && val >= -16L) {
            return negConst[(int)(-val)];
        }
        return new BigInteger(val);
    }

    private BigInteger(long val) {
        if (val < 0L) {
            this.signum = -1;
            val = -val;
        } else {
            this.signum = 1;
        }
        int highWord = (int)(val >>> 32);
        if (highWord == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)val;
        } else {
            this.mag = new int[2];
            this.mag[0] = highWord;
            this.mag[1] = (int)val;
        }
    }

    private static BigInteger valueOf(int[] val) {
        return val[0] > 0 ? new BigInteger(val, 1) : new BigInteger(val);
    }

    public BigInteger add(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val;
        }
        if (val.signum == this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = BigInteger.intArrayCmp(this.mag, val.mag);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp * this.signum);
    }

    private static int[] add(int[] x, int[] y) {
        boolean carry;
        if (x.length < y.length) {
            int[] tmp = x;
            x = y;
            y = tmp;
        }
        int xIndex = x.length;
        int yIndex = y.length;
        int[] result = new int[xIndex];
        long sum = 0L;
        while (yIndex > 0) {
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[--yIndex] & 0xFFFFFFFFL) + (sum >>> 32);
            result[xIndex] = (int)sum;
        }
        boolean bl = carry = sum >>> 32 != 0L;
        while (xIndex > 0 && carry) {
            result[--xIndex] = x[xIndex] + 1;
            carry = result[--xIndex] == 0;
        }
        while (xIndex > 0) {
            result[--xIndex] = x[xIndex];
        }
        if (carry) {
            int newLen = result.length + 1;
            int[] temp = new int[newLen];
            for (int i = 1; i < newLen; ++i) {
                temp[i] = result[i - 1];
            }
            temp[0] = 1;
            result = temp;
        }
        return result;
    }

    public BigInteger subtract(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val.negate();
        }
        if (val.signum != this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = BigInteger.intArrayCmp(this.mag, val.mag);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp * this.signum);
    }

    private static int[] subtract(int[] big, int[] little) {
        boolean borrow;
        int bigIndex = big.length;
        int[] result = new int[bigIndex];
        int littleIndex = little.length;
        long difference = 0L;
        while (littleIndex > 0) {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
            result[bigIndex] = (int)difference;
        }
        boolean bl = borrow = difference >> 32 != 0L;
        while (bigIndex > 0 && borrow) {
            result[--bigIndex] = big[bigIndex] - 1;
            borrow = result[--bigIndex] == -1;
        }
        while (bigIndex > 0) {
            result[--bigIndex] = big[bigIndex];
        }
        return result;
    }

    public BigInteger multiply(BigInteger val) {
        if (val.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        int[] result = this.multiplyToLen(this.mag, this.mag.length, val.mag, val.mag.length, null);
        result = BigInteger.trustedStripLeadingZeroInts(result);
        return new BigInteger(result, this.signum * val.signum);
    }

    private int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
        int xstart = xlen - 1;
        int ystart = ylen - 1;
        if (z == null || z.length < xlen + ylen) {
            z = new int[xlen + ylen];
        }
        long carry = 0L;
        int j = ystart;
        int k = ystart + 1 + xstart;
        while (j >= 0) {
            long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
            z[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        z[xstart] = (int)carry;
        for (int i = xstart - 1; i >= 0; --i) {
            carry = 0L;
            int j2 = ystart;
            int k2 = ystart + 1 + i;
            while (j2 >= 0) {
                long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z[k2] & 0xFFFFFFFFL) + carry;
                z[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            z[i] = (int)carry;
        }
        return z;
    }

    private BigInteger square() {
        if (this.signum == 0) {
            return ZERO;
        }
        int[] z = BigInteger.squareToLen(this.mag, this.mag.length, null);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(z), 1);
    }

    private static final int[] squareToLen(int[] x, int len, int[] z) {
        int zlen = len << 1;
        if (z == null || z.length < zlen) {
            z = new int[zlen];
        }
        int lastProductLowWord = 0;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            long piece = (long)x[j] & 0xFFFFFFFFL;
            long product = piece * piece;
            z[i++] = lastProductLowWord << 31 | (int)(product >>> 33);
            z[i++] = (int)(product >>> 1);
            lastProductLowWord = (int)product;
        }
        int i2 = len;
        int offset = 1;
        while (i2 > 0) {
            int t = x[i2 - 1];
            t = BigInteger.mulAdd(z, x, offset, i2 - 1, t);
            BigInteger.addOne(z, offset - 1, i2, t);
            --i2;
            offset += 2;
        }
        BigInteger.primitiveLeftShift(z, zlen, 1);
        int n = zlen - 1;
        z[n] = z[n] | x[len - 1] & 1;
        return z;
    }

    public BigInteger divide(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        a.divide(b, q, r);
        return new BigInteger(q, this.signum * val.signum);
    }

    public BigInteger[] divideAndRemainder(BigInteger val) {
        BigInteger[] result = new BigInteger[2];
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        a.divide(b, q, r);
        result[0] = new BigInteger(q, this.signum * val.signum);
        result[1] = new BigInteger(r, this.signum);
        return result;
    }

    public BigInteger remainder(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        a.divide(b, q, r);
        return new BigInteger(r, this.signum);
    }

    public BigInteger pow(int exponent) {
        if (exponent < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.signum == 0) {
            return exponent == 0 ? ONE : this;
        }
        int newSign = this.signum < 0 && (exponent & 1) == 1 ? -1 : 1;
        int[] baseToPow2 = this.mag;
        int[] result = new int[]{1};
        while (exponent != 0) {
            if ((exponent & 1) == 1) {
                result = this.multiplyToLen(result, result.length, baseToPow2, baseToPow2.length, null);
                result = BigInteger.trustedStripLeadingZeroInts(result);
            }
            if ((exponent >>>= 1) == 0) continue;
            baseToPow2 = BigInteger.squareToLen(baseToPow2, baseToPow2.length, null);
            baseToPow2 = BigInteger.trustedStripLeadingZeroInts(baseToPow2);
        }
        return new BigInteger(result, newSign);
    }

    public BigInteger gcd(BigInteger val) {
        if (val.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return val.abs();
        }
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger b = new MutableBigInteger(val);
        MutableBigInteger result = a.hybridGCD(b);
        return new BigInteger(result, 1);
    }

    private static int[] leftShift(int[] a, int len, int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.bitLen(a[0]);
        if (n <= 32 - bitsInHighWord) {
            BigInteger.primitiveLeftShift(a, len, nBits);
            return a;
        }
        if (nBits <= 32 - bitsInHighWord) {
            int[] result = new int[nInts + len];
            for (int i = 0; i < len; ++i) {
                result[i] = a[i];
            }
            BigInteger.primitiveLeftShift(result, result.length, nBits);
            return result;
        }
        int[] result = new int[nInts + len + 1];
        for (int i = 0; i < len; ++i) {
            result[i] = a[i];
        }
        BigInteger.primitiveRightShift(result, result.length, 32 - nBits);
        return result;
    }

    static void primitiveRightShift(int[] a, int len, int n) {
        int i;
        int n2 = 32 - n;
        int c = a[i];
        for (i = len - 1; i > 0; --i) {
            int b = c;
            c = a[i - 1];
            a[i] = c << n2 | b >>> n;
        }
        a[0] = a[0] >>> n;
    }

    static void primitiveLeftShift(int[] a, int len, int n) {
        int i;
        if (len == 0 || n == 0) {
            return;
        }
        int n2 = 32 - n;
        int c = a[i];
        int m = i + len - 1;
        for (i = 0; i < m; ++i) {
            int b = c;
            c = a[i + 1];
            a[i] = b << n | c >>> n2;
        }
        int n3 = len - 1;
        a[n3] = a[n3] << n;
    }

    private static int bitLength(int[] val, int len) {
        if (len == 0) {
            return 0;
        }
        return (len - 1 << 5) + BigInteger.bitLen(val[0]);
    }

    public BigInteger abs() {
        return this.signum >= 0 ? this : this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(this.mag, -this.signum);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger m) {
        if (m.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger result = this.remainder(m);
        return result.signum >= 0 ? result : result.add(m);
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        BigInteger result;
        BigInteger base;
        if (m.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (exponent.signum == 0) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ONE)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ZERO) && exponent.signum >= 0) {
            return ZERO;
        }
        if (this.equals(negConst[1]) && !exponent.testBit(0)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        boolean invertResult = exponent.signum < 0;
        if (invertResult) {
            exponent = exponent.negate();
        }
        BigInteger bigInteger = base = this.signum < 0 || this.compareTo(m) >= 0 ? this.mod(m) : this;
        if (m.testBit(0)) {
            result = base.oddModPow(exponent, m);
        } else {
            int p = m.getLowestSetBit();
            BigInteger m1 = m.shiftRight(p);
            BigInteger m2 = ONE.shiftLeft(p);
            BigInteger base2 = this.signum < 0 || this.compareTo(m1) >= 0 ? this.mod(m1) : this;
            BigInteger a1 = m1.equals(ONE) ? ZERO : base2.oddModPow(exponent, m1);
            BigInteger a2 = base.modPow2(exponent, p);
            BigInteger y1 = m2.modInverse(m1);
            BigInteger y2 = m1.modInverse(m2);
            result = a1.multiply(m2).multiply(y1).add(a2.multiply(m1).multiply(y2)).mod(m);
        }
        return invertResult ? result.modInverse(m) : result;
    }

    private BigInteger oddModPow(BigInteger y, BigInteger z) {
        int i;
        int i2;
        if (y.equals(ONE)) {
            return this;
        }
        if (this.signum == 0) {
            return ZERO;
        }
        int[] base = (int[])this.mag.clone();
        int[] exp = y.mag;
        int[] mod = z.mag;
        int modLen = mod.length;
        int wbits = 0;
        int ebits = BigInteger.bitLength(exp, exp.length);
        if (ebits != 17 || exp[0] != 65537) {
            while (ebits > bnExpModThreshTable[wbits]) {
                ++wbits;
            }
        }
        int tblmask = 1 << wbits;
        int[][] table = new int[tblmask][];
        for (int i3 = 0; i3 < tblmask; ++i3) {
            table[i3] = new int[modLen];
        }
        int inv = -MutableBigInteger.inverseMod32(mod[modLen - 1]);
        int[] a = BigInteger.leftShift(base, base.length, modLen << 5);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        MutableBigInteger a2 = new MutableBigInteger(a);
        MutableBigInteger b2 = new MutableBigInteger(mod);
        a2.divide(b2, q, r);
        table[0] = r.toIntArray();
        if (table[0].length < modLen) {
            int offset = modLen - table[0].length;
            int[] t2 = new int[modLen];
            for (i2 = 0; i2 < table[0].length; ++i2) {
                t2[i2 + offset] = table[0][i2];
            }
            table[0] = t2;
        }
        int[] b = BigInteger.squareToLen(table[0], modLen, null);
        b = BigInteger.montReduce(b, mod, modLen, inv);
        int[] t = new int[modLen];
        for (i2 = 0; i2 < modLen; ++i2) {
            t[i2] = b[i2];
        }
        for (i2 = 1; i2 < tblmask; ++i2) {
            int[] prod = this.multiplyToLen(t, modLen, table[i2 - 1], modLen, null);
            table[i2] = BigInteger.montReduce(prod, mod, modLen, inv);
        }
        int bitpos = 1 << (ebits - 1 & 0x1F);
        int buf = 0;
        int elen = exp.length;
        int eIndex = 0;
        for (int i4 = 0; i4 <= wbits; ++i4) {
            buf = buf << 1 | ((exp[eIndex] & bitpos) != 0 ? 1 : 0);
            if ((bitpos >>>= 1) != 0) continue;
            ++eIndex;
            bitpos = Integer.MIN_VALUE;
            --elen;
        }
        int multpos = ebits--;
        boolean isone = true;
        multpos = ebits - wbits;
        while ((buf & 1) == 0) {
            buf >>>= 1;
            ++multpos;
        }
        int[] mult = table[buf >>> 1];
        buf = 0;
        if (multpos == ebits) {
            isone = false;
        }
        while (true) {
            --ebits;
            buf <<= 1;
            if (elen != 0) {
                buf |= (exp[eIndex] & bitpos) != 0 ? 1 : 0;
                if ((bitpos >>>= 1) == 0) {
                    ++eIndex;
                    bitpos = Integer.MIN_VALUE;
                    --elen;
                }
            }
            if ((buf & tblmask) != 0) {
                multpos = ebits - wbits;
                while ((buf & 1) == 0) {
                    buf >>>= 1;
                    ++multpos;
                }
                mult = table[buf >>> 1];
                buf = 0;
            }
            if (ebits == multpos) {
                if (isone) {
                    b = (int[])mult.clone();
                    isone = false;
                } else {
                    t = b;
                    a = this.multiplyToLen(t, modLen, mult, modLen, a);
                    a = BigInteger.montReduce(a, mod, modLen, inv);
                    t = a;
                    a = b;
                    b = t;
                }
            }
            if (ebits == 0) break;
            if (isone) continue;
            t = b;
            a = BigInteger.squareToLen(t, modLen, a);
            a = BigInteger.montReduce(a, mod, modLen, inv);
            t = a;
            a = b;
            b = t;
        }
        int[] t2 = new int[2 * modLen];
        for (i = 0; i < modLen; ++i) {
            t2[i + modLen] = b[i];
        }
        b = BigInteger.montReduce(t2, mod, modLen, inv);
        t2 = new int[modLen];
        for (i = 0; i < modLen; ++i) {
            t2[i] = b[i];
        }
        return new BigInteger(1, t2);
    }

    private static int[] montReduce(int[] n, int[] mod, int mlen, int inv) {
        int c = 0;
        int len = mlen;
        int offset = 0;
        do {
            int nEnd = n[n.length - 1 - offset];
            int carry = BigInteger.mulAdd(n, mod, offset, mlen, inv * nEnd);
            c += BigInteger.addOne(n, offset, mlen, carry);
            ++offset;
        } while (--len > 0);
        while (c > 0) {
            c += BigInteger.subN(n, mod, mlen);
        }
        while (BigInteger.intArrayCmpToLen(n, mod, mlen) >= 0) {
            BigInteger.subN(n, mod, mlen);
        }
        return n;
    }

    private static int intArrayCmpToLen(int[] arg1, int[] arg2, int len) {
        for (int i = 0; i < len; ++i) {
            long b1 = (long)arg1[i] & 0xFFFFFFFFL;
            long b2 = (long)arg2[i] & 0xFFFFFFFFL;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    private static int subN(int[] a, int[] b, int len) {
        long sum = 0L;
        while (--len >= 0) {
            sum = ((long)a[len] & 0xFFFFFFFFL) - ((long)b[len] & 0xFFFFFFFFL) + (sum >> 32);
            a[len] = (int)sum;
        }
        return (int)(sum >> 32);
    }

    static int mulAdd(int[] out, int[] in, int offset, int len, int k) {
        long kLong = (long)k & 0xFFFFFFFFL;
        long carry = 0L;
        offset = out.length - offset - 1;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out[offset] & 0xFFFFFFFFL) + carry;
            out[offset--] = (int)product;
            carry = product >>> 32;
        }
        return (int)carry;
    }

    static int addOne(int[] a, int offset, int mlen, int carry) {
        offset = a.length - 1 - mlen - offset;
        long t = ((long)a[offset] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
        a[offset] = (int)t;
        if (t >>> 32 == 0L) {
            return 0;
        }
        while (--mlen >= 0) {
            if (--offset < 0) {
                return 1;
            }
            int n = offset;
            a[n] = a[n] + 1;
            if (a[offset] == 0) continue;
            return 0;
        }
        return 1;
    }

    private BigInteger modPow2(BigInteger exponent, int p) {
        BigInteger result = BigInteger.valueOf(1L);
        BigInteger baseToPow2 = this.mod2(p);
        int expOffset = 0;
        int limit = exponent.bitLength();
        if (this.testBit(0)) {
            int n = limit = p - 1 < limit ? p - 1 : limit;
        }
        while (expOffset < limit) {
            if (exponent.testBit(expOffset)) {
                result = result.multiply(baseToPow2).mod2(p);
            }
            if (++expOffset >= limit) continue;
            baseToPow2 = baseToPow2.square().mod2(p);
        }
        return result;
    }

    private BigInteger mod2(int p) {
        if (this.bitLength() <= p) {
            return this;
        }
        int numInts = (p + 31) / 32;
        int[] mag = new int[numInts];
        for (int i = 0; i < numInts; ++i) {
            mag[i] = this.mag[i + (this.mag.length - numInts)];
        }
        int excessBits = (numInts << 5) - p;
        mag[0] = (int)((long)mag[0] & (1L << 32 - excessBits) - 1L);
        return mag[0] == 0 ? new BigInteger(1, mag) : new BigInteger(mag, 1);
    }

    public BigInteger modInverse(BigInteger m) {
        if (m.signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (m.equals(ONE)) {
            return ZERO;
        }
        BigInteger modVal = this;
        if (this.signum < 0 || BigInteger.intArrayCmp(this.mag, m.mag) >= 0) {
            modVal = this.mod(m);
        }
        if (modVal.equals(ONE)) {
            return ONE;
        }
        MutableBigInteger a = new MutableBigInteger(modVal);
        MutableBigInteger b = new MutableBigInteger(m);
        MutableBigInteger result = a.mutableModInverse(b);
        return new BigInteger(result, 1);
    }

    public BigInteger shiftLeft(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this.mag.length;
        int[] newMag = null;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            for (int i = 0; i < magLen; ++i) {
                newMag[i] = this.mag[i];
            }
        } else {
            int i = 0;
            int nBits2 = 32 - nBits;
            int highBits = this.mag[0] >>> nBits2;
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen + nInts];
            }
            int j = 0;
            while (j < magLen - 1) {
                newMag[i++] = this.mag[j++] << nBits | this.mag[j] >>> nBits2;
            }
            newMag[i] = this.mag[j] << nBits;
        }
        return new BigInteger(newMag, this.signum);
    }

    public BigInteger shiftRight(int n) {
        int i;
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this.mag.length;
        int[] newMag = null;
        if (nInts >= magLen) {
            return this.signum >= 0 ? ZERO : negConst[1];
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            newMag = new int[newMagLen];
            for (i = 0; i < newMagLen; ++i) {
                newMag[i] = this.mag[i];
            }
        } else {
            int i2 = 0;
            int highBits = this.mag[0] >>> nBits;
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                newMag[i2++] = highBits;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            int j = 0;
            while (j < magLen - nInts - 1) {
                newMag[i2++] = this.mag[j++] << nBits2 | this.mag[j] >>> nBits;
            }
        }
        if (this.signum < 0) {
            boolean onesLost = false;
            int j = magLen - nInts;
            for (i = magLen - 1; i >= j && !onesLost; --i) {
                onesLost = this.mag[i] != 0;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this.mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new BigInteger(newMag, this.signum);
    }

    int[] javaIncrement(int[] val) {
        int lastSum = 0;
        int i = val.length - 1;
        while (i >= 0 && lastSum == 0) {
            int n = i--;
            int n2 = val[n] + 1;
            val[n] = n2;
            lastSum = n2;
        }
        if (lastSum == 0) {
            val = new int[val.length + 1];
            val[0] = 1;
        }
        return val;
    }

    public BigInteger and(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getInt(result.length - i - 1) & val.getInt(result.length - i - 1);
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger or(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getInt(result.length - i - 1) | val.getInt(result.length - i - 1);
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger xor(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getInt(result.length - i - 1) ^ val.getInt(result.length - i - 1);
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger not() {
        int[] result = new int[this.intLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ~this.getInt(result.length - i - 1);
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger andNot(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getInt(result.length - i - 1) & ~val.getInt(result.length - i - 1);
        }
        return BigInteger.valueOf(result);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getInt(n / 32) & 1 << n % 32) != 0;
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n / 32;
        int[] result = new int[Math.max(this.intLength(), intNum + 2)];
        for (int i = 0; i < result.length; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] | 1 << n % 32;
        return BigInteger.valueOf(result);
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n / 32;
        int[] result = new int[Math.max(this.intLength(), (n + 1) / 32 + 1)];
        for (int i = 0; i < result.length; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] & ~(1 << n % 32);
        return BigInteger.valueOf(result);
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n / 32;
        int[] result = new int[Math.max(this.intLength(), intNum + 2)];
        for (int i = 0; i < result.length; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] ^ 1 << n % 32;
        return BigInteger.valueOf(result);
    }

    public int getLowestSetBit() {
        if (this.lowestSetBit == -2) {
            if (this.signum == 0) {
                this.lowestSetBit = -1;
            } else {
                int b;
                int i = 0;
                while ((b = this.getInt(i)) == 0) {
                    ++i;
                }
                this.lowestSetBit = (i << 5) + BigInteger.trailingZeroCnt(b);
            }
        }
        return this.lowestSetBit;
    }

    public int bitLength() {
        if (this.bitLength == -1) {
            if (this.signum == 0) {
                this.bitLength = 0;
            } else {
                int magBitLength = (this.mag.length - 1 << 5) + BigInteger.bitLen(this.mag[0]);
                if (this.signum < 0) {
                    boolean pow2 = BigInteger.bitCnt(this.mag[0]) == 1;
                    for (int i = 1; i < this.mag.length && pow2; ++i) {
                        pow2 = this.mag[i] == 0;
                    }
                    this.bitLength = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    this.bitLength = magBitLength;
                }
            }
        }
        return this.bitLength;
    }

    static int bitLen(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public int bitCount() {
        if (this.bitCount == -1) {
            int magBitCount = 0;
            for (int i = 0; i < this.mag.length; ++i) {
                magBitCount += BigInteger.bitCnt(this.mag[i]);
            }
            if (this.signum < 0) {
                int magTrailingZeroCount = 0;
                int j = this.mag.length - 1;
                while (this.mag[j] == 0) {
                    magTrailingZeroCount += 32;
                    --j;
                }
                this.bitCount = magBitCount + (magTrailingZeroCount += BigInteger.trailingZeroCnt(this.mag[j])) - 1;
            } else {
                this.bitCount = magBitCount;
            }
        }
        return this.bitCount;
    }

    static int bitCnt(int val) {
        val -= (0xAAAAAAAA & val) >>> 1;
        val = (val & 0x33333333) + (val >>> 2 & 0x33333333);
        val = val + (val >>> 4) & 0xF0F0F0F;
        val += val >>> 8;
        val += val >>> 16;
        return val & 0xFF;
    }

    static int trailingZeroCnt(int val) {
        int byteVal = val & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal];
        }
        byteVal = val >>> 8 & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 8;
        }
        byteVal = val >>> 16 & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 16;
        }
        byteVal = val >>> 24 & 0xFF;
        return trailingZeroTable[byteVal] + 24;
    }

    public boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        BigInteger w = this.abs();
        if (w.equals(TWO)) {
            return true;
        }
        if (!w.testBit(0) || w.equals(ONE)) {
            return false;
        }
        return w.primeToCertainty(certainty, null);
    }

    @Override
    public int compareTo(BigInteger val) {
        return this.signum == val.signum ? this.signum * BigInteger.intArrayCmp(this.mag, val.mag) : (this.signum > val.signum ? 1 : -1);
    }

    private static int intArrayCmp(int[] arg1, int[] arg2) {
        if (arg1.length < arg2.length) {
            return -1;
        }
        if (arg1.length > arg2.length) {
            return 1;
        }
        for (int i = 0; i < arg1.length; ++i) {
            long b1 = (long)arg1[i] & 0xFFFFFFFFL;
            long b2 = (long)arg2[i] & 0xFFFFFFFFL;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)x;
        if (xInt.signum != this.signum || xInt.mag.length != this.mag.length) {
            return false;
        }
        for (int i = 0; i < this.mag.length; ++i) {
            if (xInt.mag[i] == this.mag[i]) continue;
            return false;
        }
        return true;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.mag.length; ++i) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.mag[i] & 0xFFFFFFFFL));
        }
        return hashCode * this.signum;
    }

    public String toString(int radix) {
        if (this.signum == 0) {
            return "0";
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        int maxNumDigitGroups = (4 * this.mag.length + 6) / 7;
        String[] digitGroup = new String[maxNumDigitGroups];
        BigInteger tmp = this.abs();
        int numGroups = 0;
        while (tmp.signum != 0) {
            BigInteger d = longRadix[radix];
            MutableBigInteger q = new MutableBigInteger();
            MutableBigInteger r = new MutableBigInteger();
            MutableBigInteger a = new MutableBigInteger(tmp.mag);
            MutableBigInteger b = new MutableBigInteger(d.mag);
            a.divide(b, q, r);
            BigInteger q2 = new BigInteger(q, tmp.signum * d.signum);
            BigInteger r2 = new BigInteger(r, tmp.signum * d.signum);
            digitGroup[numGroups++] = Long.toString(r2.longValue(), radix);
            tmp = q2;
        }
        StringBuilder buf = new StringBuilder(numGroups * digitsPerLong[radix] + 1);
        if (this.signum < 0) {
            buf.append('-');
        }
        buf.append(digitGroup[numGroups - 1]);
        for (int i = numGroups - 2; i >= 0; --i) {
            int numLeadingZeros = digitsPerLong[radix] - digitGroup[i].length();
            if (numLeadingZeros != 0) {
                buf.append(zeros[numLeadingZeros]);
            }
            buf.append(digitGroup[i]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int byteLen = this.bitLength() / 8 + 1;
        byte[] byteArray = new byte[byteLen];
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                nextInt = this.getInt(intIndex++);
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            byteArray[i] = (byte)nextInt;
        }
        return byteArray;
    }

    @Override
    public int intValue() {
        int result = 0;
        result = this.getInt(0);
        return result;
    }

    @Override
    public long longValue() {
        long result = 0L;
        for (int i = 1; i >= 0; --i) {
            result = (result << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
        }
        return result;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    private static int[] stripLeadingZeroInts(int[] val) {
        int keep;
        int byteLength = val.length;
        for (keep = 0; keep < val.length && val[keep] == 0; ++keep) {
        }
        int[] result = new int[val.length - keep];
        for (int i = 0; i < val.length - keep; ++i) {
            result[i] = val[keep + i];
        }
        return result;
    }

    private static int[] trustedStripLeadingZeroInts(int[] val) {
        int keep;
        int byteLength = val.length;
        for (keep = 0; keep < val.length && val[keep] == 0; ++keep) {
        }
        if (keep > 0) {
            int[] result = new int[val.length - keep];
            for (int i = 0; i < val.length - keep; ++i) {
                result[i] = val[keep + i];
            }
            return result;
        }
        return val;
    }

    private static int[] stripLeadingZeroBytes(byte[] a) {
        int keep;
        int byteLength = a.length;
        for (keep = 0; keep < a.length && a[keep] == 0; ++keep) {
        }
        int intLength = (byteLength - keep + 3) / 4;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        for (int i = intLength - 1; i >= 0; --i) {
            result[i] = a[b--] & 0xFF;
            int bytesRemaining = b - keep + 1;
            int bytesToTransfer = Math.min(3, bytesRemaining);
            for (int j = 8; j <= 8 * bytesToTransfer; j += 8) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
            }
        }
        return result;
    }

    private static int[] makePositive(byte[] a) {
        int i;
        int k;
        int keep;
        int byteLength = a.length;
        for (keep = 0; keep < byteLength && a[keep] == -1; ++keep) {
        }
        for (k = keep; k < byteLength && a[k] == 0; ++k) {
        }
        int extraByte = k == byteLength ? 1 : 0;
        int intLength = (byteLength - keep + extraByte + 3) / 4;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        for (i = intLength - 1; i >= 0; --i) {
            result[i] = a[b--] & 0xFF;
            int numBytesToTransfer = Math.min(3, b - keep + 1);
            if (numBytesToTransfer < 0) {
                numBytesToTransfer = 0;
            }
            for (int j = 8; j <= 8 * numBytesToTransfer; j += 8) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
            }
            int mask = -1 >>> 8 * (3 - numBytesToTransfer);
            result[i] = ~result[i] & mask;
        }
        for (i = result.length - 1; i >= 0; --i) {
            result[i] = (int)(((long)result[i] & 0xFFFFFFFFL) + 1L);
            if (result[i] != 0) break;
        }
        return result;
    }

    private static int[] makePositive(int[] a) {
        int n;
        int i;
        int j;
        int keep;
        for (keep = 0; keep < a.length && a[keep] == -1; ++keep) {
        }
        for (j = keep; j < a.length && a[j] == 0; ++j) {
        }
        int extraInt = j == a.length ? 1 : 0;
        int[] result = new int[a.length - keep + extraInt];
        for (i = keep; i < a.length; ++i) {
            result[i - keep + extraInt] = ~a[i];
        }
        i = result.length - 1;
        do {
            n = i--;
        } while ((result[n] = result[n] + 1) == 0);
        return result;
    }

    private int intLength() {
        return this.bitLength() / 32 + 1;
    }

    private int signBit() {
        return this.signum < 0 ? 1 : 0;
    }

    private int signInt() {
        return this.signum < 0 ? -1 : 0;
    }

    private int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.mag.length) {
            return this.signInt();
        }
        int magInt = this.mag[this.mag.length - n - 1];
        return this.signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private int firstNonzeroIntNum() {
        if (this.firstNonzeroIntNum == -2) {
            int i;
            for (i = this.mag.length - 1; i >= 0 && this.mag[i] == 0; --i) {
            }
            this.firstNonzeroIntNum = this.mag.length - i - 1;
        }
        return this.firstNonzeroIntNum;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.signum = fields.get("signum", -2);
        byte[] magnitude = (byte[])fields.get("magnitude", null);
        if (this.signum < -1 || this.signum > 1) {
            String message = "BigInteger: Invalid signum value";
            if (fields.defaulted("signum")) {
                message = "BigInteger: Signum not present in stream";
            }
            throw new StreamCorruptedException(message);
        }
        if (magnitude.length == 0 != (this.signum == 0)) {
            String message = "BigInteger: signum-magnitude mismatch";
            if (fields.defaulted("magnitude")) {
                message = "BigInteger: Magnitude not present in stream";
            }
            throw new StreamCorruptedException(message);
        }
        this.bitLength = -1;
        this.bitCount = -1;
        this.firstNonzeroIntNum = -2;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
        this.mag = BigInteger.stripLeadingZeroBytes(magnitude);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("signum", this.signum);
        fields.put("magnitude", this.magSerializedForm());
        fields.put("bitCount", -1);
        fields.put("bitLength", -1);
        fields.put("lowestSetBit", -2);
        fields.put("firstNonzeroByteNum", -2);
        s.writeFields();
    }

    private byte[] magSerializedForm() {
        int bitLen = this.mag.length == 0 ? 0 : (this.mag.length - 1 << 5) + BigInteger.bitLen(this.mag[0]);
        int byteLen = (bitLen + 7) / 8;
        byte[] result = new byte[byteLen];
        int bytesCopied = 4;
        int intIndex = this.mag.length - 1;
        int nextInt = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                nextInt = this.mag[intIndex--];
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            result[i] = (byte)nextInt;
        }
        return result;
    }

    static {
        int i;
        bitsPerDigit = new long[]{0L, 0L, 1024L, 1624L, 2048L, 2378L, 2648L, 2875L, 3072L, 3247L, 3402L, 3543L, 3672L, 3790L, 3899L, 4001L, 4096L, 4186L, 4271L, 4350L, 4426L, 4498L, 4567L, 4633L, 4696L, 4756L, 4814L, 4870L, 4923L, 4975L, 5025L, 5074L, 5120L, 5166L, 5210L, 5253L, 5295L};
        SMALL_PRIME_PRODUCT = BigInteger.valueOf(152125131763605L);
        posConst = new BigInteger[17];
        negConst = new BigInteger[17];
        for (i = 1; i <= 16; ++i) {
            int[] magnitude = new int[]{i};
            BigInteger.posConst[i] = new BigInteger(magnitude, 1);
            BigInteger.negConst[i] = new BigInteger(magnitude, -1);
        }
        ZERO = new BigInteger(new int[0], 0);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        TEN = BigInteger.valueOf(10L);
        bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        for (i = 0; i < 63; ++i) {
            BigInteger.zeros[i] = zeros[63].substring(0, i);
        }
        digitsPerLong = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        longRadix = new BigInteger[]{null, null, BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(7450580596923828125L), BigInteger.valueOf(4738381338321616896L), BigInteger.valueOf(3909821048582988049L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1350851717672992089L), BigInteger.valueOf(1000000000000000000L), BigInteger.valueOf(5559917313492231481L), BigInteger.valueOf(2218611106740436992L), BigInteger.valueOf(8650415919381337933L), BigInteger.valueOf(2177953337809371136L), BigInteger.valueOf(6568408355712890625L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(2862423051509815793L), BigInteger.valueOf(6746640616477458432L), BigInteger.valueOf(799006685782884121L), BigInteger.valueOf(1638400000000000000L), BigInteger.valueOf(3243919932521508681L), BigInteger.valueOf(6221821273427820544L), BigInteger.valueOf(504036361936467383L), BigInteger.valueOf(876488338465357824L), BigInteger.valueOf(1490116119384765625L), BigInteger.valueOf(2481152873203736576L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(6502111422497947648L), BigInteger.valueOf(353814783205469041L), BigInteger.valueOf(531441000000000000L), BigInteger.valueOf(787662783788549761L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1667889514952984961L), BigInteger.valueOf(2386420683693101056L), BigInteger.valueOf(3379220508056640625L), BigInteger.valueOf(4738381338321616896L)};
        digitsPerInt = new int[]{0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        intRadix = new int[]{0, 0, 0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("signum", Integer.TYPE), new ObjectStreamField("magnitude", byte[].class), new ObjectStreamField("bitCount", Integer.TYPE), new ObjectStreamField("bitLength", Integer.TYPE), new ObjectStreamField("firstNonzeroByteNum", Integer.TYPE), new ObjectStreamField("lowestSetBit", Integer.TYPE)};
    }
}

