/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    protected AttachmentSet attachmentSet;
    private WSDLBoundOperation operation = null;
    private Boolean isOneWay;
    private String uuid;

    public abstract boolean hasHeaders();

    @NotNull
    public abstract HeaderList getHeaders();

    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new AttachmentSetImpl();
        }
        return this.attachmentSet;
    }

    protected boolean hasAttachments() {
        return this.attachmentSet != null;
    }

    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLBoundPortType boundPortType) {
        if (this.operation == null) {
            this.operation = boundPortType.getOperation(this.getPayloadNamespaceURI(), this.getPayloadLocalPart());
        }
        return this.operation;
    }

    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLPort port) {
        return this.getOperation(port.getBinding());
    }

    @Nullable
    public final JavaMethod getMethod(@NotNull SEIModel seiModel) {
        String nsUri;
        String localPart = this.getPayloadLocalPart();
        if (localPart == null) {
            localPart = "";
            nsUri = "";
        } else {
            nsUri = this.getPayloadNamespaceURI();
        }
        QName name = new QName(nsUri, localPart);
        return seiModel.getJavaMethod(name);
    }

    public boolean isOneWay(@NotNull WSDLPort port) {
        if (this.isOneWay == null) {
            WSDLBoundOperation op = this.getOperation(port);
            this.isOneWay = op != null ? Boolean.valueOf(op.getOperation().isOneWay()) : Boolean.valueOf(false);
        }
        return this.isOneWay;
    }

    public final void assertOneWay(boolean value) {
        assert (this.isOneWay == null || this.isOneWay == value);
        this.isOneWay = value;
    }

    @Nullable
    public abstract String getPayloadLocalPart();

    public abstract String getPayloadNamespaceURI();

    public abstract boolean hasPayload();

    public boolean isFault() {
        String localPart = this.getPayloadLocalPart();
        if (localPart == null || !localPart.equals("Fault")) {
            return false;
        }
        String nsUri = this.getPayloadNamespaceURI();
        return nsUri.equals(SOAPVersion.SOAP_11.nsUri) || nsUri.equals(SOAPVersion.SOAP_12.nsUri);
    }

    @Nullable
    public QName getFirstDetailEntryName() {
        assert (this.isFault());
        Message msg = this.copy();
        try {
            SOAPFaultBuilder fault = SOAPFaultBuilder.create(msg);
            return fault.getFirstDetailEntryName();
        }
        catch (JAXBException e) {
            throw new WebServiceException(e);
        }
    }

    public abstract Source readEnvelopeAsSource();

    public abstract Source readPayloadAsSource();

    public abstract SOAPMessage readAsSOAPMessage() throws SOAPException;

    public SOAPMessage readAsSOAPMessage(Packet packet, boolean inbound) throws SOAPException {
        return this.readAsSOAPMessage();
    }

    public abstract <T> T readPayloadAsJAXB(Unmarshaller var1) throws JAXBException;

    public abstract <T> T readPayloadAsJAXB(Bridge<T> var1) throws JAXBException;

    public abstract XMLStreamReader readPayload() throws XMLStreamException;

    public void consume() {
    }

    public abstract void writePayloadTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(ContentHandler var1, ErrorHandler var2) throws SAXException;

    public abstract Message copy();

    @NotNull
    public String getID(@NotNull WSBinding binding) {
        return this.getID(binding.getAddressingVersion(), binding.getSOAPVersion());
    }

    @NotNull
    public String getID(AddressingVersion av, SOAPVersion sv) {
        if (this.uuid == null) {
            if (av != null) {
                this.uuid = this.getHeaders().getMessageID(av, sv);
            }
            if (this.uuid == null) {
                this.uuid = "uuid:" + UUID.randomUUID().toString();
            }
        }
        return this.uuid;
    }
}

