/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.implementations.XPath2NodeFilter;
import com.sun.org.apache.xml.internal.security.transforms.params.XPath2FilterContainer;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathFuncHereAPI;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
        try {
            ArrayList<NodeList> unionNodes = new ArrayList<NodeList>();
            ArrayList<NodeList> substractNodes = new ArrayList<NodeList>();
            ArrayList<NodeList> intersectNodes = new ArrayList<NodeList>();
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Element[] xpathElements = XMLUtils.selectNodes(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath");
            int noOfSteps = xpathElements.length;
            if (noOfSteps == 0) {
                Object[] exArgs = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            Document inputDoc = null;
            inputDoc = input.getSubNode() != null ? XMLUtils.getOwnerDocument(input.getSubNode()) : XMLUtils.getOwnerDocument(input.getNodeSet());
            for (int i = 0; i < noOfSteps; ++i) {
                Element xpathElement = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath", i);
                XPath2FilterContainer xpathContainer = XPath2FilterContainer.newInstance(xpathElement, input.getSourceURI());
                NodeList subtreeRoots = xPathFuncHereAPI.selectNodeList(inputDoc, xpathContainer.getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(xpathContainer.getXPathFilterTextNode()), xpathContainer.getElement());
                if (xpathContainer.isIntersect()) {
                    intersectNodes.add(subtreeRoots);
                    continue;
                }
                if (xpathContainer.isSubtract()) {
                    substractNodes.add(subtreeRoots);
                    continue;
                }
                if (!xpathContainer.isUnion()) continue;
                unionNodes.add(subtreeRoots);
            }
            input.setNeedsToBeExpanded(true);
            input.addNodeFilter(new XPath2NodeFilter(unionNodes, substractNodes, intersectNodes));
            input.setNodeSet(true);
            return input;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
    }
}

