/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAbstractResampler;

public class SoftLanczosResampler
extends SoftAbstractResampler {
    float[][] sinc_table;
    int sinc_table_fsize = 2000;
    int sinc_table_size = 5;
    int sinc_table_center = this.sinc_table_size / 2;

    public SoftLanczosResampler() {
        this.sinc_table = new float[this.sinc_table_fsize][];
        for (int i = 0; i < this.sinc_table_fsize; ++i) {
            this.sinc_table[i] = SoftLanczosResampler.sincTable(this.sinc_table_size, (float)(-i) / (float)this.sinc_table_fsize);
        }
    }

    public static double sinc(double x) {
        return x == 0.0 ? 1.0 : Math.sin(Math.PI * x) / (Math.PI * x);
    }

    public static float[] sincTable(int size, float offset) {
        int center = size / 2;
        float[] w = new float[size];
        for (int k = 0; k < size; ++k) {
            float x = (float)(-center + k) + offset;
            w[k] = x < -2.0f || x > 2.0f ? 0.0f : (x == 0.0f ? 1.0f : (float)(2.0 * Math.sin(Math.PI * (double)x) * Math.sin(Math.PI * (double)x / 2.0) / (Math.PI * (double)x * (Math.PI * (double)x))));
        }
        return w;
    }

    public int getPadding() {
        return this.sinc_table_size / 2 + 2;
    }

    public void interpolate(float[] in, float[] in_offset, float in_end, float[] startpitch, float pitchstep, float[] out, int[] out_offset, int out_end) {
        float ix;
        float pitch = startpitch[0];
        int ox = out_offset[0];
        float ix_end = in_end;
        int ox_end = out_end;
        if (pitchstep == 0.0f) {
            for (ix = in_offset[0]; ix < ix_end && ox < ox_end; ix += pitch) {
                int iix = (int)ix;
                float[] sinc_table = this.sinc_table[(int)((ix - (float)iix) * (float)this.sinc_table_fsize)];
                int xx = iix - this.sinc_table_center;
                float y = 0.0f;
                int i = 0;
                while (i < this.sinc_table_size) {
                    y += in[xx] * sinc_table[i];
                    ++i;
                    ++xx;
                }
                out[ox++] = y;
            }
        } else {
            while (ix < ix_end && ox < ox_end) {
                int iix = (int)ix;
                float[] sinc_table = this.sinc_table[(int)((ix - (float)iix) * (float)this.sinc_table_fsize)];
                int xx = iix - this.sinc_table_center;
                float y = 0.0f;
                int i = 0;
                while (i < this.sinc_table_size) {
                    y += in[xx] * sinc_table[i];
                    ++i;
                    ++xx;
                }
                out[ox++] = y;
                ix += pitch;
                pitch += pitchstep;
            }
        }
        in_offset[0] = ix;
        out_offset[0] = ox;
        startpitch[0] = pitch;
    }
}

