/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JConsolePlugin {
    private volatile JConsoleContext context = null;
    private List<PropertyChangeListener> listeners = null;

    protected JConsolePlugin() {
    }

    public final synchronized void setContext(JConsoleContext context) {
        this.context = context;
        if (this.listeners != null) {
            for (PropertyChangeListener l : this.listeners) {
                context.addPropertyChangeListener(l);
            }
            this.listeners = null;
        }
    }

    public final JConsoleContext getContext() {
        return this.context;
    }

    public abstract Map<String, JPanel> getTabs();

    public abstract SwingWorker<?, ?> newSwingWorker();

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addContextPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this.context == null) {
            JConsolePlugin jConsolePlugin = this;
            synchronized (jConsolePlugin) {
                if (this.context == null) {
                    if (this.listeners == null) {
                        this.listeners = new ArrayList<PropertyChangeListener>();
                    }
                    this.listeners.add(listener);
                    return;
                }
            }
        }
        this.context.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeContextPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this.context == null) {
            JConsolePlugin jConsolePlugin = this;
            synchronized (jConsolePlugin) {
                if (this.context == null) {
                    if (this.listeners != null) {
                        this.listeners.remove(listener);
                    }
                    return;
                }
            }
        }
        this.context.removePropertyChangeListener(listener);
    }
}

