/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class DBCS_IBM_EBCDIC_Encoder
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private int currentState;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DBCS_IBM_EBCDIC_Encoder(Charset cs) {
        super(cs, 4.0f, 5.0f, new byte[]{111});
    }

    protected void implReset() {
        this.currentState = 0;
    }

    protected CoderResult implFlush(ByteBuffer out) {
        if (this.currentState == 1) {
            if (out.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            out.put((byte)15);
        }
        this.implReset();
        return CoderResult.UNDERFLOW;
    }

    public boolean canEncode(char ch) {
        int index = this.index1[(ch & this.mask1) >> this.shift] + (ch & this.mask2);
        char theBytes = index < 15000 ? this.index2.charAt(index) : this.index2a.charAt(index - 15000);
        if (theBytes != '\u0000') {
            return true;
        }
        return ch == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        int sp;
        char[] sa = src.array();
        int sl = src.arrayOffset() + src.limit();
        byte[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        boolean outputSize = false;
        try {
            for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                char c = sa[sp];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int index = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char theBytes = index < 15000 ? this.index2.charAt(index) : this.index2a.charAt(index - 15000);
                this.b1 = (byte)((theBytes & 0xFF00) >> 8);
                this.b2 = (byte)(theBytes & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    da[dp++] = 15;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    da[dp++] = 14;
                }
                int spaceNeeded = this.currentState == 1 ? 2 : 1;
                if (dl - dp < spaceNeeded) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    da[dp++] = this.b2;
                    continue;
                }
                da[dp++] = this.b1;
                da[dp++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        boolean outputSize = false;
        try {
            while (src.hasRemaining()) {
                char c = src.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, src) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int index = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char theBytes = index < 15000 ? this.index2.charAt(index) : this.index2a.charAt(index - 15000);
                this.b1 = (byte)((theBytes & 0xFF00) >> 8);
                this.b2 = (byte)(theBytes & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (dst.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    dst.put((byte)15);
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (dst.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    dst.put((byte)14);
                }
                int spaceNeeded = this.currentState == 1 ? 2 : 1;
                if (dst.remaining() < spaceNeeded) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    dst.put(this.b2);
                } else {
                    dst.put(this.b1);
                    dst.put(this.b2);
                }
                ++mark;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }
}

