/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import sun.net.www.ParseUtil;
import sun.security.util.Debug;
import sun.security.util.Password;

public class PolicyUtil {
    private static final String P11KEYSTORE = "PKCS11";
    private static final String NONE = "NONE";

    public static InputStream getInputStream(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
            return new FileInputStream(path);
        }
        return url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore getKeyStore(URL policyUrl, String keyStoreName, String keyStoreType, String keyStoreProvider, String storePassURL, Debug debug) throws KeyStoreException, MalformedURLException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        char[] keyStorePassword;
        block21: {
            Object passURL;
            block20: {
                if (keyStoreName == null) {
                    throw new IllegalArgumentException("null KeyStore name");
                }
                keyStorePassword = null;
                try {
                    KeyStore ks;
                    block19: {
                        if (keyStoreType == null) {
                            keyStoreType = KeyStore.getDefaultType();
                        }
                        if (P11KEYSTORE.equalsIgnoreCase(keyStoreType) && !NONE.equals(keyStoreName)) {
                            throw new IllegalArgumentException("Invalid value (" + keyStoreName + ") for keystore URL.  If the keystore type is \"" + P11KEYSTORE + "\", the keystore url must be \"" + NONE + "\"");
                        }
                        ks = keyStoreProvider != null ? KeyStore.getInstance(keyStoreType, keyStoreProvider) : KeyStore.getInstance(keyStoreType);
                        if (storePassURL != null) {
                            try {
                                passURL = new URL(storePassURL);
                            }
                            catch (MalformedURLException e) {
                                if (policyUrl == null) {
                                    throw e;
                                }
                                passURL = new URL(policyUrl, storePassURL);
                            }
                            if (debug != null) {
                                debug.println("reading password" + passURL);
                            }
                            InputStream in = null;
                            try {
                                in = ((URL)passURL).openStream();
                                keyStorePassword = Password.readPassword(in);
                                Object var11_12 = null;
                                if (in == null) break block19;
                            }
                            catch (Throwable throwable) {
                                Object var11_13 = null;
                                if (in == null) throw throwable;
                                in.close();
                                throw throwable;
                            }
                            in.close();
                        }
                    }
                    if (NONE.equals(keyStoreName)) {
                        ks.load(null, keyStorePassword);
                        passURL = ks;
                        Object var15_16 = null;
                        if (keyStorePassword == null) return passURL;
                        break block20;
                    }
                    URL keyStoreUrl = null;
                    try {
                        keyStoreUrl = new URL(keyStoreName);
                    }
                    catch (MalformedURLException e) {
                        if (policyUrl == null) {
                            throw e;
                        }
                        keyStoreUrl = new URL(policyUrl, keyStoreName);
                    }
                    if (debug != null) {
                        debug.println("reading keystore" + keyStoreUrl);
                    }
                    BufferedInputStream inStream = null;
                    try {
                        inStream = new BufferedInputStream(PolicyUtil.getInputStream(keyStoreUrl));
                        ks.load(inStream, keyStorePassword);
                        Object var13_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_20 = null;
                        ((InputStream)inStream).close();
                        throw throwable;
                    }
                    ((InputStream)inStream).close();
                    keyStore = ks;
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    if (keyStorePassword == null) throw throwable;
                    Arrays.fill(keyStorePassword, ' ');
                    throw throwable;
                }
            }
            Arrays.fill(keyStorePassword, ' ');
            return passURL;
        }
        Object var15_17 = null;
        if (keyStorePassword == null) return keyStore;
        Arrays.fill(keyStorePassword, ' ');
        return keyStore;
    }
}

