/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool tool, ToolWindow tw) {
        this.tool = tool;
        this.tw = tw;
    }

    public void actionPerformed(ActionEvent e) {
        block17: {
            if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.QUIT) == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                td.displayUserSave(1);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.NEW_POLICY_FILE) == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                td.displayUserSave(2);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.OPEN_POLICY_FILE) == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                td.displayUserSave(3);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.SAVE_POLICY_FILE) == 0) {
                String filename = ((TextField)this.tw.getComponent(1)).getText();
                if (filename == null || filename.length() == 0) {
                    ToolDialog td = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, true);
                    td.displaySaveAsDialog(0);
                } else {
                    try {
                        this.tool.savePolicy(filename);
                        MessageFormat form = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                        Object[] source = new Object[]{filename};
                        this.tw.displayStatusDialog(null, form.format(source));
                    }
                    catch (FileNotFoundException fnfe) {
                        if (filename == null || filename.equals("")) {
                            this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null filename")));
                            break block17;
                        }
                        this.tw.displayErrorDialog(null, fnfe);
                    }
                    catch (Exception ee) {
                        this.tw.displayErrorDialog(null, ee);
                    }
                }
            } else if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.SAVE_AS_POLICY_FILE) == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, true);
                td.displaySaveAsDialog(0);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), ToolWindow.VIEW_WARNINGS) == 0) {
                this.tw.displayWarningLog(null);
            }
        }
    }
}

