/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class RSAPrivateKeyImpl
extends PKCS8Key
implements RSAPrivateKey {
    private static final long serialVersionUID = -33106691987952810L;
    private final BigInteger n;
    private final BigInteger d;

    RSAPrivateKeyImpl(BigInteger n, BigInteger d) throws InvalidKeyException {
        this.n = n;
        this.d = d;
        RSAKeyFactory.checkRSAProviderKeyLengths(n.bitLength(), null);
        this.algid = RSAPrivateCrtKeyImpl.rsaId;
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(0);
            out.putInteger(n);
            out.putInteger(0);
            out.putInteger(d);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public String toString() {
        return "Sun RSA private key, " + this.n.bitLength() + " bits\n  modulus: " + this.n + "\n  private exponent: " + this.d;
    }
}

